/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.dom.ActivityAttributesSnapshot;
import com.android.tools.rendering.AndroidXmlFiles;
import com.android.tools.rendering.RenderTask;
import com.android.tools.rendering.api.RenderModelManifest;
import com.android.tools.rendering.api.RenderModelModule;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.security.RenderSecurityManager;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionBarHandler
extends ActionBarCallback {
    private static final String ON_CREATE_OPTIONS_MENU = "onCreateOptionsMenu";
    private static final Pattern MENU_FIELD_PATTERN = Pattern.compile("R\\.menu\\.([a-z0-9_]+)");
    @Nullable
    private final Object myCredential;
    @NotNull
    private final RenderTask myRenderTask;
    @Nullable
    private ImmutableList<ResourceReference> myMenus;

    ActionBarHandler(@NotNull RenderTask renderTask2, @Nullable Object credential) {
        this.myRenderTask = renderTask2;
        this.myCredential = credential;
    }

    @Override
    public boolean getSplitActionBarWhenNarrow() {
        ActivityAttributesSnapshot attributes = this.getActivityAttributes();
        if (attributes != null) {
            return "splitActionBarWhenNarrow".equals(attributes.getUiOptions());
        }
        return false;
    }

    @Override
    public boolean isOverflowPopupNeeded() {
        return this.myRenderTask.getContext().getFolderType() == ResourceFolderType.MENU;
    }

    private void updateMenusInBackground(@NotNull Project project, @NotNull String fqn, @NotNull ResourceNamespace namespace) {
        Callable<Collection> calculateMenus = () -> {
            PsiClass clz = JavaPsiFacade.getInstance(project).findClass(fqn, GlobalSearchScope.allScope(project));
            if (clz != null) {
                for (PsiMethod method : clz.findMethodsByName(ON_CREATE_OPTIONS_MENU, true)) {
                    if (method instanceof PsiCompiledElement) continue;
                    String matchText = method.getText();
                    Matcher matcher = MENU_FIELD_PATTERN.matcher(matchText);
                    TreeSet<ResourceReference> menus = new TreeSet<ResourceReference>(Comparator.comparing(ResourceReference::getName));
                    int index2 = 0;
                    while (matcher.find(index2)) {
                        String name2 = matcher.group(1);
                        menus.add(new ResourceReference(namespace, ResourceType.MENU, name2));
                        index2 = matcher.end();
                    }
                    if (menus.isEmpty()) continue;
                    return menus;
                }
            }
            return ImmutableList.of();
        };
        ReadAction.nonBlocking(calculateMenus).inSmartMode(project).coalesceBy(project, this, fqn).finishOnUiThread(ModalityState.defaultModalityState(), menus -> {
            if (!menus.isEmpty()) {
                this.myMenus = ImmutableList.copyOf(menus);
            }
        }).submit(AppExecutorUtil.getAppExecutorService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<ResourceReference> getMenuIds() {
        if (this.myMenus != null) {
            return this.myMenus;
        }
        boolean token2 = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            String commaSeparatedMenus;
            RenderModelModule renderModule = this.myRenderTask.getContext().getModule();
            if (renderModule.isDisposed()) {
                List<ResourceReference> list2 = Collections.emptyList();
                return list2;
            }
            ResourceNamespace namespace = renderModule.getResourceRepositoryManager().getNamespace();
            RenderXmlFile xmlFile = this.myRenderTask.getXmlFile();
            String string2 = commaSeparatedMenus = xmlFile == null ? null : xmlFile.getRootTagAttribute("menu", "http://schemas.android.com/tools");
            if (commaSeparatedMenus != null) {
                List<String> names = Splitter.on(',').trimResults().omitEmptyStrings().splitToList(commaSeparatedMenus);
                this.myMenus = names.stream().map(name2 -> new ResourceReference(namespace, ResourceType.MENU, (String)name2)).collect(ImmutableList.toImmutableList());
            } else {
                String fqn;
                String string3 = fqn = xmlFile == null ? null : AndroidXmlFiles.getDeclaredContextFqcn(this.myRenderTask.getContext().getModule().getResourcePackage(), xmlFile);
                if (fqn != null) {
                    this.updateMenusInBackground(xmlFile.getProject(), fqn, namespace);
                }
            }
            if (this.myMenus == null) {
                this.myMenus = ImmutableList.of();
            }
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token2);
        }
        return this.myMenus;
    }

    @Override
    public ActionBarCallback.HomeButtonStyle getHomeButtonStyle() {
        ActivityAttributesSnapshot attributes = this.getActivityAttributes();
        if (attributes != null && attributes.getParentActivity() != null) {
            return ActionBarCallback.HomeButtonStyle.SHOW_HOME_AS_UP;
        }
        return ActionBarCallback.HomeButtonStyle.NONE;
    }

    @Override
    public int getNavigationMode() {
        RenderXmlFile xmlFile = this.myRenderTask.getXmlFile();
        String navMode = StringUtil.notNullize(xmlFile == null ? null : xmlFile.getRootTagAttribute("actionBarNavMode", "http://schemas.android.com/tools")).trim();
        if (navMode.equalsIgnoreCase("tabs")) {
            return 2;
        }
        if (navMode.equalsIgnoreCase("list")) {
            return 1;
        }
        return 0;
    }

    public void setMenuIds(@Nullable List<ResourceReference> menus) {
        this.myMenus = menus != null ? ImmutableList.copyOf(menus) : ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ActivityAttributesSnapshot getActivityAttributes() {
        boolean token2 = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            RenderModelManifest manifest = this.myRenderTask.getContext().getModule().getManifest();
            String activity = StringUtil.notNullize(this.myRenderTask.getContext().getConfiguration().getActivity());
            ActivityAttributesSnapshot activityAttributesSnapshot = manifest != null ? manifest.getActivityAttributes(activity) : null;
            return activityAttributesSnapshot;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token2);
        }
    }
}

