/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.configurations.Configuration;
import com.android.tools.rendering.api.RenderModelModule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/rendering/RenderContext;", "", "module", "Lcom/android/tools/rendering/api/RenderModelModule;", "configuration", "Lcom/android/tools/configurations/Configuration;", "(Lcom/android/tools/rendering/api/RenderModelModule;Lcom/android/tools/configurations/Configuration;)V", "getConfiguration", "()Lcom/android/tools/configurations/Configuration;", "folderType", "Lcom/android/resources/ResourceFolderType;", "getFolderType", "()Lcom/android/resources/ResourceFolderType;", "setFolderType", "(Lcom/android/resources/ResourceFolderType;)V", "minSdkVersion", "Lcom/android/sdklib/AndroidVersion;", "getMinSdkVersion", "()Lcom/android/sdklib/AndroidVersion;", "getModule", "()Lcom/android/tools/rendering/api/RenderModelModule;", "targetSdkVersion", "getTargetSdkVersion", "unnamed"})
public final class RenderContext {
    @NotNull
    private final RenderModelModule module;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final AndroidVersion minSdkVersion;
    @NotNull
    private final AndroidVersion targetSdkVersion;
    @Nullable
    private ResourceFolderType folderType;

    public RenderContext(@NotNull RenderModelModule module, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter(module, "module");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        this.module = module;
        this.configuration = configuration;
        Object object = this.module.getInfo();
        if (object == null || (object = object.getMinSdkVersion()) == null) {
            AndroidVersion androidVersion = AndroidVersion.DEFAULT;
            object = androidVersion;
            Intrinsics.checkNotNullExpressionValue(androidVersion, "DEFAULT");
        }
        this.minSdkVersion = object;
        Object object2 = this.module.getInfo();
        if (object2 == null || (object2 = object2.getTargetSdkVersion()) == null) {
            AndroidVersion androidVersion = AndroidVersion.DEFAULT;
            object2 = androidVersion;
            Intrinsics.checkNotNullExpressionValue(androidVersion, "DEFAULT");
        }
        this.targetSdkVersion = object2;
    }

    @NotNull
    public final RenderModelModule getModule() {
        return this.module;
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final AndroidVersion getMinSdkVersion() {
        return this.minSdkVersion;
    }

    @NotNull
    public final AndroidVersion getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    @Nullable
    public final ResourceFolderType getFolderType() {
        return this.folderType;
    }

    public final void setFolderType(@Nullable ResourceFolderType resourceFolderType) {
        this.folderType = resourceFolderType;
    }
}

