/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.tools.rendering.RenderAsyncActionExecutor;
import com.android.tools.rendering.RenderExecutor;
import com.android.tools.rendering.RenderExecutorKt;
import com.android.tools.rendering.SingleThreadExecutorService;
import com.android.tools.rendering.ThreadProfileSettings;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 F2\u00020\u0001:\u0004FGHIB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010 \u001a\u00020\u00032\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0011\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*\u00a2\u0006\u0002\u0010,J\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020$J\u0006\u00100\u001a\u00020$J!\u00101\u001a\u0002H2\"\u0004\b\u0000\u001022\f\u00103\u001a\b\u0012\u0004\u0012\u0002H204H\u0007\u00a2\u0006\u0002\u00105JJ\u00106\u001a\b\u0012\u0004\u0012\u0002H207\"\u0004\b\u0000\u001022\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020:2\u0006\u0010=\u001a\u00020\u001b2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H204H\u0016J*\u0010>\u001a\u0006\u0012\u0002\b\u00030?2\u0006\u0010@\u001a\u00020\u00122\u0006\u0010A\u001a\u00020:2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020.0CH\u0002J\u0006\u0010D\u001a\u00020.J\u0010\u0010D\u001a\u00020.2\u0006\u0010E\u001a\u00020\u0012H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\rR$\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u001b\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/android/tools/rendering/RenderExecutor;", "Lcom/android/tools/rendering/RenderAsyncActionExecutor;", "maxQueueingTasks", "", "renderingExecutorService", "Lcom/android/tools/rendering/SingleThreadExecutorService;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "(ILcom/android/tools/rendering/SingleThreadExecutorService;Ljava/util/concurrent/ScheduledExecutorService;)V", "accumulatedTimeoutExceptions", "Ljava/util/concurrent/atomic/AtomicInteger;", "accumulatedTimeouts", "getAccumulatedTimeouts", "()I", "allPendingActionsQueue", "Ljava/util/Queue;", "Lcom/android/tools/rendering/RenderExecutor$PriorityCompletableFuture;", "executedRenderActionCount", "", "getExecutedRenderActionCount", "()J", "executedRenderActions", "Ljava/util/concurrent/atomic/LongAdder;", "numPendingActions", "getNumPendingActions", "pendingActionsQueueByTopic", "", "Lcom/android/tools/rendering/RenderAsyncActionExecutor$RenderingTopic;", "pendingActionsQueueLock", "Ljava/util/concurrent/locks/Lock;", "runningRender", "runningRenderLock", "cancelActionsByTopic", "topicsToCancel", "", "mayInterruptIfRunning", "", "createRenderTimeoutException", "Ljava/util/concurrent/TimeoutException;", "message", "", "currentStackTrace", "", "Ljava/lang/StackTraceElement;", "()[Ljava/lang/StackTraceElement;", "interrupt", "", "isBusy", "isRenderThread", "runAction", "T", "callable", "Ljava/util/concurrent/Callable;", "(Ljava/util/concurrent/Callable;)Ljava/lang/Object;", "runAsyncActionWithTimeout", "Ljava/util/concurrent/CompletableFuture;", "queueingTimeout", "queueingTimeoutUnit", "Ljava/util/concurrent/TimeUnit;", "actionTimeout", "actionTimeoutUnit", "renderingTopic", "scheduleTimeoutAction", "Ljava/util/concurrent/ScheduledFuture;", "timeout", "unit", "action", "Lkotlin/Function0;", "shutdown", "timeoutSeconds", "Companion", "EvictedException", "PriorityCompletableFuture", "PriorityRunnable", "unnamed"})
@SourceDebugExtension(value={"SMAP\nRenderExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderExecutor.kt\ncom/android/tools/rendering/RenderExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,357:1\n1#2:358\n372#3,7:359\n1855#4,2:366\n*S KotlinDebug\n*F\n+ 1 RenderExecutor.kt\ncom/android/tools/rendering/RenderExecutor\n*L\n153#1:359,7\n165#1:366,2\n*E\n"})
public final class RenderExecutor
implements RenderAsyncActionExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxQueueingTasks;
    @NotNull
    private final SingleThreadExecutorService renderingExecutorService;
    @NotNull
    private final ScheduledExecutorService scheduledExecutorService;
    @NotNull
    private final Lock pendingActionsQueueLock;
    @NotNull
    private final Lock runningRenderLock;
    @NotNull
    private final Queue<PriorityCompletableFuture<?>> allPendingActionsQueue;
    @NotNull
    private final Map<RenderAsyncActionExecutor.RenderingTopic, Queue<PriorityCompletableFuture<?>>> pendingActionsQueueByTopic;
    @Nullable
    private PriorityCompletableFuture<?> runningRender;
    @NotNull
    private final AtomicInteger accumulatedTimeoutExceptions;
    @NotNull
    private final LongAdder executedRenderActions;

    private RenderExecutor(int maxQueueingTasks, SingleThreadExecutorService renderingExecutorService, ScheduledExecutorService scheduledExecutorService) {
        this.maxQueueingTasks = maxQueueingTasks;
        this.renderingExecutorService = renderingExecutorService;
        this.scheduledExecutorService = scheduledExecutorService;
        this.pendingActionsQueueLock = new ReentrantLock();
        this.runningRenderLock = new ReentrantLock();
        this.allPendingActionsQueue = new PriorityQueue();
        this.pendingActionsQueueByTopic = new EnumMap(RenderAsyncActionExecutor.RenderingTopic.class);
        this.accumulatedTimeoutExceptions = new AtomicInteger(0);
        this.executedRenderActions = new LongAdder();
    }

    public final void interrupt() {
        this.renderingExecutorService.interrupt();
    }

    public final void shutdown() {
        this.scheduledExecutorService.shutdownNow();
        this.renderingExecutorService.shutdownNow();
    }

    @NotNull
    public final StackTraceElement[] currentStackTrace() {
        return this.renderingExecutorService.stackTrace();
    }

    private final TimeoutException createRenderTimeoutException(String message2) {
        TimeoutException timeoutException;
        TimeoutException $this$createRenderTimeoutException_u24lambda_u240 = timeoutException = new TimeoutException(message2);
        boolean bl2 = false;
        $this$createRenderTimeoutException_u24lambda_u240.setStackTrace(this.renderingExecutorService.stackTrace());
        return timeoutException;
    }

    @Deprecated(message="Use the async version runAsyncAction")
    public final <T> T runAction(@NotNull Callable<T> callable) throws Exception {
        Intrinsics.checkNotNullParameter(callable, "callable");
        if (this.accumulatedTimeoutExceptions.get() > 3) {
            throw this.createRenderTimeoutException("\n          The rendering thread is not processing requests.\n          This typically happens when there is an infinite loop or unbounded recursion in one of the custom views.\n          ");
        }
        return this.runAsyncAction(RenderAsyncActionExecutor.RenderingTopic.NOT_SPECIFIED, callable).get();
    }

    private final ScheduledFuture<?> scheduleTimeoutAction(long timeout, TimeUnit unit, Function0<Unit> action2) {
        ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.schedule(new Runnable(action2){
            private final /* synthetic */ Function0 function;
            {
                Intrinsics.checkNotNullParameter(function, "function");
                this.function = function;
            }

            public final /* synthetic */ void run() {
                this.function.invoke();
            }
        }, timeout, unit);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, "scheduledExecutorService\u2026le(action, timeout, unit)");
        return scheduledFuture;
    }

    @Override
    public long getExecutedRenderActionCount() {
        return this.executedRenderActions.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> CompletableFuture<T> runAsyncActionWithTimeout(long queueingTimeout, @NotNull TimeUnit queueingTimeoutUnit, long actionTimeout, @NotNull TimeUnit actionTimeoutUnit, @NotNull RenderAsyncActionExecutor.RenderingTopic renderingTopic, @NotNull Callable<T> callable) {
        void $this$forEach$iv;
        List $i$a$-withLock-RenderExecutor$runAsyncActionWithTimeout$22;
        Intrinsics.checkNotNullParameter((Object)queueingTimeoutUnit, "queueingTimeoutUnit");
        Intrinsics.checkNotNullParameter((Object)actionTimeoutUnit, "actionTimeoutUnit");
        Intrinsics.checkNotNullParameter((Object)renderingTopic, "renderingTopic");
        Intrinsics.checkNotNullParameter(callable, "callable");
        PriorityCompletableFuture future2 = new PriorityCompletableFuture<T>(renderingTopic, this){
            final /* synthetic */ RenderExecutor this$0;
            {
                this.this$0 = $receiver;
                super($renderingTopic);
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean bl2 = super.cancel(mayInterruptIfRunning);
                RenderExecutor renderExecutor = this.this$0;
                boolean it = bl2;
                boolean bl3 = false;
                if (mayInterruptIfRunning && it) {
                    renderExecutor.interrupt();
                }
                return bl2;
            }
        };
        ScheduledFuture<?> queueTimeoutFuture2 = queueingTimeout > 0L ? this.scheduleTimeoutAction(queueingTimeout, queueingTimeoutUnit, new Function0<Unit>(queueingTimeoutUnit, queueingTimeout, future2, this){
            final /* synthetic */ TimeUnit $queueingTimeoutUnit;
            final /* synthetic */ long $queueingTimeout;
            final /* synthetic */ runAsyncActionWithTimeout.future.1<T> $future;
            final /* synthetic */ RenderExecutor this$0;
            {
                this.$queueingTimeoutUnit = $queueingTimeoutUnit;
                this.$queueingTimeout = $queueingTimeout;
                this.$future = $future;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                String message2 = StringsKt.trimIndent("\n        Preview timed out (" + this.$queueingTimeoutUnit.toMillis(this.$queueingTimeout) + "ms).\n        This typically happens when there is an infinite loop or unbounded recursion in one of the custom views.\n      ");
                this.$future.completeExceptionally((Throwable)RenderExecutor.access$createRenderTimeoutException(this.this$0, message2));
                RenderExecutor.access$getAccumulatedTimeoutExceptions$p(this.this$0).incrementAndGet();
            }
        }) : null;
        Object object = this.pendingActionsQueueLock;
        object.lock();
        try {
            List list2;
            Queue queue;
            boolean $i$a$-withLock-RenderExecutor$runAsyncActionWithTimeout$22 = false;
            this.allPendingActionsQueue.add(future2);
            Map<RenderAsyncActionExecutor.RenderingTopic, Queue<PriorityCompletableFuture<?>>> $this$getOrPut$iv = this.pendingActionsQueueByTopic;
            boolean $i$f$getOrPut = false;
            Queue value$iv = $this$getOrPut$iv.get((Object)renderingTopic);
            if (value$iv == null) {
                boolean bl2 = false;
                Queue answer$iv = new PriorityQueue();
                $this$getOrPut$iv.put(renderingTopic, answer$iv);
                queue = answer$iv;
            } else {
                queue = value$iv;
            }
            queue.add(future2);
            if (this.maxQueueingTasks > 0) {
                List evictedTasks = new ArrayList();
                while (this.allPendingActionsQueue.size() > this.maxQueueingTasks) {
                    PriorityCompletableFuture<?> evicted = this.allPendingActionsQueue.remove();
                    Queue<PriorityCompletableFuture<?>> queue2 = this.pendingActionsQueueByTopic.get((Object)evicted.getRenderingTopic());
                    if (queue2 != null) {
                        queue2.remove(evicted);
                    }
                    Intrinsics.checkNotNullExpressionValue(evicted, "evicted");
                    evictedTasks.add(evicted);
                }
                list2 = evictedTasks;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $i$a$-withLock-RenderExecutor$runAsyncActionWithTimeout$22 = list2;
        }
        finally {
            object.unlock();
        }
        object = $i$a$-withLock-RenderExecutor$runAsyncActionWithTimeout$22;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompletableFuture it = (CompletableFuture)element$iv;
            boolean bl3 = false;
            it.completeExceptionally(new EvictedException("Max number (" + this.maxQueueingTasks + ") of render actions reached"));
        }
        this.renderingExecutorService.execute(new PriorityRunnable(renderingTopic, new Runnable(this, queueTimeoutFuture2, future2, actionTimeout, actionTimeoutUnit, callable, renderingTopic){
            final /* synthetic */ RenderExecutor this$0;
            final /* synthetic */ ScheduledFuture<?> $queueTimeoutFuture;
            final /* synthetic */ runAsyncActionWithTimeout.future.1<T> $future;
            final /* synthetic */ long $actionTimeout;
            final /* synthetic */ TimeUnit $actionTimeoutUnit;
            final /* synthetic */ Callable<T> $callable;
            final /* synthetic */ RenderAsyncActionExecutor.RenderingTopic $renderingTopic;
            {
                this.this$0 = $receiver;
                this.$queueTimeoutFuture = $queueTimeoutFuture;
                this.$future = $future;
                this.$actionTimeout = $actionTimeout;
                this.$actionTimeoutUnit = $actionTimeoutUnit;
                this.$callable = $callable;
                this.$renderingTopic = $renderingTopic;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Object $i$a$-withLock-RenderExecutor$runAsyncActionWithTimeout$3$22;
                Lock lock = RenderExecutor.access$getRunningRenderLock$p(this.this$0);
                Object object = this.this$0;
                Object object2 = this.$future;
                lock.lock();
                try {
                    boolean $i$a$-withLock-RenderExecutor$runAsyncActionWithTimeout$3$22 = false;
                    RenderExecutor.access$setRunningRender$p((RenderExecutor)object, (PriorityCompletableFuture)object2);
                    $i$a$-withLock-RenderExecutor$runAsyncActionWithTimeout$3$22 = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                try {
                    boolean bl2;
                    RenderExecutor.access$getExecutedRenderActions$p(this.this$0).increment();
                    Thread.interrupted();
                    ScheduledFuture<?> scheduledFuture = this.$queueTimeoutFuture;
                    if (scheduledFuture != null) {
                        scheduledFuture.cancel(false);
                    }
                    object = RenderExecutor.access$getPendingActionsQueueLock$p(this.this$0);
                    object2 = this.this$0;
                    $i$a$-withLock-RenderExecutor$runAsyncActionWithTimeout$3$22 = this.$renderingTopic;
                    runAsyncActionWithTimeout.future.1<T> var5_20 = this.$future;
                    object.lock();
                    try {
                        boolean bl3 = false;
                        Queue queue = (Queue)RenderExecutor.access$getPendingActionsQueueByTopic$p((RenderExecutor)object2).get($i$a$-withLock-RenderExecutor$runAsyncActionWithTimeout$3$22);
                        if (queue != null) {
                            queue.remove(var5_20);
                        }
                        bl2 = RenderExecutor.access$getAllPendingActionsQueue$p((RenderExecutor)object2).remove(var5_20);
                    }
                    finally {
                        object.unlock();
                    }
                    boolean isPending = bl2;
                    if (!isPending || this.$future.isDone()) {
                        return;
                    }
                    ScheduledFuture actionTimeoutFuture2 = RenderExecutor.access$scheduleTimeoutAction(this.this$0, this.$actionTimeout, this.$actionTimeoutUnit, new Function0<Unit>(this.$future, this.this$0, this.$actionTimeoutUnit, this.$actionTimeout){
                        final /* synthetic */ runAsyncActionWithTimeout.future.1<T> $future;
                        final /* synthetic */ RenderExecutor this$0;
                        final /* synthetic */ TimeUnit $actionTimeoutUnit;
                        final /* synthetic */ long $actionTimeout;
                        {
                            this.$future = $future;
                            this.this$0 = $receiver;
                            this.$actionTimeoutUnit = $actionTimeoutUnit;
                            this.$actionTimeout = $actionTimeout;
                            super(0);
                        }

                        public final void invoke() {
                            if (!this.$future.isDone()) {
                                this.this$0.interrupt();
                            }
                            this.$future.completeExceptionally((Throwable)RenderExecutor.access$createRenderTimeoutException(this.this$0, "The render action was too slow to execute (" + this.$actionTimeoutUnit.toMillis(this.$actionTimeout) + "ms)"));
                        }
                    });
                    this.$future.whenComplete(new BiConsumer(actionTimeoutFuture2){
                        final /* synthetic */ ScheduledFuture<?> $actionTimeoutFuture;
                        {
                            this.$actionTimeoutFuture = $actionTimeoutFuture;
                        }

                        public final void accept(T t2, Throwable throwable) {
                            this.$actionTimeoutFuture.cancel(false);
                        }
                    });
                    RenderExecutor.access$getAccumulatedTimeoutExceptions$p(this.this$0).set(0);
                    try {
                        this.$future.complete(this.$callable.call());
                    }
                    catch (Throwable t2) {
                        this.$future.completeExceptionally(t2);
                    }
                }
                finally {
                    object = RenderExecutor.access$getRunningRenderLock$p(this.this$0);
                    object2 = this.this$0;
                    object.lock();
                    try {
                        boolean $i$a$-withLock-RenderExecutor$runAsyncActionWithTimeout$3$42 = false;
                        RenderExecutor.access$setRunningRender$p((RenderExecutor)object2, null);
                        Unit $i$a$-withLock-RenderExecutor$runAsyncActionWithTimeout$3$42 = Unit.INSTANCE;
                    }
                    finally {
                        object.unlock();
                    }
                }
            }
        }));
        CompletionStage completionStage = future2.whenComplete(new BiConsumer(queueTimeoutFuture2, future2){
            final /* synthetic */ ScheduledFuture<?> $queueTimeoutFuture;
            final /* synthetic */ runAsyncActionWithTimeout.future.1<T> $future;
            {
                this.$queueTimeoutFuture = $queueTimeoutFuture;
                this.$future = $future;
            }

            public final void accept(T result2, Throwable exception) {
                ScheduledFuture<?> scheduledFuture = this.$queueTimeoutFuture;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(true);
                }
                if (exception != null) {
                    this.$future.completeExceptionally(exception);
                } else {
                    this.$future.complete(result2);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue(completionStage, "future =\n      object : \u2026ete(result)\n      }\n    }");
        return completionStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cancelActionsByTopic(@NotNull List<? extends RenderAsyncActionExecutor.RenderingTopic> topicsToCancel, boolean mayInterruptIfRunning) {
        Intrinsics.checkNotNullParameter(topicsToCancel, "topicsToCancel");
        int numberOfCancelledActions = 0;
        Lock lock = this.pendingActionsQueueLock;
        lock.lock();
        try {
            boolean $i$a$-withLock-RenderExecutor$cancelActionsByTopic$332 = false;
            for (RenderAsyncActionExecutor.RenderingTopic renderingTopic : topicsToCancel) {
                Queue<PriorityCompletableFuture<?>> queue;
                if (this.pendingActionsQueueByTopic.get((Object)renderingTopic) == null) continue;
                boolean bl2 = false;
                while (!((Collection)queue).isEmpty()) {
                    PriorityCompletableFuture<?> removed = queue.remove();
                    this.allPendingActionsQueue.remove(removed);
                    removed.cancel(false);
                    ++numberOfCancelledActions;
                }
            }
            Unit $i$a$-withLock-RenderExecutor$cancelActionsByTopic$332 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        lock = this.runningRenderLock;
        lock.lock();
        try {
            Unit unit;
            boolean bl3 = false;
            PriorityCompletableFuture<?> priorityCompletableFuture = this.runningRender;
            if (priorityCompletableFuture != null) {
                PriorityCompletableFuture<?> it = priorityCompletableFuture;
                boolean bl2 = false;
                if (topicsToCancel.contains((Object)it.getRenderingTopic())) {
                    it.cancel(mayInterruptIfRunning);
                    ++numberOfCancelledActions;
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            lock.unlock();
        }
        return numberOfCancelledActions;
    }

    @TestOnly
    public final void shutdown(long timeoutSeconds) {
        this.shutdown();
        if (timeoutSeconds > 0L) {
            try {
                this.renderingExecutorService.awaitTermination(timeoutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignored) {
                Logger.getInstance(RenderExecutor.class).warn("The RenderExecutor does not shutdown after " + timeoutSeconds + " seconds");
            }
        }
    }

    @TestOnly
    public final int getAccumulatedTimeouts() {
        return this.accumulatedTimeoutExceptions.get();
    }

    @TestOnly
    public final int getNumPendingActions() {
        return this.allPendingActionsQueue.size();
    }

    public final boolean isBusy() {
        return this.renderingExecutorService.isBusy();
    }

    public final boolean isRenderThread() {
        return this.renderingExecutorService.hasSpawnedCurrentThread();
    }

    @JvmStatic
    @NotNull
    public static final RenderExecutor create() {
        return Companion.create();
    }

    public static final /* synthetic */ TimeoutException access$createRenderTimeoutException(RenderExecutor $this, String message2) {
        return $this.createRenderTimeoutException(message2);
    }

    public static final /* synthetic */ AtomicInteger access$getAccumulatedTimeoutExceptions$p(RenderExecutor $this) {
        return $this.accumulatedTimeoutExceptions;
    }

    public static final /* synthetic */ Lock access$getRunningRenderLock$p(RenderExecutor $this) {
        return $this.runningRenderLock;
    }

    public static final /* synthetic */ LongAdder access$getExecutedRenderActions$p(RenderExecutor $this) {
        return $this.executedRenderActions;
    }

    public static final /* synthetic */ Lock access$getPendingActionsQueueLock$p(RenderExecutor $this) {
        return $this.pendingActionsQueueLock;
    }

    public static final /* synthetic */ ScheduledFuture access$scheduleTimeoutAction(RenderExecutor $this, long timeout, TimeUnit unit, Function0 action2) {
        return $this.scheduleTimeoutAction(timeout, unit, action2);
    }

    public static final /* synthetic */ void access$setRunningRender$p(RenderExecutor $this, PriorityCompletableFuture priorityCompletableFuture) {
        $this.runningRender = priorityCompletableFuture;
    }

    public static final /* synthetic */ Map access$getPendingActionsQueueByTopic$p(RenderExecutor $this) {
        return $this.pendingActionsQueueByTopic;
    }

    public static final /* synthetic */ Queue access$getAllPendingActionsQueue$p(RenderExecutor $this) {
        return $this.allPendingActionsQueue;
    }

    public /* synthetic */ RenderExecutor(int maxQueueingTasks, SingleThreadExecutorService renderingExecutorService, ScheduledExecutorService scheduledExecutorService, DefaultConstructorMarker $constructor_marker) {
        this(maxQueueingTasks, renderingExecutorService, scheduledExecutorService);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/rendering/RenderExecutor$Companion;", "", "()V", "create", "Lcom/android/tools/rendering/RenderExecutor;", "createForTests", "executorService", "Lcom/android/tools/rendering/SingleThreadExecutorService;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "unnamed"})
    @SourceDebugExtension(value={"SMAP\nRenderExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderExecutor.kt\ncom/android/tools/rendering/RenderExecutor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n1#2:358\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RenderExecutor create() {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
            ScheduledThreadPoolExecutor it = scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
            boolean bl2 = false;
            it.setRemoveOnCancelPolicy(true);
            ScheduledThreadPoolExecutor scheduledExecutorService = scheduledThreadPoolExecutor;
            Integer n2 = RenderExecutorKt.access$getDEFAULT_MAX_QUEUED_TASKS$p();
            Intrinsics.checkNotNullExpressionValue(n2, "DEFAULT_MAX_QUEUED_TASKS");
            return new RenderExecutor(((Number)n2).intValue(), SingleThreadExecutorService.Companion.create("Layoutlib Render Thread", new ThreadProfileSettings(0L, 0L, 0, scheduledExecutorService, create.1.INSTANCE, 7, null)), scheduledExecutorService, null);
        }

        @TestOnly
        @NotNull
        public final RenderExecutor createForTests(@NotNull SingleThreadExecutorService executorService, @NotNull ScheduledExecutorService scheduledExecutorService) {
            Intrinsics.checkNotNullParameter(executorService, "executorService");
            Intrinsics.checkNotNullParameter(scheduledExecutorService, "scheduledExecutorService");
            Integer n2 = RenderExecutorKt.access$getDEFAULT_MAX_QUEUED_TASKS$p();
            Intrinsics.checkNotNullExpressionValue(n2, "DEFAULT_MAX_QUEUED_TASKS");
            return new RenderExecutor(((Number)n2).intValue(), executorService, scheduledExecutorService, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/rendering/RenderExecutor$EvictedException;", "Ljava/util/concurrent/CancellationException;", "message", "", "(Ljava/lang/String;)V", "unnamed"})
    private static final class EvictedException
    extends CancellationException {
        public EvictedException(@Nullable String message2) {
            super(message2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0012\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00000\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0000H\u0096\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/rendering/RenderExecutor$PriorityCompletableFuture;", "T", "", "", "Ljava/util/concurrent/CompletableFuture;", "renderingTopic", "Lcom/android/tools/rendering/RenderAsyncActionExecutor$RenderingTopic;", "(Lcom/android/tools/rendering/RenderAsyncActionExecutor$RenderingTopic;)V", "creationTime", "", "getRenderingTopic", "()Lcom/android/tools/rendering/RenderAsyncActionExecutor$RenderingTopic;", "compareTo", "", "other", "unnamed"})
    private static class PriorityCompletableFuture<T>
    extends CompletableFuture<T>
    implements Comparable<PriorityCompletableFuture<Object>> {
        @NotNull
        private final RenderAsyncActionExecutor.RenderingTopic renderingTopic;
        private final long creationTime;

        public PriorityCompletableFuture(@NotNull RenderAsyncActionExecutor.RenderingTopic renderingTopic) {
            Intrinsics.checkNotNullParameter((Object)renderingTopic, "renderingTopic");
            this.renderingTopic = renderingTopic;
            this.creationTime = System.currentTimeMillis();
        }

        @NotNull
        public final RenderAsyncActionExecutor.RenderingTopic getRenderingTopic() {
            return this.renderingTopic;
        }

        @Override
        public int compareTo(@NotNull PriorityCompletableFuture<Object> other) {
            Intrinsics.checkNotNullParameter(other, "other");
            int priorityComparison = Intrinsics.compare(this.renderingTopic.getPriority(), other.renderingTopic.getPriority());
            if (priorityComparison != 0) {
                return priorityComparison;
            }
            return Intrinsics.compare(this.creationTime, other.creationTime);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/rendering/RenderExecutor$PriorityRunnable;", "Ljava/lang/Runnable;", "", "renderingTopic", "Lcom/android/tools/rendering/RenderAsyncActionExecutor$RenderingTopic;", "runnable", "(Lcom/android/tools/rendering/RenderAsyncActionExecutor$RenderingTopic;Ljava/lang/Runnable;)V", "creationTime", "", "getRenderingTopic", "()Lcom/android/tools/rendering/RenderAsyncActionExecutor$RenderingTopic;", "getRunnable", "()Ljava/lang/Runnable;", "compareTo", "", "other", "run", "", "unnamed"})
    private static final class PriorityRunnable
    implements Runnable,
    Comparable<PriorityRunnable> {
        @NotNull
        private final RenderAsyncActionExecutor.RenderingTopic renderingTopic;
        @NotNull
        private final Runnable runnable;
        private final long creationTime;

        public PriorityRunnable(@NotNull RenderAsyncActionExecutor.RenderingTopic renderingTopic, @NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)renderingTopic, "renderingTopic");
            Intrinsics.checkNotNullParameter(runnable, "runnable");
            this.renderingTopic = renderingTopic;
            this.runnable = runnable;
            this.creationTime = System.currentTimeMillis();
        }

        @NotNull
        public final RenderAsyncActionExecutor.RenderingTopic getRenderingTopic() {
            return this.renderingTopic;
        }

        @NotNull
        public final Runnable getRunnable() {
            return this.runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public int compareTo(@NotNull PriorityRunnable other) {
            Intrinsics.checkNotNullParameter(other, "other");
            int priorityComparison = -Intrinsics.compare(this.renderingTopic.getPriority(), other.renderingTopic.getPriority());
            if (priorityComparison != 0) {
                return priorityComparison;
            }
            return Intrinsics.compare(this.creationTime, other.creationTime);
        }
    }
}

