/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.rendering.RenderContext;
import com.android.tools.rendering.RenderLogger;
import com.android.tools.rendering.RenderResultStats;
import com.android.tools.rendering.api.EnvironmentContext;
import com.android.tools.rendering.api.IdeaModuleProvider;
import com.android.tools.rendering.api.RenderModelModule;
import com.android.tools.rendering.imagepool.ImagePool;
import com.android.tools.rendering.imagepool.ImagePoolImageDisposer;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RenderResult {
    private static Logger LOG = Logger.getInstance(RenderResult.class);
    @NotNull
    private final Supplier<PsiFile> mySourceFileProvider;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final ImmutableList<ViewInfo> myRootViews;
    @NotNull
    private final ImmutableList<ViewInfo> mySystemRootViews;
    @NotNull
    private final ImagePool.Image myImage;
    @NotNull
    private final Result myRenderResult;
    @NotNull
    private final Map<Object, Map<ResourceReference, ResourceValue>> myDefaultProperties;
    @NotNull
    private final Map<Object, ResourceReference> myDefaultStyles;
    @NotNull
    private final IdeaModuleProvider myModule;
    @NotNull
    private final Project myProject;
    private final ReadWriteLock myDisposeLock = new ReentrantReadWriteLock();
    @Nullable
    private final Object myValidatorResult;
    private final boolean myHasRequestedCustomViews;
    @Nullable
    private final RenderContext myRenderContext;
    private boolean isDisposed;
    private final RenderResultStats myStats;
    @NotNull
    private final Dimension myRootViewDimensions;

    public RenderResult(@NotNull Supplier<PsiFile> sourceFileProvider, @NotNull Project project, @NotNull IdeaModuleProvider module, @NotNull RenderLogger logger, @Nullable RenderContext renderContext, boolean hasRequestedCustomViews, @NotNull Result renderResult, @NotNull ImmutableList<ViewInfo> rootViews, @NotNull ImmutableList<ViewInfo> systemRootViews, @NotNull ImagePool.Image image, @NotNull Map<Object, Map<ResourceReference, ResourceValue>> defaultProperties, @NotNull Map<Object, ResourceReference> defaultStyles, @Nullable Object validatorResult, @NotNull Dimension rootViewDimensions, @NotNull RenderResultStats stats2) {
        this.myModule = module;
        this.myProject = project;
        this.myRenderContext = renderContext;
        this.mySourceFileProvider = sourceFileProvider;
        this.myLogger = logger;
        this.myRenderResult = renderResult;
        this.myRootViews = rootViews;
        this.mySystemRootViews = systemRootViews;
        this.myImage = image;
        this.myDefaultProperties = defaultProperties;
        this.myDefaultStyles = defaultStyles;
        this.myValidatorResult = validatorResult;
        this.myStats = stats2;
        this.myHasRequestedCustomViews = hasRequestedCustomViews;
        this.myRootViewDimensions = rootViewDimensions;
    }

    @TestOnly
    protected RenderResult(RenderResult result2) {
        this(result2.mySourceFileProvider, result2.myProject, result2.myModule, result2.myLogger, result2.myRenderContext, result2.myHasRequestedCustomViews, result2.myRenderResult, result2.myRootViews, result2.mySystemRootViews, result2.myImage, result2.myDefaultProperties, result2.myDefaultStyles, result2.myValidatorResult, result2.myRootViewDimensions, result2.myStats);
    }

    public boolean processImageIfNotDisposed(@NotNull Consumer<ImagePool.Image> processTask) {
        this.myDisposeLock.readLock().lock();
        try {
            if (this.isDisposed) {
                boolean bl2 = false;
                return bl2;
            }
            processTask.accept(this.myImage);
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.myDisposeLock.readLock().unlock();
        }
    }

    public void dispose() {
        this.myDisposeLock.writeLock().lock();
        try {
            this.isDisposed = true;
            ImagePoolImageDisposer.disposeImage(this.myImage);
        }
        finally {
            this.myDisposeLock.writeLock().unlock();
        }
    }

    private static Supplier<PsiFile> createSourceFileProvider(@NotNull EnvironmentContext environment, @NotNull Supplier<PsiFile> fileProvider2) {
        return () -> environment.getOriginalFile((PsiFile)fileProvider2.get());
    }

    @NotNull
    private static Dimension getRootViewDimensionFromSystemViews(@Nullable List<ViewInfo> viewInfo) {
        if (viewInfo == null || viewInfo.isEmpty()) {
            return new Dimension(0, 0);
        }
        return new Dimension(viewInfo.get(0).getRight(), viewInfo.get(0).getBottom());
    }

    @NotNull
    public static RenderResult create(@NotNull RenderContext renderContext, @NotNull RenderSession session, @NotNull Supplier<PsiFile> file2, @NotNull RenderLogger logger, @NotNull ImagePool.Image image, boolean hasRequestedCustomViews) {
        List<ViewInfo> rootViews = session.getRootViews();
        List<ViewInfo> systemRootViews = session.getSystemRootViews();
        Map<Object, Map<ResourceReference, ResourceValue>> defaultProperties = session.getDefaultNamespacedProperties();
        Map<Object, ResourceReference> defaultStyles = session.getDefaultNamespacedStyles();
        RenderResult result2 = new RenderResult(RenderResult.createSourceFileProvider(renderContext.getModule().getEnvironment(), file2), renderContext.getModule().getProject(), renderContext.getModule(), logger, renderContext, hasRequestedCustomViews, session.getResult(), rootViews != null ? ImmutableList.copyOf(rootViews) : ImmutableList.of(), systemRootViews != null ? ImmutableList.copyOf(systemRootViews) : ImmutableList.of(), image, defaultProperties != null ? ImmutableMap.copyOf(defaultProperties) : ImmutableMap.of(), defaultStyles != null ? ImmutableMap.copyOf(defaultStyles) : ImmutableMap.of(), session.getValidationData(), RenderResult.getRootViewDimensionFromSystemViews(systemRootViews), RenderResultStats.getEMPTY());
        if (LOG.isDebugEnabled()) {
            LOG.debug(result2.toString());
        }
        return result2;
    }

    @NotNull
    public RenderResult copyWithNewImageAndRootViewDimensions(@NotNull ImagePool.Image image, @NotNull Dimension rootViewDimensions) {
        return new RenderResult(this.mySourceFileProvider, this.myProject, this.myModule, this.myLogger, this.myRenderContext, this.myHasRequestedCustomViews, this.myRenderResult, ImmutableList.of(), ImmutableList.of(), image, this.myDefaultProperties, this.myDefaultStyles, this.myValidatorResult, rootViewDimensions, this.myStats);
    }

    @NotNull
    public RenderResult createWithStats(@NotNull RenderResultStats stats2) {
        return new RenderResult(this.mySourceFileProvider, this.myProject, this.myModule, this.myLogger, this.myRenderContext, this.myHasRequestedCustomViews, this.myRenderResult, this.myRootViews, this.mySystemRootViews, this.myImage, this.myDefaultProperties, this.myDefaultStyles, this.myValidatorResult, this.myRootViewDimensions, this.myStats.combine(stats2));
    }

    @NotNull
    public static RenderResult createErrorRenderResult(@NotNull Result.Status status, @NotNull RenderModelModule renderModule, @NotNull Supplier<PsiFile> file2, @Nullable Throwable throwable, @NotNull RenderLogger logger) {
        RenderResult result2 = new RenderResult(RenderResult.createSourceFileProvider(renderModule.getEnvironment(), file2), renderModule.getProject(), renderModule, logger, null, false, status.createResult("Render error", throwable), ImmutableList.of(), ImmutableList.of(), ImagePool.NULL_POOLED_IMAGE, ImmutableMap.of(), ImmutableMap.of(), null, new Dimension(0, 0), RenderResultStats.getEMPTY());
        if (LOG.isDebugEnabled()) {
            LOG.debug(result2.toString());
        }
        return result2;
    }

    @NotNull
    public static RenderResult createRenderTaskErrorResult(@NotNull RenderModelModule renderModule, @NotNull Supplier<PsiFile> file2, @Nullable Throwable throwable, @NotNull RenderLogger logger) {
        return RenderResult.createErrorRenderResult(Result.Status.ERROR_RENDER_TASK, renderModule, file2, throwable, logger);
    }

    @NotNull
    public Result getRenderResult() {
        return this.myRenderResult;
    }

    @NotNull
    public RenderLogger getLogger() {
        return this.myLogger;
    }

    @NotNull
    public ImagePool.Image getRenderedImage() {
        this.myDisposeLock.readLock().lock();
        try {
            ImagePool.Image image = !this.isDisposed ? this.myImage : ImagePool.NULL_POOLED_IMAGE;
            return image;
        }
        finally {
            this.myDisposeLock.readLock().unlock();
        }
    }

    @NotNull
    public PsiFile getSourceFile() {
        return this.mySourceFileProvider.get();
    }

    @Nullable
    public RenderContext getRenderContext() {
        return this.myRenderContext;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Deprecated
    @NotNull
    public Module getModule() {
        return this.myModule.getIdeaModule();
    }

    @NotNull
    public ImmutableList<ViewInfo> getRootViews() {
        return this.myRootViews;
    }

    @NotNull
    public ImmutableList<ViewInfo> getSystemRootViews() {
        return this.mySystemRootViews;
    }

    @Nullable
    public Object getValidatorResult() {
        return this.myValidatorResult;
    }

    @NotNull
    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties() {
        return this.myDefaultProperties;
    }

    @NotNull
    public Map<Object, ResourceReference> getDefaultStyles() {
        return this.myDefaultStyles;
    }

    public boolean hasRequestedCustomViews() {
        return this.myHasRequestedCustomViews;
    }

    @NotNull
    public Dimension getRootViewDimensions() {
        return this.myRootViews.isEmpty() ? this.myRootViewDimensions : RenderResult.getRootViewDimensionFromSystemViews(this.mySystemRootViews);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("renderResult", this.myRenderResult).add("sourceFile", this.getSourceFile()).add("rootViews", this.myRootViews).add("systemViews", this.mySystemRootViews).add("stats", this.myStats).add("rootViewDimensions", this.myRootViewDimensions).toString();
    }

    @NotNull
    public RenderResultStats getStats() {
        return this.myStats;
    }
}

