/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.LayoutDirection;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.configurations.Configuration;
import com.android.tools.dom.ActivityAttributesSnapshot;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderParamsFlags;
import com.android.tools.rendering.ActionBarHandler;
import com.android.tools.rendering.CachingImageFactory;
import com.android.tools.rendering.ExecuteCallbacksResult;
import com.android.tools.rendering.IRenderLogger;
import com.android.tools.rendering.InteractionEventResult;
import com.android.tools.rendering.LayoutlibCallbackImpl;
import com.android.tools.rendering.ModuleRenderContext;
import com.android.tools.rendering.NoDeviceException;
import com.android.tools.rendering.ProblemSeverity;
import com.android.tools.rendering.RenderAsyncActionExecutor;
import com.android.tools.rendering.RenderContext;
import com.android.tools.rendering.RenderLogger;
import com.android.tools.rendering.RenderProblem;
import com.android.tools.rendering.RenderResult;
import com.android.tools.rendering.RenderResultStats;
import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.RenderSessionCleaner;
import com.android.tools.rendering.api.IncludeReference;
import com.android.tools.rendering.api.RenderModelManifest;
import com.android.tools.rendering.api.RenderModelModule;
import com.android.tools.rendering.classloading.ClassLoaderPreloaderKt;
import com.android.tools.rendering.classloading.ClassTransform;
import com.android.tools.rendering.classloading.ModuleClassLoader;
import com.android.tools.rendering.classloading.ModuleClassLoaderManager;
import com.android.tools.rendering.compose.RenderTaskPatcher;
import com.android.tools.rendering.imagepool.ImagePool;
import com.android.tools.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.rendering.parsers.LayoutFilePullParser;
import com.android.tools.rendering.parsers.LayoutPullParsers;
import com.android.tools.rendering.parsers.LayoutRenderPullParser;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.rendering.security.RenderSecurityManager;
import com.android.tools.rendering.tracking.RenderTaskAllocationTracker;
import com.android.tools.rendering.tracking.StackTraceCapture;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RenderTask {
    public static final TestEventListener NOP_TEST_EVENT_LISTENER = new TestEventListener(){};
    private static final Logger LOG = Logger.getInstance(RenderTask.class);
    private static final int MIN_BITMAP_SIZE_PX = 1;
    private static final IImageFactory SIMPLE_IMAGE_FACTORY = new IImageFactory(){

        @Override
        @NotNull
        public BufferedImage getImage(int width, int height) {
            BufferedImage image = new BufferedImage(Math.max(1, width), Math.max(1, height), 3);
            image.setAccelerationPriority(1.0f);
            return image;
        }
    };
    private static final int DEFAULT_DOWNSCALED_IMAGE_MAX_BYTES = 2500000;
    private static final ExecutorService ourDisposeService = AppExecutorUtil.createBoundedApplicationPoolExecutor("RenderTask Dispose Thread", 1);
    @NotNull
    RenderTaskAllocationTracker myTracker;
    @NotNull
    private final ImagePool myImagePool;
    @NotNull
    private final RenderContext myContext;
    @NotNull
    private final ModuleClassLoaderManager<?> myClassLoaderManager;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final LayoutlibCallbackImpl myLayoutlibCallback;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @NotNull
    private final HardwareConfigHelper myHardwareConfigHelper;
    private float myTargetQuality = 1.0f;
    private float myCurrentQuality = 1.0f;
    private final long myDownScaledImageMaxBytes;
    @Nullable
    private IncludeReference myIncludedWithin;
    @NotNull
    private SessionParams.RenderingMode myRenderingMode = SessionParams.RenderingMode.NORMAL;
    private boolean mySetTransparentBackground = false;
    private boolean myShowDecorations = true;
    private boolean myEnableLayoutScanner = false;
    private boolean myShowWithToolsVisibilityAndPosition = true;
    private Function<Object, List<ViewInfo>> myCustomContentHierarchyParser = null;
    private long myTimeout;
    @NotNull
    private final Locale myLocale;
    @NotNull
    private final Object myCredential;
    @Nullable
    private RenderSession myRenderSession;
    @NotNull
    private IImageFactory myCachingImageFactory = SIMPLE_IMAGE_FACTORY;
    @Nullable
    private IImageFactory myImageFactoryDelegate;
    private final boolean isSecurityManagerEnabled;
    @NotNull
    private CrashReporter myCrashReporter;
    private final List<CompletableFuture<?>> myRunningFutures = new LinkedList();
    @NotNull
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);
    @Nullable
    private RenderXmlFile myXmlFile;
    @NotNull
    private String myDefaultForegroundColor = "#333333";
    @NotNull
    private final ModuleClassLoaderManager.Reference<?> myModuleClassLoaderReference;
    @NotNull
    private final TestEventListener myTestEventListener;
    private final boolean reportOutOfDateUserClasses;
    @NotNull
    private final RenderAsyncActionExecutor.RenderingTopic myTopic;

    RenderTask(@NotNull RenderContext renderContext, @NotNull ModuleClassLoaderManager classLoaderManager, @NotNull RenderLogger logger, @NotNull LayoutLibrary layoutLib, @NotNull Object credential, @NotNull CrashReporter crashReporter, @NotNull ImagePool imagePool, @Nullable ILayoutPullParserFactory parserFactory, boolean isSecurityManagerEnabled, float quality, @NotNull StackTraceCapture stackTraceCaptureElement, @NotNull RenderTaskAllocationTracker tracker, boolean privateClassLoader, @NotNull ClassTransform additionalProjectTransform, @NotNull ClassTransform additionalNonProjectTransform, @NotNull Runnable onNewModuleClassLoader, @NotNull Collection<String> classesToPreload, boolean reportOutOfDateUserClasses, @NotNull RenderAsyncActionExecutor.RenderingTopic topic, boolean useCustomInflater, @NotNull TestEventListener testEventListener) throws NoDeviceException {
        this.myTracker = tracker;
        this.myImagePool = imagePool;
        this.myContext = renderContext;
        this.myClassLoaderManager = classLoaderManager;
        this.isSecurityManagerEnabled = isSecurityManagerEnabled;
        this.reportOutOfDateUserClasses = reportOutOfDateUserClasses;
        if (!isSecurityManagerEnabled) {
            LOG.debug("Security manager was disabled");
        }
        this.myTopic = topic;
        this.myLogger = logger;
        this.myCredential = credential;
        this.myCrashReporter = crashReporter;
        this.myTestEventListener = testEventListener;
        Device device = renderContext.getConfiguration().getDevice();
        if (device == null) {
            throw new NoDeviceException();
        }
        this.myHardwareConfigHelper = new HardwareConfigHelper(device);
        ScreenOrientation orientation = renderContext.getConfiguration().getFullConfig().getScreenOrientationQualifier() != null ? renderContext.getConfiguration().getFullConfig().getScreenOrientationQualifier().getValue() : ScreenOrientation.PORTRAIT;
        this.myHardwareConfigHelper.setOrientation(orientation);
        this.myLayoutLib = layoutLib;
        ActionBarHandler actionBarHandler = new ActionBarHandler(this, this.myCredential);
        ModuleRenderContext moduleRenderContext = renderContext.getModule().createModuleRenderContext(new WeakReference<RenderTask>(this));
        if (privateClassLoader) {
            this.myModuleClassLoaderReference = classLoaderManager.getPrivate(this.myLayoutLib.getClassLoader(), moduleRenderContext, additionalProjectTransform, additionalNonProjectTransform);
            onNewModuleClassLoader.run();
        } else {
            this.myModuleClassLoaderReference = classLoaderManager.getShared(this.myLayoutLib.getClassLoader(), moduleRenderContext, additionalProjectTransform, additionalNonProjectTransform, onNewModuleClassLoader);
        }
        Object moduleClassLoader = this.myModuleClassLoaderReference.getClassLoader();
        ClassLoaderPreloaderKt.preload(moduleClassLoader, () -> moduleClassLoader.isDisposed(), classesToPreload);
        try {
            this.myLayoutlibCallback = new LayoutlibCallbackImpl(this, this.myLayoutLib, renderContext.getModule(), this.myLogger, this.myCredential, actionBarHandler, parserFactory, (ModuleClassLoader)moduleClassLoader, useCustomInflater);
            if (renderContext.getModule().getResourceIdManager().getFinalIdsUsed()) {
                this.myLayoutlibCallback.loadAndParseRClass();
            }
            this.myLocale = renderContext.getConfiguration().getLocale();
            this.myDownScaledImageMaxBytes = "_device_class_desktop".equals(device.getId()) ? 18000000L : ("_device_class_tablet".equals(device.getId()) ? 9000000L : 2500000L);
            this.setQuality(quality);
            stackTraceCaptureElement.bind(this);
        }
        catch (Exception ex) {
            this.clearClassLoader();
            throw ex;
        }
    }

    public void setQuality(float quality) {
        if ((quality = Math.max(0.0f, Math.min(quality, 1.0f))) == this.myTargetQuality) {
            return;
        }
        this.myTargetQuality = quality;
        if (quality >= 1.0f) {
            this.myCachingImageFactory = SIMPLE_IMAGE_FACTORY;
            return;
        }
        long maxSize = this.myDownScaledImageMaxBytes;
        double dimensionScale = Math.sqrt(quality);
        this.myCachingImageFactory = new CachingImageFactory((width, height) -> {
            double downscaleWidth = (double)width * dimensionScale;
            double downscaleHeight = (double)height * dimensionScale;
            double size = width * height;
            if (size > (double)maxSize) {
                double newDimensionScale = Math.sqrt((double)maxSize / size);
                downscaleWidth *= newDimensionScale;
                downscaleHeight *= newDimensionScale;
            }
            int w2 = Math.max(1, (int)downscaleWidth);
            int h2 = Math.max(1, (int)downscaleHeight);
            return SIMPLE_IMAGE_FACTORY.getImage(w2, h2);
        });
    }

    public void setXmlFile(@NotNull RenderXmlFile file2) {
        this.myXmlFile = file2;
        ReadAction.run(() -> this.getContext().setFolderType(file2.getFolderType()));
    }

    @Nullable
    public RenderXmlFile getXmlFile() {
        return this.myXmlFile;
    }

    public void setDefaultForegroundColor(@NotNull String defaultForegroundColor) {
        this.myDefaultForegroundColor = defaultForegroundColor;
    }

    @NotNull
    public String getDefaultForegroundColor() {
        return this.myDefaultForegroundColor;
    }

    @NotNull
    public IRenderLogger getLogger() {
        return this.myLogger;
    }

    @NotNull
    public HardwareConfigHelper getHardwareConfigHelper() {
        return this.myHardwareConfigHelper;
    }

    public boolean getShowDecorations() {
        return this.myShowDecorations;
    }

    public boolean getShowWithToolsVisibilityAndPosition() {
        return this.myShowWithToolsVisibilityAndPosition;
    }

    public boolean isDisposed() {
        return this.isDisposed.get();
    }

    private void clearClassLoader() {
        try {
            this.myClassLoaderManager.release(this.myModuleClassLoaderReference);
        }
        catch (AlreadyDisposedException alreadyDisposedException) {
        }
        catch (Throwable t2) {
            LOG.warn(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> dispose() {
        CompletableFuture[] currentRunningFutures;
        if (this.isDisposed.getAndSet(true)) {
            assert (false) : "RenderTask was already disposed";
            return Futures.immediateFailedFuture(new IllegalStateException("RenderTask was already disposed"));
        }
        this.myTracker.captureDisposeStackTrace().bind(this);
        List<CompletableFuture<?>> list2 = this.myRunningFutures;
        synchronized (list2) {
            currentRunningFutures = this.myRunningFutures.toArray(new CompletableFuture[0]);
            this.myRunningFutures.clear();
        }
        this.myLayoutlibCallback.setLogger(IRenderLogger.NULL_LOGGER);
        RenderSession renderSessionToDispose = this.myRenderSession;
        this.myRenderSession = null;
        return ourDisposeService.submit(() -> {
            try {
                CompletableFuture.allOf(currentRunningFutures).get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e2) {
                LOG.debug(e2);
            }
            if (renderSessionToDispose != null) {
                try {
                    ((CompletableFuture)this.disposeRenderSession(renderSessionToDispose).whenComplete((result2, ex) -> this.clearClassLoader())).orTimeout(2L, TimeUnit.SECONDS).join();
                }
                catch (Exception exception) {}
            } else {
                this.clearClassLoader();
            }
            this.myImageFactoryDelegate = null;
            Disposer.dispose(this.myContext.getModule());
            return null;
        });
    }

    @TestOnly
    @Nullable
    public ClassLoader getClassLoader() {
        return this.myModuleClassLoaderReference.getClassLoader();
    }

    @NotNull
    public RenderTask setOverrideRenderSize(int overrideRenderWidth, int overrideRenderHeight) {
        this.myHardwareConfigHelper.setOverrideRenderSize(overrideRenderWidth, overrideRenderHeight);
        return this;
    }

    @NotNull
    public RenderTask setMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
        this.myHardwareConfigHelper.setMaxRenderSize(maxRenderWidth, maxRenderHeight);
        return this;
    }

    @NotNull
    public RenderTask setRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
        this.myRenderingMode = renderingMode;
        return this;
    }

    @NotNull
    public RenderTask setTimeout(long timeout) {
        this.myTimeout = timeout;
        return this;
    }

    @NotNull
    public RenderTask setTransparentBackground() {
        this.mySetTransparentBackground = true;
        return this;
    }

    @NotNull
    public RenderTask setDecorations(boolean showDecorations) {
        this.myShowDecorations = showDecorations;
        return this;
    }

    public RenderTask setEnableLayoutScanner(boolean enableLayoutScanner) {
        this.myEnableLayoutScanner = enableLayoutScanner;
        return this;
    }

    @NotNull
    public RenderTask setShowWithToolsVisibilityAndPosition(boolean showWithToolsVisibilityAndPosition) {
        this.myShowWithToolsVisibilityAndPosition = showWithToolsVisibilityAndPosition;
        return this;
    }

    @NotNull
    public RenderTask setCustomContentHierarchyParser(@NotNull Function<Object, List<ViewInfo>> parser) {
        this.myCustomContentHierarchyParser = parser;
        return this;
    }

    @Nullable
    private static String getRootTagName(@NotNull RenderXmlFile file2) {
        ResourceFolderType folderType = file2.getFolderType();
        if (folderType == ResourceFolderType.XML || folderType == ResourceFolderType.MENU || folderType == ResourceFolderType.DRAWABLE) {
            RenderXmlTag rootTag = file2.getRootTag();
            return rootTag == null ? null : rootTag.getName();
        }
        return null;
    }

    @NotNull
    private ImagePool.Image toPooledImage(@Nullable BufferedImage result2) {
        if (result2 != null && result2.getWidth() > 1 && result2.getHeight() > 1) {
            return this.myImagePool.copyOf(result2);
        }
        return ImagePool.NULL_POOLED_IMAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RenderResult createRenderSession(@NotNull IImageFactory factory) {
        RenderSecurityManager securityManager;
        IAndroidTarget target;
        ILayoutPullParser includingParser;
        RenderContext context2 = this.getContext();
        RenderModelModule module = context2.getModule();
        if (module.isDisposed()) {
            return null;
        }
        RenderXmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            throw new IllegalStateException("createRenderSession shouldn't be called on RenderTask without PsiFile");
        }
        if (this.isDisposed.get()) {
            return null;
        }
        Configuration configuration = context2.getConfiguration();
        ResourceResolver resolver2 = ResourceResolver.copy(configuration.getResourceResolver());
        if (resolver2 == null) {
            return null;
        }
        ILayoutPullParser modelParser = LayoutPullParsers.create(this);
        if (modelParser == null) {
            return null;
        }
        this.myLayoutlibCallback.reset();
        if (modelParser instanceof LayoutRenderPullParser) {
            boolean useSrcCompat = context2.getModule().getDependencies().dependsOn(GoogleMavenArtifactId.APP_COMPAT_V7) || context2.getModule().getDependencies().dependsOn(GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
            ((LayoutRenderPullParser)modelParser).setUseSrcCompat(useSrcCompat);
            this.myLayoutlibCallback.setAaptDeclaredResources(((LayoutRenderPullParser)modelParser).getAaptDeclaredAttrs());
        }
        if ((includingParser = this.getIncludingLayoutParser(resolver2, modelParser)) != null) {
            modelParser = includingParser;
        }
        int simulatedPlatform = (target = configuration.getTarget()) instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0;
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        SessionParams params = new SessionParams(modelParser, this.myRenderingMode, context2.getModule().getModuleKey(), hardwareConfig, resolver2, this.myLayoutlibCallback, context2.getMinSdkVersion().getApiLevel(), context2.getTargetSdkVersion().getApiLevel(), this.myLogger, simulatedPlatform);
        params.setAssetRepository(context2.getModule().getAssetRepository());
        params.setFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG, RenderTask.getRootTagName(xmlFile));
        params.setFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING, true);
        params.setFlag(RenderParamsFlags.FLAG_DO_NOT_RENDER_ON_CREATE, true);
        params.setFlag(RenderParamsFlags.FLAG_KEY_RESULT_IMAGE_AUTO_SCALE, true);
        params.setFlag(RenderParamsFlags.FLAG_KEY_ENABLE_LAYOUT_SCANNER, this.myEnableLayoutScanner);
        params.setFlag(RenderParamsFlags.FLAG_ENABLE_LAYOUT_SCANNER_IMAGE_CHECK, this.myEnableLayoutScanner);
        params.setFlag(RenderParamsFlags.FLAG_KEY_ADAPTIVE_ICON_MASK_PATH, configuration.getAdaptiveShape().getPathDescription());
        params.setFlag(RenderParamsFlags.FLAG_KEY_USE_THEMED_ICON, configuration.getUseThemedIcon());
        params.setFlag(RenderParamsFlags.FLAG_KEY_WALLPAPER_PATH, configuration.getWallpaperPath());
        params.setCustomContentHierarchyParser(this.myCustomContentHierarchyParser);
        params.setImageTransformation(configuration.getImageTransformation());
        params.setExtendedViewInfoMode(true);
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier != null && qualifier.getValue() == LayoutDirection.RTL && !this.getLayoutLib().isRtl(this.myLocale.toLocaleId())) {
            params.setLocale("ur");
        } else {
            params.setLocale(this.myLocale.toLocaleId());
        }
        try {
            @Nullable RenderModelManifest manifestInfo = context2.getModule().getManifest();
            params.setRtlSupport(manifestInfo != null && manifestInfo.isRtlSupported());
        }
        catch (Exception manifestInfo) {
            // empty catch block
        }
        Device device = configuration.getDevice();
        if (!this.myShowDecorations || Device.isWear(device)) {
            params.setForceNoDecor();
        } else {
            try {
                ResourceValue resource;
                String activity;
                ResourceValue appLabel;
                @Nullable RenderModelManifest manifestInfo = context2.getModule().getManifest();
                ResourceValue resourceValue = appLabel = manifestInfo != null ? manifestInfo.getApplicationLabel() : new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.STRING, "appName", "");
                if (manifestInfo != null) {
                    params.setAppIcon(manifestInfo.getApplicationIcon());
                }
                if ((activity = configuration.getActivity()) != null) {
                    ActivityAttributesSnapshot attributes;
                    params.setActivityName(activity);
                    ActivityAttributesSnapshot activityAttributesSnapshot = attributes = manifestInfo != null ? manifestInfo.getActivityAttributes(activity) : null;
                    if (attributes != null) {
                        if (attributes.getLabel() != null) {
                            appLabel = attributes.getLabel();
                        }
                        if (attributes.getIcon() != null) {
                            params.setAppIcon(attributes.getIcon());
                        }
                    }
                }
                if ((resource = params.getResources().resolveResValue(appLabel)) != null) {
                    params.setAppLabel(resource.getValue());
                }
            }
            catch (Exception manifestInfo) {
                // empty catch block
            }
        }
        if (this.mySetTransparentBackground || this.requiresTransparency()) {
            params.setTransparentBackground();
        }
        params.setImageFactory(factory);
        if (this.myTimeout > 0L) {
            params.setTimeout(this.myTimeout);
        }
        params.setFontScale(configuration.getFontScale());
        params.setUiMode(configuration.getUiModeFlagValue());
        this.myLayoutlibCallback.setLogger(this.myLogger);
        RenderSecurityManager renderSecurityManager = securityManager = this.isSecurityManagerEnabled ? this.myContext.getModule().getEnvironment().createRenderSecurityManager(module.getProject().getBasePath(), context2.getModule().getAndroidPlatform()) : null;
        if (securityManager != null) {
            securityManager.setActive(true, this.myCredential);
        }
        try {
            RenderSession session = this.myLayoutLib.createSession(params);
            if (session.getResult().isSuccess()) {
                session.setSystemBootTimeNanos(0L);
                session.setSystemTimeNanos(0L);
                session.setElapsedFrameTimeNanos(TimeUnit.MILLISECONDS.toNanos(500L));
            }
            BufferedImage resultImage = session.getImage();
            RenderResult result2 = RenderResult.create(context2, session, xmlFile, this.myLogger, this.toPooledImage(resultImage), this.myLayoutlibCallback.isUsed());
            RenderSession oldRenderSession = this.myRenderSession;
            this.myRenderSession = session;
            RenderTaskPatcher.enableComposeHotReloadMode(this.myModuleClassLoaderReference.getClassLoader());
            if (oldRenderSession != null) {
                this.disposeRenderSession(oldRenderSession);
            }
            this.addDiagnostics(result2.getRenderResult());
            RenderResult renderResult = result2;
            if (securityManager != null) {
                securityManager.dispose(this.myCredential);
            }
            return renderResult;
        }
        catch (Throwable throwable) {
            try {
                if (securityManager != null) {
                    securityManager.dispose(this.myCredential);
                }
                throw throwable;
            }
            catch (RuntimeException t2) {
                this.myLogger.error(null, t2.getLocalizedMessage(), t2, null, null);
                throw t2;
            }
        }
    }

    @Nullable
    private ILayoutPullParser getIncludingLayoutParser(RenderResources resolver2, ILayoutPullParser modelParser) {
        RenderXmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            throw new IllegalStateException("getIncludingLayoutParser shouldn't be called on RenderTask without PsiFile");
        }
        if (!this.myShowWithToolsVisibilityAndPosition) {
            return null;
        }
        if (this.myIncludedWithin == null) {
            this.myIncludedWithin = this.myContext.getModule().getEnvironment().createIncludeReference(xmlFile, resolver2);
        }
        ILayoutPullParser topParser = null;
        if (this.myIncludedWithin != IncludeReference.NONE) {
            String queryLayoutName = SdkUtils.fileNameToResourceName(xmlFile.getName());
            this.myLayoutlibCallback.setLayoutParser(queryLayoutName, modelParser);
            RenderXmlFile fromXmlFile = this.myIncludedWithin.getFromXmlFile(this.myContext.getModule().getProject());
            if (fromXmlFile != null) {
                LayoutRenderPullParser parser;
                topParser = parser = LayoutRenderPullParser.create(fromXmlFile, this.myLogger, this.myContext.getModule().getResourceRepositoryManager());
            } else {
                topParser = LayoutFilePullParser.create(new PathString(this.myIncludedWithin.getFromPath()), ResourceNamespace.TODO(), this.myContext.getModule().getResourceIdManager());
                if (topParser == null) {
                    this.myLogger.error(null, String.format("Could not read layout file %1$s", this.myIncludedWithin.getFromPath()), null, null, null);
                }
            }
        }
        return topParser;
    }

    private static <T> CompletableFuture<T> immediateFailedFuture(Throwable exception) {
        CompletableFuture future2 = new CompletableFuture();
        future2.completeExceptionally(exception);
        return future2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    private <V> CompletableFuture<V> runAsyncRenderAction(@NotNull Callable<V> callable, long timeout, @NotNull TimeUnit unit) {
        if (this.isDisposed.get()) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("RenderTask was already disposed"));
        }
        List<CompletableFuture<?>> list2 = this.myRunningFutures;
        synchronized (list2) {
            CompletableFuture newFuture = timeout < 1L ? RenderService.getRenderAsyncActionExecutor().runAsyncAction(this.myTopic, callable) : RenderService.getRenderAsyncActionExecutor().runAsyncActionWithTimeout(timeout, unit, this.myTopic, callable);
            this.myRunningFutures.add(newFuture);
            newFuture.whenCompleteAsync((result2, ex) -> {
                List<CompletableFuture<?>> list2 = this.myRunningFutures;
                synchronized (list2) {
                    this.myRunningFutures.remove(newFuture);
                }
            });
            return newFuture;
        }
    }

    @VisibleForTesting
    @NotNull
    public <V> CompletableFuture<V> runAsyncRenderAction(@NotNull Callable<V> callable) {
        return this.runAsyncRenderAction(callable, 0L, TimeUnit.SECONDS);
    }

    @NotNull
    public CompletableFuture<RenderResult> inflate() {
        RenderXmlFile xmlFile = this.getXmlFile();
        if (xmlFile == null) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("inflate shouldn't be called on RenderTask without PsiFile"));
        }
        if (xmlFile.getProject().isDisposed()) {
            return CompletableFuture.completedFuture(null);
        }
        long startInflateTimeMs = System.currentTimeMillis();
        return ((CompletableFuture)this.runAsyncRenderAction(() -> this.createRenderSession((width, height) -> {
            this.myTestEventListener.onBeforeInflate();
            if (this.myImageFactoryDelegate != null) {
                return this.myImageFactoryDelegate.getImage(width, height);
            }
            return new BufferedImage(width, height, 3);
        }), RenderAsyncActionExecutor.DEFAULT_RENDER_THREAD_TIMEOUT_MS * 10L, TimeUnit.MILLISECONDS).whenComplete((result2, ex) -> this.myTestEventListener.onAfterInflate())).handle((result2, ex) -> {
            if (ex != null) {
                while (ex instanceof CompletionException) {
                    ex = ex.getCause();
                }
                String message2 = ex.getMessage();
                if (message2 == null) {
                    message2 = ex.toString();
                }
                RenderModelModule module = this.myContext.getModule();
                RenderProblem.ActionFixFactory fixFactory = module.getEnvironment().getActionFixFactory();
                this.myLogger.addMessage(RenderProblem.createHtml(ProblemSeverity.ERROR, message2, module.getProject(), this.myLogger.getLinkManager(), ex, fixFactory));
            }
            if (result2 != null) {
                return result2.createWithStats(new RenderResultStats(System.currentTimeMillis() - startInflateTimeMs, -1L, ((ModuleClassLoader)this.myModuleClassLoaderReference.getClassLoader()).getStats()));
            }
            if (ActionsKt.runReadAction(xmlFile::isValid).booleanValue()) {
                return RenderResult.createErrorRenderResult(Result.Status.ERROR_RENDER_TASK, this.myContext.getModule(), xmlFile, ex, this.myLogger);
            }
            LOG.warn("Invalid file " + xmlFile);
            return null;
        });
    }

    @NotNull
    public CompletableFuture<RenderResult> layout() {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(null);
        }
        assert (this.getXmlFile() != null);
        try {
            RenderSession renderSession = this.myRenderSession;
            RenderXmlFile xmlFile = this.getXmlFile();
            return this.runAsyncRenderAction(() -> {
                this.myRenderSession.measure();
                return RenderResult.create(this.myContext, renderSession, xmlFile, this.myLogger, ImagePool.NULL_POOLED_IMAGE, this.myLayoutlibCallback.isUsed());
            });
        }
        catch (Exception exception) {
            return CompletableFuture.completedFuture(null);
        }
    }

    @NotNull
    public CompletableFuture<ExecuteCallbacksResult> executeCallbacks(long timeNanos) {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(ExecuteCallbacksResult.EMPTY);
        }
        return this.runAsyncRenderAction(() -> {
            this.myRenderSession.setSystemTimeNanos(timeNanos);
            long start = System.currentTimeMillis();
            boolean hasMoreCallbacks = this.myRenderSession.executeCallbacks(timeNanos);
            return ExecuteCallbacksResult.create(hasMoreCallbacks, System.currentTimeMillis() - start);
        }, 500L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public CompletableFuture<InteractionEventResult> triggerTouchEvent(@NotNull RenderSession.TouchEventType touchEventType, int x2, int y2, long timeNanos) {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.runAsyncRenderAction(() -> {
            this.myRenderSession.setSystemTimeNanos(timeNanos);
            long start = System.currentTimeMillis();
            this.myRenderSession.triggerTouchEvent(touchEventType, x2, y2);
            return InteractionEventResult.create(System.currentTimeMillis() - start);
        });
    }

    @NotNull
    public CompletableFuture<InteractionEventResult> triggerKeyEvent(@NotNull KeyEvent event, long timeNanos) {
        if (this.myRenderSession == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.runAsyncRenderAction(() -> {
            this.myRenderSession.setSystemTimeNanos(timeNanos);
            long start = System.currentTimeMillis();
            this.myRenderSession.triggerKeyEvent(event);
            return InteractionEventResult.create(System.currentTimeMillis() - start);
        });
    }

    private void reportException(@NotNull Throwable e2) {
        if (e2 instanceof CancellationException) {
            return;
        }
        this.myCrashReporter.submit(this.myContext.getModule().getEnvironment().createCrashReport(e2));
    }

    @NotNull
    private CompletableFuture<RenderResult> renderInner(boolean forceMeasure) {
        RenderXmlFile xmlFile = this.getXmlFile();
        assert (xmlFile != null);
        CompletionStage<Object> inflateCompletableResult = this.myRenderSession == null ? this.inflate().whenComplete((renderResult, exception) -> {
            Result result2;
            Result result3 = result2 = renderResult != null ? renderResult.getRenderResult() : null;
            if (result2 == null || !result2.isSuccess()) {
                Throwable e2;
                Throwable throwable = e2 = result2 != null ? result2.getException() : exception;
                if (e2 != null) {
                    this.reportException(e2);
                }
                if (result2 != null) {
                    this.myLogger.error(null, result2.getErrorMessage(), e2, null, null);
                }
            }
        }) : CompletableFuture.completedFuture(null);
        return inflateCompletableResult.thenCompose(inflateResult -> {
            try {
                long startRenderTimeMs = System.currentTimeMillis();
                return ((CompletableFuture)((CompletableFuture)this.runAsyncRenderAction(() -> {
                    this.myTestEventListener.onBeforeRender();
                    this.myRenderSession.render(forceMeasure);
                    BufferedImage resultImage = this.myRenderSession.getImage();
                    RenderResult result2 = RenderResult.create(this.myContext, this.myRenderSession, xmlFile, this.myLogger, this.toPooledImage(resultImage), this.myLayoutlibCallback.isUsed());
                    Result renderResult = result2.getRenderResult();
                    if (renderResult.getException() != null) {
                        this.reportException(renderResult.getException());
                        this.myLogger.error(null, renderResult.getErrorMessage(), renderResult.getException(), null, null);
                    }
                    if (this.reportOutOfDateUserClasses && !((ModuleClassLoader)this.myModuleClassLoaderReference.getClassLoader()).isUserCodeUpToDate()) {
                        RenderProblem.Html problem = RenderProblem.create(ProblemSeverity.WARNING);
                        HtmlBuilder builder = problem.getHtmlBuilder();
                        builder.addLink("The project has been edited more recently than the last build: ", "Build", " the project.", this.myLogger.getLinkManager().createBuildProjectUrl());
                        this.myLogger.addMessage(problem);
                    }
                    return result2;
                }).whenComplete((result2, ex) -> this.myTestEventListener.onAfterRender())).whenComplete((result2, ex) -> {
                    Object moduleClassLoader = this.myModuleClassLoaderReference.getClassLoader();
                    RenderSessionCleaner.clearGapWorkerCache(moduleClassLoader);
                    RenderSessionCleaner.clearFontRequestWorker(moduleClassLoader);
                    RenderSessionCleaner.clearCompositions(moduleClassLoader);
                })).handle((result2, ex) -> {
                    if (ex != null) {
                        while (ex instanceof CompletionException) {
                            ex = ex.getCause();
                        }
                    }
                    if (result2 == null) {
                        result2 = RenderResult.createErrorRenderResult(Result.Status.ERROR_RENDER, this.myContext.getModule(), xmlFile, ex, this.myLogger);
                    }
                    Object moduleClassLoader = this.myModuleClassLoaderReference.getClassLoader();
                    return result2.createWithStats(new RenderResultStats(inflateResult != null ? inflateResult.getStats().getInflateDurationMs() : result2.getStats().getInflateDurationMs(), System.currentTimeMillis() - startRenderTimeMs, ((ModuleClassLoader)moduleClassLoader).getStats().getClassesFound(), ((ModuleClassLoader)moduleClassLoader).getStats().getAccumulatedFindTimeMs(), ((ModuleClassLoader)moduleClassLoader).getStats().getAccumulatedRewriteTimeMs()));
                });
            }
            catch (Exception e2) {
                this.reportException(e2);
                String message2 = e2.getMessage();
                if (message2 == null) {
                    message2 = e2.toString();
                }
                RenderModelModule module = this.myContext.getModule();
                RenderProblem.ActionFixFactory fixFactory = module.getEnvironment().getActionFixFactory();
                this.myLogger.addMessage(RenderProblem.createHtml(ProblemSeverity.ERROR, message2, module.getProject(), this.myLogger.getLinkManager(), e2, fixFactory));
                return CompletableFuture.completedFuture(RenderResult.createErrorRenderResult(Result.Status.ERROR_RENDER_TASK, module, xmlFile, e2, this.myLogger));
            }
        });
    }

    @NotNull
    public CompletableFuture<RenderResult> render(@NotNull IImageFactory factory) {
        this.myImageFactoryDelegate = factory;
        boolean forceMeasure = this.myTargetQuality > this.myCurrentQuality;
        this.myCurrentQuality = this.myTargetQuality;
        return this.renderInner(forceMeasure);
    }

    @NotNull
    public CompletableFuture<RenderResult> render() {
        return this.render(this.myCachingImageFactory);
    }

    public void setElapsedFrameTimeNanos(long nanos) {
        if (this.myRenderSession != null) {
            this.myRenderSession.setElapsedFrameTimeNanos(nanos);
        }
    }

    private void addDiagnostics(@NotNull Result result2) {
        ILayoutPullParser layoutEmbeddedParser;
        if (!this.myLogger.hasProblems() && !result2.isSuccess()) {
            if (result2.getException() != null || result2.getErrorMessage() != null) {
                this.myLogger.error(null, result2.getErrorMessage(), result2.getException(), null, null);
            } else if (result2.getStatus() == Result.Status.ERROR_TIMEOUT) {
                this.myLogger.error(null, "Rendering timed out.", null, null, null);
            } else {
                this.myLogger.error(null, "Unknown render problem: " + result2.getStatus(), null, null, null);
            }
        } else if (this.myIncludedWithin != null && this.myIncludedWithin != IncludeReference.NONE && (layoutEmbeddedParser = this.myLayoutlibCallback.getLayoutEmbeddedParser()) != null) {
            this.myLogger.error(null, String.format("The surrounding layout (%1$s) did not actually include this layout. Remove tools:showIn=... from the root tag.", this.myIncludedWithin.getFromResourceUrl()), null, null, null);
        }
    }

    @NotNull
    public CompletableFuture<BufferedImage> renderDrawable(@NotNull ResourceValue drawableResourceValue) {
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        RenderContext context2 = this.getContext();
        Configuration configuration = context2.getConfiguration();
        DrawableParams params = new DrawableParams(drawableResourceValue, context2.getModule().getModuleKey(), hardwareConfig, configuration.getResourceResolver(), this.myLayoutlibCallback, context2.getMinSdkVersion().getApiLevel(), context2.getTargetSdkVersion().getApiLevel(), this.myLogger);
        params.setForceNoDecor();
        params.setAssetRepository(context2.getModule().getAssetRepository());
        params.setFlag(RenderParamsFlags.FLAG_KEY_ADAPTIVE_ICON_MASK_PATH, configuration.getAdaptiveShape().getPathDescription());
        params.setFlag(RenderParamsFlags.FLAG_KEY_USE_THEMED_ICON, configuration.getUseThemedIcon());
        params.setFlag(RenderParamsFlags.FLAG_KEY_WALLPAPER_PATH, configuration.getWallpaperPath());
        return this.runAsyncRenderAction(() -> this.myLayoutLib.renderDrawable(params)).thenCompose(result2 -> {
            Throwable exception;
            if (result2 != null && result2.isSuccess()) {
                Object data = result2.getData();
                if (!(data instanceof BufferedImage)) {
                    data = null;
                }
                return CompletableFuture.completedFuture((BufferedImage)data);
            }
            if (result2.getStatus() == Result.Status.ERROR_NOT_A_DRAWABLE) {
                LOG.debug("renderDrawable called with a non-drawable resource" + drawableResourceValue);
                return CompletableFuture.completedFuture(null);
            }
            Throwable throwable = exception = result2 == null ? new RuntimeException("Rendering failed - null result") : result2.getException();
            if (exception == null) {
                String message2 = result2.getErrorMessage();
                exception = new RuntimeException((String)(message2 == null ? "Rendering failed" : "Rendering failed - " + message2));
            }
            this.reportException(exception);
            return RenderTask.immediateFailedFuture(exception);
        });
    }

    @NotNull
    private LayoutLibrary getLayoutLib() {
        return this.myLayoutLib;
    }

    @NotNull
    public LayoutlibCallbackImpl getLayoutlibCallback() {
        return this.myLayoutlibCallback;
    }

    private boolean isNonRectangular() {
        ResourceFolderType folderType = this.getContext().getFolderType();
        return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
    }

    private boolean requiresTransparency() {
        return this.isNonRectangular();
    }

    @NotNull
    public CompletableFuture<Map<RenderXmlTag, ViewInfo>> measureChildren(@NotNull RenderXmlTag parent, @Nullable AttributeFilter filter2) {
        LayoutRenderPullParser modelParser = LayoutRenderPullParser.create(filter2, parent, this.myLogger, this.myContext.getModule().getResourceRepositoryManager());
        HashMap map2 = new HashMap();
        return RenderService.getRenderAsyncActionExecutor().runAsyncAction(this.myTopic, () -> this.measure(modelParser)).thenComposeAsync(session -> {
            if (session != null) {
                try {
                    Result result2 = session.getResult();
                    if (result2 != null && result2.isSuccess()) {
                        assert (session.getRootViews().size() == 1);
                        ViewInfo root = session.getRootViews().get(0);
                        List<ViewInfo> children2 = root.getChildren();
                        for (ViewInfo info : children2) {
                            RenderXmlTag tag = RenderService.getXmlTag(info);
                            if (tag == null) continue;
                            map2.put(tag, info);
                        }
                    }
                    CompletableFuture<Map> completableFuture = CompletableFuture.completedFuture(map2);
                    return completableFuture;
                }
                finally {
                    this.disposeRenderSession((RenderSession)session);
                }
            }
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    public CompletableFuture<ViewInfo> measureChild(@NotNull RenderXmlTag tag, @Nullable AttributeFilter filter2) {
        RenderXmlTag parent = tag.getParentTag();
        if (parent == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.measureChildren(parent, filter2).thenApply(map2 -> (ViewInfo)map2.get(tag));
    }

    @Nullable
    private RenderSession measure(ILayoutPullParser parser) {
        RenderContext context2 = this.getContext();
        Configuration configuration = context2.getConfiguration();
        ResourceResolver resolver2 = configuration.getResourceResolver();
        this.myLayoutlibCallback.reset();
        HardwareConfig hardwareConfig = this.myHardwareConfigHelper.getConfig();
        SessionParams params = new SessionParams(parser, SessionParams.RenderingMode.NORMAL, context2.getModule().getModuleKey(), hardwareConfig, resolver2, this.myLayoutlibCallback, context2.getMinSdkVersion().getApiLevel(), context2.getTargetSdkVersion().getApiLevel(), this.myLogger);
        params.setForceNoDecor();
        params.setExtendedViewInfoMode(true);
        params.setLocale(this.myLocale.toLocaleId());
        params.setAssetRepository(context2.getModule().getAssetRepository());
        params.setFlag(RenderParamsFlags.FLAG_KEY_ADAPTIVE_ICON_MASK_PATH, configuration.getAdaptiveShape().getPathDescription());
        params.setFlag(RenderParamsFlags.FLAG_KEY_USE_THEMED_ICON, configuration.getUseThemedIcon());
        params.setFlag(RenderParamsFlags.FLAG_KEY_WALLPAPER_PATH, configuration.getWallpaperPath());
        @Nullable RenderModelManifest manifestInfo = context2.getModule().getManifest();
        params.setRtlSupport(manifestInfo != null && manifestInfo.isRtlSupported());
        try {
            this.myLayoutlibCallback.setLogger(this.myLogger);
            return this.myLayoutLib.createSession(params);
        }
        catch (RuntimeException t2) {
            this.myLogger.error(null, t2.getLocalizedMessage(), t2, null, null);
            throw t2;
        }
    }

    @NotNull
    public CompletableFuture<Void> runAsyncRenderActionWithSession(@NotNull Runnable block, long timeout, @NotNull TimeUnit unit) {
        if (this.isDisposed.get()) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("RenderTask was already disposed"));
        }
        RenderSession renderSession = this.myRenderSession;
        if (renderSession == null) {
            return RenderTask.immediateFailedFuture(new IllegalStateException("No RenderSession available"));
        }
        return this.runAsyncRenderAction(() -> {
            renderSession.execute(block);
            return null;
        }, timeout, unit);
    }

    @VisibleForTesting
    public void setCrashReporter(@NotNull CrashReporter crashReporter) {
        this.myCrashReporter = crashReporter;
    }

    @NotNull
    public RenderContext getContext() {
        return this.myContext;
    }

    @NotNull
    private CompletableFuture<Void> disposeRenderSession(@NotNull RenderSession renderSession) {
        return RenderSessionCleaner.dispose(renderSession, this.myModuleClassLoaderReference.getClassLoader());
    }

    public static interface TestEventListener {
        default public void onBeforeInflate() {
        }

        default public void onAfterInflate() {
        }

        default public void onBeforeRender() {
        }

        default public void onAfterRender() {
        }
    }

    public static interface AttributeFilter {
        @Nullable
        public String getAttribute(@NotNull RenderXmlTag var1, @Nullable String var2, @NotNull String var3);
    }
}

