/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering;

import com.android.AndroidXConstants;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.log.LogAnonymizer;
import com.android.tools.module.ViewClass;
import com.android.tools.rendering.IRenderLogger;
import com.android.tools.rendering.api.RenderModelModule;
import com.android.tools.rendering.log.LogAnonymizerUtil;
import com.android.tools.res.ids.ResourceIdManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewLoader {
    private static final Logger LOG = Logger.getInstance(ViewLoader.class);
    private static final int ALLOWED_NESTED_VIEWS = 100;
    @NotNull
    private final RenderModelModule myModule;
    @NotNull
    private final Map<String, Class<?>> myLoadedClasses = Maps.newHashMap();
    @NotNull
    private final Multiset<Class<?>> myLoadingClasses = HashMultiset.create(5);
    @Nullable
    private final Object myCredential;
    @NotNull
    private final LayoutLibrary myLayoutLibrary;
    @NotNull
    private IRenderLogger myLogger;
    @NotNull
    private final ClassLoader myClassLoader;

    public ViewLoader(@NotNull LayoutLibrary layoutLib, @NotNull RenderModelModule module, @NotNull IRenderLogger logger, @Nullable Object credential, @NotNull ClassLoader classLoader2) {
        this.myLayoutLibrary = layoutLib;
        this.myModule = module;
        this.myLogger = logger;
        this.myCredential = credential;
        this.myClassLoader = classLoader2;
    }

    public void setLogger(@NotNull IRenderLogger logger) {
        this.myLogger = logger;
    }

    @Nullable
    public Object loadClass(String className, Class<?>[] constructorSignature, Object[] constructorArgs) {
        if (AndroidXConstants.CLASS_RECYCLER_VIEW_ADAPTER.newName().equals(className)) {
            className = "com.android.layoutlib.bridge.android.androidx.Adapter";
            constructorSignature = ArrayUtil.EMPTY_CLASS_ARRAY;
            constructorArgs = ArrayUtil.EMPTY_OBJECT_ARRAY;
        } else if (AndroidXConstants.CLASS_RECYCLER_VIEW_ADAPTER.oldName().equals(className)) {
            className = "com.android.layoutlib.bridge.android.support.Adapter";
            constructorSignature = ArrayUtil.EMPTY_CLASS_ARRAY;
            constructorArgs = ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return this.loadClass(className, constructorSignature, constructorArgs, false);
    }

    @Nullable
    public Object loadView(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) throws ClassNotFoundException {
        Object aClass = this.loadClass(className, constructorSignature, constructorArgs, true);
        if (aClass != null) {
            return aClass;
        }
        try {
            Object o2 = this.createViewFromSuperclass(className, constructorSignature, constructorArgs);
            if (o2 != null) {
                return o2;
            }
            return this.myLayoutLibrary.createMockView(ViewLoader.getShortClassName(className), constructorSignature, constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            throw new ClassNotFoundException(className, e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object loadClass(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs, boolean isView) {
        block12: {
            Object object;
            Class<?> aClass = this.myLoadedClasses.get(className);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("loadClassA(%s)", LogAnonymizer.anonymizeClassName(className)));
            }
            if (aClass != null) {
                return this.createNewInstance(aClass, constructorSignature, constructorArgs, isView);
            }
            aClass = this.loadClass(className, isView);
            if (aClass == null) break block12;
            if (this.myLoadingClasses.count(aClass) > 100) {
                throw new InstantiationException("The layout involves creation of " + className + " over 100 levels deep. Infinite recursion?");
            }
            this.myLoadingClasses.add(aClass);
            try {
                Object viewObject = this.createNewInstance(aClass, constructorSignature, constructorArgs, isView);
                this.myLoadedClasses.put(className, aClass);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("  instance created");
                }
                object = viewObject;
                this.myLoadingClasses.remove(aClass);
            }
            catch (Throwable throwable) {
                try {
                    this.myLoadingClasses.remove(aClass);
                    throw throwable;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError | NoSuchMethodException e2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e2);
                    }
                    this.myLogger.addBrokenClass(className, e2);
                    break block12;
                }
                catch (InvocationTargetException e3) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e3);
                    }
                    Throwable cause = e3.getCause();
                    this.myLogger.addBrokenClass(className, cause);
                }
            }
            return object;
        }
        return null;
    }

    public boolean isClassLoaded(String name2) {
        return this.myLoadedClasses.containsKey(name2);
    }

    @VisibleForTesting
    @NotNull
    public static String getShortClassName(@NotNull String fqcn) {
        int first2 = fqcn.indexOf(46);
        int last2 = fqcn.lastIndexOf(46);
        if (fqcn.startsWith("android.") ? last2 > first2 : last2 > (first2 = fqcn.indexOf(46, first2 + 1)) && first2 >= 0) {
            return fqcn.substring(0, first2) + ".." + fqcn.substring(last2);
        }
        return fqcn;
    }

    @NotNull
    private Object createNewInstance(@NotNull Class<?> clazz, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorParameters, boolean isView) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException {
        Constructor<?> constructor;
        block10: {
            constructor = null;
            try {
                constructor = clazz.getConstructor(constructorSignature);
            }
            catch (NoSuchMethodException e2) {
                int paramsCount;
                if (!isView) {
                    throw e2;
                }
                int n2 = paramsCount = constructorSignature != null ? constructorSignature.length : 0;
                if (paramsCount == 0) {
                    throw e2;
                }
                assert (constructorParameters != null);
                for (int i2 = 3; i2 >= 1; --i2) {
                    if (i2 == paramsCount) continue;
                    int k2 = paramsCount < i2 ? paramsCount : i2;
                    Class[] sig = new Class[i2];
                    System.arraycopy(constructorSignature, 0, sig, 0, k2);
                    Object[] params = new Object[i2];
                    System.arraycopy(constructorParameters, 0, params, 0, k2);
                    for (int j2 = k2 + 1; j2 <= i2; ++j2) {
                        if (j2 == 2) {
                            sig[j2 - 1] = this.myLayoutLibrary.getClassLoader().loadClass("android.util.AttributeSet");
                            params[j2 - 1] = null;
                            continue;
                        }
                        if (j2 != 3) continue;
                        sig[j2 - 1] = Integer.TYPE;
                        params[j2 - 1] = 0;
                    }
                    constructorSignature = sig;
                    constructorParameters = params;
                    try {
                        constructor = clazz.getConstructor(constructorSignature);
                        if (constructor == null) continue;
                        if (constructorSignature.length >= 2) break;
                        LOG.info("wrong_constructor: Custom view " + clazz.getSimpleName() + " is not using the 2- or 3-argument View constructors; XML attributes will not work");
                        this.myLogger.warning("wrongconstructor", String.format("Custom view %1$s is not using the 2- or 3-argument View constructors; XML attributes will not work", clazz.getSimpleName()), null, null);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (constructor != null) break block10;
                throw e2;
            }
        }
        constructor.setAccessible(true);
        return constructor.newInstance(constructorParameters);
    }

    @Nullable
    public Class<?> loadClass(@NotNull String className, boolean logError) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadClassB(%s)", LogAnonymizer.anonymizeClassName(className)));
        }
        try {
            return this.myClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e2) {
            if (logError && !className.equals("fragment")) {
                this.myLogger.addMissingClass(className);
            }
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private Object createViewFromSuperclass(@NotNull String className, @Nullable Class<?>[] constructorSignature, @Nullable Object[] constructorArgs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void loadAndParseRClassSilently() {
        ResourceIdManager idManager = this.myModule.getResourceIdManager();
        idManager.resetCompiledIds(this::loadRClasses);
    }

    private void loadRClasses(@NotNull ResourceIdManager.RClassParser rClassParser) {
        this.myModule.getDependencies().getResourcePackageNames(true).forEach(resourcePackageName -> {
            try {
                if (resourcePackageName == null) {
                    LOG.info(String.format("loadAndParseRClass: failed to find manifest package for project %1$s", this.myModule.getProject().getName()));
                    return;
                }
                String rClassName = resourcePackageName + ".R";
                this.myLogger.setResourceClass(rClassName);
                this.loadAndParseRClass(rClassName, rClassParser);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e2) {
                this.myLogger.setMissingResourceClass();
            }
        });
    }

    @VisibleForTesting
    public void loadAndParseRClass(@NotNull String className, @NotNull ResourceIdManager.RClassParser rClassParser) throws ClassNotFoundException {
        Class<?> aClass;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("loadAndParseRClass(%s)", LogAnonymizer.anonymizeClassName(className)));
        }
        if ((aClass = this.myLoadedClasses.get(className)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  The R class is not loaded.");
            }
            boolean isClassLoaded = this.hasLoadedClass(className);
            aClass = this.myClassLoader.loadClass(className);
            if (!isClassLoaded) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("  Class found in module %s, first time load.", LogAnonymizerUtil.anonymize(this.myModule)));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("  Class already loaded in module %s.", LogAnonymizerUtil.anonymize(this.myModule)));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Class loaded");
            }
            this.myLoadedClasses.put(className, aClass);
            this.myLogger.setHasLoadedClasses();
        }
        rClassParser.parse(aClass);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("END loadAndParseRClass(%s)", LogAnonymizer.anonymizeClassName(className)));
        }
    }

    private boolean hasLoadedClass(@NotNull String classFqn) {
        return this.myLoadedClasses.containsKey(classFqn);
    }

    private /* synthetic */ Class lambda$createViewFromSuperclass$0(String className) {
        ViewClass viewClass = this.myModule.getDependencies().findViewClass(className);
        if (viewClass == null) {
            return null;
        }
        HashSet<String> visited = new HashSet<String>();
        for (viewClass = viewClass.getSuperClass(); viewClass != null; viewClass = viewClass.getSuperClass()) {
            String qName = viewClass.getQualifiedName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("  parent " + LogAnonymizer.anonymizeClassName(qName));
            }
            if (qName == null || !visited.add(qName) || "android.view.View".equals(viewClass.getQualifiedName())) break;
            if (viewClass.isAbstract()) continue;
            try {
                Class<?> aClass = this.myLoadedClasses.get(qName);
                if (aClass == null && (aClass = this.myLayoutLibrary.getClassLoader().loadClass(qName)) != null) {
                    this.myLoadedClasses.put(qName, aClass);
                }
                if (aClass == null) continue;
                return aClass;
            }
            catch (Throwable e2) {
                LOG.debug(e2);
            }
        }
        return null;
    }
}

