/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.classloading;

import com.android.tools.rendering.classloading.ClassTransform;
import com.android.tools.rendering.classloading.ClassWriterWithPseudoClassLocator;
import com.android.tools.rendering.classloading.PseudoClassLocator;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.lang.JavaVersion;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassConverter {
    private static final int ourCurrentJdkClassVersion = ClassConverter.jdkToClassVersion(SystemInfo.JAVA_VERSION);

    @NotNull
    public static byte[] rewriteClass(@NotNull byte[] classData, @NotNull ClassTransform transformations, int flags, @NotNull PseudoClassLocator classLocator) {
        ClassReader reader = new ClassReader(classData);
        ClassWriterWithPseudoClassLocator classWriter = new ClassWriterWithPseudoClassLocator(flags, classLocator);
        ClassVisitor classVisitor = transformations.invoke(classWriter);
        reader.accept(classVisitor, 8);
        return classWriter.toByteArray();
    }

    @NotNull
    public static byte[] rewriteClass(@NotNull byte[] classData, @NotNull ClassTransform transformations, @NotNull PseudoClassLocator classLocator) {
        return ClassConverter.rewriteClass(classData, transformations, 2, classLocator);
    }

    public static int jdkToClassVersion(@NotNull String version) {
        JavaVersion javaVersion = JavaVersion.tryParse(version);
        return javaVersion != null ? javaVersion.feature + 44 : -1;
    }

    public static int getCurrentClassVersion() {
        return ourCurrentJdkClassVersion;
    }

    public static boolean isValidClassFile(@NotNull byte[] classData) {
        return classData.length >= 7 && ClassConverter.getMagic(classData) == -889275714;
    }

    public static int getMagic(@NotNull byte[] classData) {
        return Ints.fromBytes(classData[0], classData[1], classData[2], classData[3]);
    }

    public static short getMajorVersion(byte[] classData) {
        return Shorts.fromBytes(classData[6], classData[7]);
    }

    public static short getMinorVersion(byte[] classData) {
        return Shorts.fromBytes(classData[4], classData[5]);
    }
}

