/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.imagepool;

import com.android.tools.rendering.imagepool.ImagePool;
import com.android.tools.rendering.imagepool.ImagePoolImpl;
import com.android.tools.rendering.imagepool.NonPooledImage;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImagePoolFactory {
    private static final ImagePool NO_POOL_INSTANCE = new ImagePool(){

        @Override
        @NotNull
        public ImagePool.Image create(int w2, int h2, int type) {
            return NonPooledImage.create(w2, h2, type);
        }

        @Override
        @NotNull
        public ImagePool.Image copyOf(@Nullable BufferedImage origin2) {
            return origin2 != null ? NonPooledImage.copyOf(origin2) : NULL_POOLED_IMAGE;
        }

        @Override
        @Nullable
        public ImagePool.Stats getStats() {
            return null;
        }

        @Override
        public void dispose() {
        }
    };

    private ImagePoolFactory() {
    }

    @NotNull
    public static ImagePool createImagePool() {
        return new ImagePoolImpl(new int[]{50, 500, 1000, 1500, 2000, 5000}, (w2, h2) -> type -> {
            if (w2 * h2 < 1000) {
                return 0;
            }
            return 50000000 / (w2 * h2);
        });
    }

    @NotNull
    public static ImagePool getNonPooledPool() {
        return NO_POOL_INSTANCE;
    }
}

