/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.parsers;

import com.android.tools.rendering.parsers.RenderXmlAttribute;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.utils.DataBindingUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeSnapshot {
    @Nullable
    public String namespace;
    @Nullable
    public String prefix;
    @NotNull
    public String name;
    @Nullable
    public String value;

    public AttributeSnapshot(@Nullable String namespace, @Nullable String prefix, @NotNull String name2, @Nullable String value) {
        this.namespace = namespace;
        this.prefix = prefix == null || prefix.isEmpty() ? null : prefix;
        this.name = name2;
        this.value = value;
    }

    @Nullable
    public static AttributeSnapshot createAttributeSnapshot(@NotNull RenderXmlAttribute attribute) {
        String localName = attribute.getLocalName();
        String namespace = attribute.getNamespace();
        String prefix = attribute.getNamespacePrefix();
        String value = attribute.getValue();
        if (value != null && DataBindingUtils.isBindingExpression(value) && (value = attribute.getBindingExprDefault()) == null) {
            return null;
        }
        return new AttributeSnapshot(namespace, prefix, localName, value);
    }

    @NotNull
    public static List<AttributeSnapshot> createAttributesForTag(@NotNull RenderXmlTag tag) {
        List<RenderXmlAttribute> renderAttributes = tag.getAttributes();
        ArrayList<AttributeSnapshot> attributes = Lists.newArrayListWithExpectedSize(renderAttributes.size());
        for (RenderXmlAttribute renderAttribute : renderAttributes) {
            AttributeSnapshot attribute;
            if (renderAttribute.isNamespaceDeclaration() || (attribute = AttributeSnapshot.createAttributeSnapshot(renderAttribute)) == null) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    public String toString() {
        return "AttributeSnapshot{" + this.name + "=\"" + this.value + "\"}";
    }
}

