/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.parsers;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.rendering.parsers.LayoutPullParser;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParserException;

public class DomPullParser
extends LayoutPullParser {
    @NotNull
    private final List<Element> myNodeStack;
    private final Element myRoot;
    private final boolean myElementAsCookie;

    private DomPullParser(Element root, boolean elementAsCookie) {
        this.myRoot = root;
        this.myNodeStack = new ArrayList<Element>();
        this.myElementAsCookie = elementAsCookie;
    }

    @VisibleForTesting
    public Element getRoot() {
        return this.myRoot;
    }

    protected Element getCurrentElement() {
        if (!this.myNodeStack.isEmpty()) {
            return this.myNodeStack.get(this.myNodeStack.size() - 1);
        }
        return null;
    }

    private Attr getAttribute(int i2) {
        if (this.myParsingState != 2) {
            throw new IndexOutOfBoundsException();
        }
        Element element = this.getCurrentElement();
        if (element != null) {
            return (Attr)element.getAttributes().item(i2);
        }
        return null;
    }

    private void push(@NotNull Element node) {
        this.myNodeStack.add(node);
    }

    @NotNull
    private Element pop() {
        return this.myNodeStack.remove(this.myNodeStack.size() - 1);
    }

    @Override
    public Object getViewCookie() {
        if (this.myElementAsCookie) {
            return this.getCurrentElement();
        }
        return null;
    }

    @Override
    public ResourceNamespace getLayoutNamespace() {
        if (this.myRoot == null) {
            return ResourceNamespace.RES_AUTO;
        }
        String uri = this.myRoot.getNamespaceURI();
        if (uri == null) {
            return ResourceNamespace.RES_AUTO;
        }
        ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri(uri);
        return namespace != null ? namespace : ResourceNamespace.RES_AUTO;
    }

    @Override
    public String getPositionDescription() {
        return "XML DOM element depth:" + this.myNodeStack.size();
    }

    @Override
    public int getAttributeCount() {
        Element node = this.getCurrentElement();
        if (node != null) {
            return node.getAttributes().getLength();
        }
        return 0;
    }

    @Override
    public String getAttributeName(int i2) {
        Attr attribute = this.getAttribute(i2);
        if (attribute != null) {
            String localName = attribute.getLocalName();
            if (localName == null) {
                return attribute.getName();
            }
            return localName;
        }
        return null;
    }

    @Override
    public String getAttributeNamespace(int i2) {
        Attr attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.getNamespaceURI();
        }
        return "";
    }

    @Override
    public String getAttributePrefix(int i2) {
        Attr attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.getPrefix();
        }
        return null;
    }

    @Override
    public String getAttributeValue(int i2) {
        Attr attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    @Override
    public String getAttributeValue(String namespace, String localName) {
        Element element = this.getCurrentElement();
        if (element != null) {
            Attr attribute = element.getAttributeNodeNS(namespace, localName);
            if (attribute == null && namespace != null && !namespace.equals("http://schemas.android.com/apk/res/android")) {
                attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", localName);
            }
            if (attribute != null) {
                return attribute.getValue();
            }
        }
        return null;
    }

    @Override
    public int getDepth() {
        return this.myNodeStack.size();
    }

    @Override
    public String getName() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getTagName();
        }
        return null;
    }

    @Override
    public String getNamespace() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getNamespaceURI();
        }
        return null;
    }

    @Override
    public String getPrefix() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getPrefix();
        }
        return null;
    }

    @Override
    public String getNamespace(String prefix) {
        Element currentNode = this.getCurrentElement();
        return currentNode != null ? currentNode.lookupNamespaceURI(prefix) : null;
    }

    @Override
    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.myParsingState == 2) {
            Element currentNode = this.getCurrentElement();
            assert (currentNode != null);
            return currentNode.getChildNodes().getLength() == 0;
        }
        throw new XmlPullParserException("Call to isEmptyElementTag while not in START_TAG", this, null);
    }

    @Override
    protected void onNextFromStartDocument() {
        if (this.myRoot != null) {
            this.push(this.myRoot);
            this.myParsingState = 2;
        } else {
            this.myParsingState = 1;
        }
    }

    @Override
    protected void onNextFromStartTag() {
        Element node = this.getCurrentElement();
        assert (node != null);
        Element first2 = XmlUtils.getFirstSubTag(node);
        if (first2 != null) {
            this.push(first2);
            this.myParsingState = 2;
        } else {
            this.myParsingState = this.myParsingState == 0 ? 1 : 3;
        }
    }

    @Override
    protected void onNextFromEndTag() {
        Node sibling;
        Element node = this.getCurrentElement();
        assert (node != null);
        for (sibling = node.getNextSibling(); sibling != null && !(sibling instanceof Element); sibling = sibling.getNextSibling()) {
        }
        if (sibling != null) {
            node = (Element)sibling;
            this.pop();
            this.push(node);
            this.myParsingState = 2;
        } else {
            this.pop();
            this.myParsingState = this.myNodeStack.isEmpty() ? 1 : 3;
        }
    }

    private static DocumentBuilder createNewDocumentBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newDefaultInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        try {
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            Logger.getInstance(DomPullParser.class).error(e2);
            return null;
        }
    }

    public static Document createEmptyPlainDocument() {
        DocumentBuilder builder = DomPullParser.createNewDocumentBuilder();
        return builder != null ? builder.newDocument() : null;
    }

    @NotNull
    public static ILayoutPullParser createFromDocument(@NotNull Document document) {
        return new DomPullParser(document.getDocumentElement(), true);
    }

    @NotNull
    public static ILayoutPullParser createFromDocument(@NotNull Document document, boolean elementAsCookie) {
        return new DomPullParser(document.getDocumentElement(), elementAsCookie);
    }
}

