/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.parsers;

import com.android.AndroidXConstants;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceFolderType;
import com.android.tools.apk.analyzer.ResourceIdResolver;
import com.android.tools.fonts.DownloadableFontCacheService;
import com.android.tools.fonts.ProjectFonts;
import com.android.tools.rendering.IRenderLogger;
import com.android.tools.rendering.RenderTask;
import com.android.tools.rendering.api.NavGraphResolver;
import com.android.tools.rendering.parsers.DomPullParser;
import com.android.tools.rendering.parsers.LayoutRenderPullParser;
import com.android.tools.rendering.parsers.MenuLayoutParserFactory;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.res.ids.ResourceIdManagerHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.openapi.application.ApplicationManager;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LayoutPullParsers {
    static final boolean DEBUG = false;
    private static final String[] VALID_XML_TAGS = new String[]{"appwidget-provider", "PreferenceScreen", AndroidXConstants.PreferenceAndroidX.CLASS_PREFERENCE_SCREEN_ANDROIDX.oldName(), AndroidXConstants.PreferenceAndroidX.CLASS_PREFERENCE_SCREEN_ANDROIDX.newName()};
    private static final String[] ADAPTIVE_ICON_TAGS = new String[]{"adaptive-icon", "maskable-icon"};
    private static final String[] FONT_FAMILY_TAGS = new String[]{"font-family"};
    private static final EnumSet<ResourceFolderType> FOLDER_NEEDS_READ_ACCESS = EnumSet.of(ResourceFolderType.DRAWABLE, ResourceFolderType.MIPMAP, ResourceFolderType.MENU, ResourceFolderType.XML, ResourceFolderType.FONT);

    private LayoutPullParsers() {
    }

    private static boolean isXmlWithRootTag(@NotNull RenderXmlFile file2, @NotNull String[] rootTags) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RenderXmlTag rootTag = file2.getRootTag();
        if (rootTag == null) {
            return false;
        }
        String tag = rootTag.getName();
        for (String validRootTags : rootTags) {
            if (!validRootTags.equals(tag)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupported(@NotNull RenderXmlFile file2) {
        ResourceFolderType folderType = file2.getFolderType();
        if (folderType == null) {
            return false;
        }
        switch (folderType) {
            case LAYOUT: 
            case DRAWABLE: 
            case MENU: {
                return true;
            }
            case MIPMAP: {
                return LayoutPullParsers.isXmlWithRootTag(file2, ADAPTIVE_ICON_TAGS);
            }
            case XML: {
                return LayoutPullParsers.isXmlWithRootTag(file2, VALID_XML_TAGS);
            }
            case FONT: {
                return LayoutPullParsers.isXmlWithRootTag(file2, FONT_FAMILY_TAGS);
            }
        }
        return false;
    }

    @Nullable
    public static ILayoutPullParser create(@NotNull RenderTask renderTask2) {
        ResourceFolderType folderType = renderTask2.getContext().getFolderType();
        if (folderType == null) {
            return null;
        }
        if (FOLDER_NEEDS_READ_ACCESS.contains((Object)folderType) && !ApplicationManager.getApplication().isReadAccessAllowed()) {
            return ApplicationManager.getApplication().runReadAction(() -> LayoutPullParsers.create(renderTask2));
        }
        RenderXmlFile file2 = renderTask2.getXmlFile();
        if (file2 == null) {
            throw new IllegalArgumentException("RenderTask always should always have PsiFile when it has ResourceFolderType");
        }
        ResourceRepositoryManager manager = renderTask2.getContext().getModule().getResourceRepositoryManager();
        switch (folderType) {
            case LAYOUT: {
                IRenderLogger logger = renderTask2.getLogger();
                ResourceResolver resourceResolver = renderTask2.getContext().getConfiguration().getResourceResolver();
                NavGraphResolver navGraphResolver = renderTask2.getContext().getModule().getEnvironment().getNavGraphResolver(resourceResolver);
                boolean useToolsNamespace = renderTask2.getShowWithToolsVisibilityAndPosition();
                return LayoutRenderPullParser.create(file2, logger, navGraphResolver, manager, useToolsNamespace);
            }
            case DRAWABLE: 
            case MIPMAP: {
                renderTask2.setDecorations(false);
                return LayoutPullParsers.createDrawableParser(file2);
            }
            case MENU: {
                renderTask2.setDecorations(true);
                return LayoutPullParsers.createMenuParser(file2, renderTask2);
            }
            case XML: {
                RenderXmlTag rootTag = file2.getRootTag();
                if (rootTag != null) {
                    String tag = rootTag.getName();
                    if (tag.equals("appwidget-provider")) {
                        renderTask2.setDecorations(false);
                        return LayoutPullParsers.createWidgetParser(rootTag);
                    }
                    if (tag.equals("PreferenceScreen") || AndroidXConstants.PreferenceAndroidX.CLASS_PREFERENCE_SCREEN_ANDROIDX.isEquals(tag)) {
                        IRenderLogger logger = renderTask2.getLogger();
                        ResourceResolver resourceResolver = renderTask2.getContext().getConfiguration().getResourceResolver();
                        NavGraphResolver navGraphResolver = renderTask2.getContext().getModule().getEnvironment().getNavGraphResolver(resourceResolver);
                        return LayoutRenderPullParser.create(file2, logger, navGraphResolver, manager, true);
                    }
                }
                return null;
            }
            case FONT: {
                renderTask2.setTransparentBackground();
                renderTask2.setDecorations(false);
                renderTask2.setRenderingMode(SessionParams.RenderingMode.V_SCROLL);
                ResourceIdResolver resolver2 = ResourceIdManagerHelper.getResolver(renderTask2.getContext().getModule().getResourceIdManager());
                DownloadableFontCacheService fontService = renderTask2.getContext().getModule().getEnvironment().getDownloadableFontCacheService();
                return LayoutPullParsers.createFontFamilyParser(file2, fontName -> new ProjectFonts(fontService, manager, resolver2).getFont((String)fontName), renderTask2.getDefaultForegroundColor());
            }
        }
        assert (false) : folderType;
        return null;
    }

    private static ILayoutPullParser createDrawableParser(RenderXmlFile file2) {
        String scaleType;
        Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element imageView = LayoutPullParsers.addRootElement(document, "ImageView", file2.getResourceNamespace());
        LayoutPullParsers.setAndroidAttr(imageView, "layout_width", "fill_parent");
        LayoutPullParsers.setAndroidAttr(imageView, "layout_height", "fill_parent");
        ResourceFolderType type = file2.getFolderType();
        assert (type != null);
        LayoutPullParsers.setAndroidAttr(imageView, "src", file2.getRelativePath());
        String background = file2.getRootTagAttribute("background", "http://schemas.android.com/tools");
        if (background != null && !background.isEmpty()) {
            LayoutPullParsers.setAndroidAttr(imageView, "background", background);
        }
        if ((scaleType = file2.getRootTagAttribute("scaleType", "http://schemas.android.com/tools")) != null && !scaleType.isEmpty()) {
            LayoutPullParsers.setAndroidAttr(imageView, "scaleType", scaleType);
        }
        return DomPullParser.createFromDocument(document);
    }

    @NotNull
    private static ILayoutPullParser createMenuParser(@NotNull RenderXmlFile file2, @NotNull RenderTask task) {
        RenderXmlTag tag = file2.getRootTag();
        if (tag != null && Objects.equals(tag.getAttributeValue("showIn", "http://schemas.android.com/tools"), "navigation_view")) {
            task.setDecorations(false);
            return MenuLayoutParserFactory.createInNavigationView(file2, task.getContext().getModule().getDependencies());
        }
        return MenuLayoutParserFactory.create(file2, task.getLayoutlibCallback());
    }

    @Nullable
    private static ILayoutPullParser createWidgetParser(RenderXmlTag rootTag) {
        String layout = rootTag.getAttributeValue("initialLayout", "http://schemas.android.com/apk/res/android");
        String preview = rootTag.getAttributeValue("previewImage", "http://schemas.android.com/apk/res/android");
        if (layout == null && preview == null) {
            return null;
        }
        Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element root = LayoutPullParsers.addRootElement(document, layout != null ? "include" : "ImageView", rootTag.getResourceNamespace());
        if (layout != null) {
            root.setAttribute("layout", layout);
            LayoutPullParsers.setAndroidAttr(root, "layout_width", "fill_parent");
            LayoutPullParsers.setAndroidAttr(root, "layout_height", "fill_parent");
        } else {
            root.setAttribute("src", preview);
            LayoutPullParsers.setAndroidAttr(root, "layout_width", "wrap_content");
            LayoutPullParsers.setAndroidAttr(root, "layout_height", "wrap_content");
        }
        return DomPullParser.createFromDocument(document);
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    @Nullable
    public static ILayoutPullParser createFontFamilyParser(@NotNull RenderXmlFile file, @NotNull Function<String, FontFamily> getDownloadableFont, @NotNull String fontColor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.TernaryExpression.applyExpressionRewriter(TernaryExpression.java:106)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Element addRootElement(@NotNull Document document, @NotNull String tag, @Nullable ResourceNamespace namespace) {
        Element root = document.createElementNS(namespace != null ? namespace.getXmlNamespaceUri() : null, tag);
        Attr attr = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:android");
        attr.setValue("http://schemas.android.com/apk/res/android");
        root.getAttributes().setNamedItemNS(attr);
        document.appendChild(root);
        return root;
    }

    public static Element setAndroidAttr(Element element, String name2, String value) {
        element.setAttributeNS("http://schemas.android.com/apk/res/android", name2, value);
        return element;
    }

    public static ILayoutPullParser createEmptyParser() {
        Document document = DomPullParser.createEmptyPlainDocument();
        assert (document != null);
        Element root = LayoutPullParsers.addRootElement(document, "FrameLayout", null);
        LayoutPullParsers.setAndroidAttr(root, "layout_width", "fill_parent");
        LayoutPullParsers.setAndroidAttr(root, "layout_height", "fill_parent");
        return DomPullParser.createFromDocument(document);
    }

    private static /* synthetic */ void lambda$createFontFamilyParser$5(boolean[] hasElements, Document document, String loremText, String fontColor, Element rootLayout, String[] font) {
        hasElements[0] = true;
        Element fontElement = document.createElement("TextView");
        LayoutPullParsers.setAndroidAttr(fontElement, "layout_width", "wrap_content");
        LayoutPullParsers.setAndroidAttr(fontElement, "layout_height", "wrap_content");
        LayoutPullParsers.setAndroidAttr(fontElement, "text", loremText);
        LayoutPullParsers.setAndroidAttr(fontElement, "fontFamily", font[0]);
        LayoutPullParsers.setAndroidAttr(fontElement, "textSize", "30sp");
        LayoutPullParsers.setAndroidAttr(fontElement, "textColor", fontColor);
        LayoutPullParsers.setAndroidAttr(fontElement, "paddingBottom", "20dp");
        LayoutPullParsers.setAndroidAttr(fontElement, "textStyle", font[1]);
        rootLayout.appendChild(fontElement);
    }

    private static /* synthetic */ boolean lambda$createFontFamilyParser$4(String[] font) {
        return !Strings.isNullOrEmpty(font[0]);
    }
}

