/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rendering.parsers;

import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.ide.common.resources.sampledata.SampleDataManager;
import com.android.resources.ResourceFolderType;
import com.android.support.FragmentTagUtil;
import com.android.tools.rendering.IRenderLogger;
import com.android.tools.rendering.RenderTask;
import com.android.tools.rendering.api.NavGraphResolver;
import com.android.tools.rendering.parsers.AaptAttrAttributeSnapshot;
import com.android.tools.rendering.parsers.AaptAttrParser;
import com.android.tools.rendering.parsers.AttributeSnapshot;
import com.android.tools.rendering.parsers.LayoutPullParser;
import com.android.tools.rendering.parsers.MenuRenderPullParser;
import com.android.tools.rendering.parsers.RenderXmlAttribute;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.android.tools.rendering.parsers.TagSnapshot;
import com.android.tools.res.ResourceRepositoryManager;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutRenderPullParser
extends LayoutPullParser
implements AaptAttrParser {
    final NavGraphResolver myNavGraphResolver;
    private static final ImmutableSet<String> TAGS_SUPPORTING_SRC_COMPAT = ImmutableSet.of("ImageButton", "ImageView");
    private static final TagSnapshot EMPTY_LAYOUT = TagSnapshot.createSyntheticTag(null, "LinearLayout", "android", "http://schemas.android.com/apk/res/android", ImmutableList.of(new AttributeSnapshot("http://schemas.android.com/apk/res/android", "android", "layout_width", "match_parent"), new AttributeSnapshot("http://schemas.android.com/apk/res/android", "android", "layout_height", "match_parent")), ImmutableList.of(), null);
    private static final Consumer<TagSnapshot> TAG_SNAPSHOT_DECORATOR = tagSnapshot -> {
        if ("com.google.android.gms.ads.AdView".equals(tagSnapshot.tagName) || "com.google.android.gms.maps.MapView".equals(tagSnapshot.tagName)) {
            tagSnapshot.setAttribute("minWidth", "http://schemas.android.com/tools", "tools", "50dp", false);
            tagSnapshot.setAttribute("minHeight", "http://schemas.android.com/tools", "tools", "50dp", false);
            tagSnapshot.setAttribute("background", "http://schemas.android.com/tools", "tools", "#AAA", false);
        } else if ((tagSnapshot.tagName.equals("ListView") || tagSnapshot.tagName.equals("ExpandableListView") || tagSnapshot.tagName.equals("GridView") || tagSnapshot.tagName.equals("Spinner")) && tagSnapshot.getAttribute("id", "http://schemas.android.com/apk/res/android") == null) {
            String prefix;
            String string2 = prefix = tagSnapshot.tag != null ? tagSnapshot.tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android") : null;
            if (prefix != null) {
                tagSnapshot.setAttribute("id", "http://schemas.android.com/apk/res/android", prefix, "@+id/_dynamic");
            }
        }
    };
    @NotNull
    private final ILayoutLog myLogger;
    @NotNull
    private final List<TagSnapshot> myNodeStack = new ArrayList<TagSnapshot>();
    public final TagSnapshot myRoot;
    @NotNull
    protected final Map<String, String> myNamespacePrefixToUri = new HashMap<String, String>();
    private final boolean myHasToolsNamespace;
    private final ResourceNamespace myLayoutNamespace;
    protected boolean myProvideViewCookies = true;
    private boolean myUseSrcCompat;
    private boolean myUseToolsPositionAndVisibility;
    private HashSet<String> myToolsPositionAndVisibilityAttributes = new HashSet<String>(Arrays.asList("layout_editor_absoluteX", "layout_editor_absoluteY", "visibility"));
    private final ImmutableMap<String, TagSnapshot> myDeclaredAaptAttrs;
    private int mySampleDataCounter;
    private final Map<String, AtomicInteger> mySampleDataCounterMap = new HashMap<String, AtomicInteger>();
    private final Consumer<TagSnapshot> mySampleDataProcessing = tagSnapshot -> {
        for (AttributeSnapshot attributeSnapshot : tagSnapshot.attributes) {
            String resourceUrl = attributeSnapshot.value;
            if (resourceUrl == null || !resourceUrl.startsWith("@sample/") && !resourceUrl.startsWith("@tools:sample/")) continue;
            String resourceName = SampleDataManager.getResourceNameFromSampleReference(resourceUrl);
            AtomicInteger position = this.mySampleDataCounterMap.get(resourceName);
            if (position == null) {
                position = new AtomicInteger(this.mySampleDataCounter);
                this.mySampleDataCounterMap.put(resourceName, position);
            }
            attributeSnapshot.value = LayoutRenderPullParser.getSampleDataResourceUrl(resourceUrl, position);
        }
    };

    @NotNull
    public static LayoutRenderPullParser create(@NotNull RenderXmlFile file2, @NotNull IRenderLogger logger, boolean honorMergeParentTag, NavGraphResolver navGraphResolver, ResourceRepositoryManager resourceRepositoryManager, int sampleDataCounter) {
        if (file2.getFolderType() == ResourceFolderType.MENU) {
            return new MenuRenderPullParser(file2, logger, resourceRepositoryManager);
        }
        return new LayoutRenderPullParser(file2, (ILayoutLog)logger, honorMergeParentTag, navGraphResolver, resourceRepositoryManager, sampleDataCounter);
    }

    @NotNull
    public static LayoutRenderPullParser create(@NotNull RenderXmlFile file2, @NotNull IRenderLogger logger, ResourceRepositoryManager resourceRepositoryManager) {
        return LayoutRenderPullParser.create(file2, logger, true, null, resourceRepositoryManager, 0);
    }

    @NotNull
    public static LayoutRenderPullParser create(@NotNull RenderXmlFile file2, @NotNull IRenderLogger logger, NavGraphResolver navGraphResolver, ResourceRepositoryManager resourceRepositoryManager, @NotNull Boolean useToolsPositionAndVisibility) {
        return new LayoutRenderPullParser(file2, (ILayoutLog)logger, true, navGraphResolver, resourceRepositoryManager, useToolsPositionAndVisibility);
    }

    @NotNull
    public static LayoutRenderPullParser create(RenderTask.AttributeFilter filter2, @NotNull RenderXmlTag root, @NotNull IRenderLogger logger, ResourceRepositoryManager resourceRepositoryManager) {
        return new AttributeFilteredLayoutParser(root, (ILayoutLog)logger, filter2, resourceRepositoryManager);
    }

    @NotNull
    public static LayoutRenderPullParser create(@NotNull TagSnapshot root, @NotNull ResourceNamespace layoutNamespace, @NotNull ILayoutLog log) {
        return new LayoutRenderPullParser(root, layoutNamespace, log);
    }

    protected LayoutRenderPullParser(@NotNull RenderXmlFile file2, @NotNull ILayoutLog logger, boolean honorMergeParentTag, ResourceRepositoryManager resourceRepositoryManager) {
        this(file2, logger, honorMergeParentTag, null, resourceRepositoryManager, 0);
    }

    protected LayoutRenderPullParser(@NotNull RenderXmlFile file2, @NotNull ILayoutLog logger, boolean honorMergeParentTag, NavGraphResolver navGraphResolver, ResourceRepositoryManager resourceRepositoryManager, int sampleDataCounter) {
        this(file2.getRootTag(), logger, honorMergeParentTag, navGraphResolver, resourceRepositoryManager, sampleDataCounter, true);
    }

    protected LayoutRenderPullParser(@NotNull RenderXmlFile file2, @NotNull ILayoutLog logger, boolean honorMergeParentTag, NavGraphResolver navGraphResolver, ResourceRepositoryManager resourceRepositoryManager, boolean useToolsPositionAndVisibility) {
        this(file2.getRootTag(), logger, honorMergeParentTag, navGraphResolver, resourceRepositoryManager, 0, useToolsPositionAndVisibility);
    }

    private static String computeUriFromPrefix(TagSnapshot root, @NotNull String prefix) {
        RenderXmlTag rootTag;
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return ApplicationManager.getApplication().runReadAction(() -> LayoutRenderPullParser.computeUriFromPrefix(root, prefix));
        }
        RenderXmlTag renderXmlTag = rootTag = root != null ? root.tag : null;
        if (rootTag == null || !rootTag.isValid()) {
            return null;
        }
        return rootTag.getNamespaceByPrefix(prefix);
    }

    private static boolean hasToolsNamespace(TagSnapshot root) {
        RenderXmlTag rootTag;
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return ApplicationManager.getApplication().runReadAction(() -> LayoutRenderPullParser.hasToolsNamespace(root));
        }
        RenderXmlTag renderXmlTag = rootTag = root != null ? root.tag : null;
        if (rootTag == null || !rootTag.isValid()) {
            return false;
        }
        return rootTag.getPrefixByNamespace("http://schemas.android.com/tools") != null;
    }

    public LayoutRenderPullParser(RenderXmlTag root, @NotNull ILayoutLog logger, boolean honorMergeParentTag, NavGraphResolver navGraphResolver, ResourceRepositoryManager resourceRepositoryManager) {
        this(root, logger, honorMergeParentTag, navGraphResolver, resourceRepositoryManager, 0, true);
    }

    protected LayoutRenderPullParser(RenderXmlTag root, @NotNull ILayoutLog logger, boolean honorMergeParentTag, NavGraphResolver navGraphResolver, ResourceRepositoryManager repositoryManager, int sampleDataCounter, boolean useToolsPositionAndVisibility) {
        this.myNavGraphResolver = navGraphResolver;
        this.myLogger = logger;
        this.mySampleDataCounter = sampleDataCounter;
        this.myUseToolsPositionAndVisibility = useToolsPositionAndVisibility;
        Ref<TagSnapshot> myRootRef = new Ref<TagSnapshot>(EMPTY_LAYOUT);
        Ref<ResourceNamespace> myLayoutNamespaceRef = new Ref<ResourceNamespace>(ResourceNamespace.RES_AUTO);
        ReadAction.run(() -> {
            if (root != null && root.isValid()) {
                myRootRef.set(LayoutRenderPullParser.createSnapshot(root, honorMergeParentTag, this.mySampleDataProcessing));
                if (repositoryManager != null) {
                    myLayoutNamespaceRef.set(repositoryManager.getNamespace());
                }
            }
        });
        this.myRoot = myRootRef.get();
        this.myLayoutNamespace = myLayoutNamespaceRef.get();
        this.myHasToolsNamespace = LayoutRenderPullParser.hasToolsNamespace(this.myRoot);
        this.myDeclaredAaptAttrs = LayoutRenderPullParser.findDeclaredAaptAttrs(this.myRoot);
    }

    protected LayoutRenderPullParser(@NotNull TagSnapshot root, @NotNull ResourceNamespace layoutNamespace, @NotNull ILayoutLog log) {
        this.myNavGraphResolver = null;
        this.myLogger = log;
        this.myDeclaredAaptAttrs = ImmutableMap.of();
        this.myRoot = ApplicationManager.getApplication().runReadAction(() -> {
            if (root.tag != null && root.tag.isValid()) {
                return root;
            }
            return null;
        });
        this.myHasToolsNamespace = LayoutRenderPullParser.hasToolsNamespace(this.myRoot);
        this.myLayoutNamespace = layoutNamespace;
    }

    @NotNull
    private static String getSampleDataResourceUrl(@NotNull String resourceUrl, @NotNull AtomicInteger offset) {
        int start = resourceUrl.indexOf(91);
        if (start != -1) {
            int separator = resourceUrl.indexOf(":", start);
            if (separator != -1) {
                int end = resourceUrl.indexOf(93);
                List<String> indices = Splitter.on(":").limit(2).splitToList(resourceUrl.substring(start + 1, end));
                String bottom = indices.get(0);
                String top = indices.get(1);
                try {
                    int low = bottom.isEmpty() ? 0 : Integer.parseUnsignedInt(bottom);
                    int positionIndex = offset.getAndIncrement();
                    if (!top.isEmpty()) {
                        positionIndex %= Integer.parseUnsignedInt(top) + 1 - low;
                    }
                    return resourceUrl.substring(0, start + 1) + (positionIndex += low) + "]";
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return resourceUrl;
        }
        return resourceUrl + "[" + offset.getAndIncrement() + "]";
    }

    @Override
    @NotNull
    public ImmutableMap<String, TagSnapshot> getAaptDeclaredAttrs() {
        return this.myDeclaredAaptAttrs;
    }

    @Override
    public ResourceNamespace getLayoutNamespace() {
        return this.myLayoutNamespace;
    }

    @NotNull
    private static ImmutableMap<String, TagSnapshot> findDeclaredAaptAttrs(TagSnapshot tag) {
        if (tag == null || !tag.hasDeclaredAaptAttrs) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder<String, TagSnapshot> builder = ImmutableMap.builder();
        tag.attributes.stream().filter(attr -> attr instanceof AaptAttrAttributeSnapshot).map(attr -> (AaptAttrAttributeSnapshot)attr).forEach(attr -> {
            TagSnapshot bundledTag = attr.getBundledTag();
            builder.put(attr.getId(), bundledTag);
            for (TagSnapshot child : bundledTag.children) {
                builder.putAll(LayoutRenderPullParser.findDeclaredAaptAttrs(child));
            }
        });
        for (TagSnapshot child : tag.children) {
            builder.putAll(LayoutRenderPullParser.findDeclaredAaptAttrs(child));
        }
        return builder.build();
    }

    protected final TagSnapshot getCurrentNode() {
        if (!this.myNodeStack.isEmpty()) {
            return this.myNodeStack.get(this.myNodeStack.size() - 1);
        }
        return null;
    }

    protected final TagSnapshot getPreviousNode() {
        if (this.myNodeStack.size() > 1) {
            return this.myNodeStack.get(this.myNodeStack.size() - 2);
        }
        return null;
    }

    protected final AttributeSnapshot getAttribute(int i2) {
        if (this.myParsingState != 2) {
            throw new IndexOutOfBoundsException();
        }
        TagSnapshot uiNode = this.getCurrentNode();
        if (uiNode != null) {
            return uiNode.attributes.get(i2);
        }
        return null;
    }

    protected void push(@NotNull TagSnapshot node) {
        this.myNodeStack.add(node);
    }

    @NotNull
    protected TagSnapshot pop() {
        return this.myNodeStack.remove(this.myNodeStack.size() - 1);
    }

    @Override
    public Object getViewCookie() {
        return this.getCurrentNode();
    }

    @Override
    public String getPositionDescription() {
        return "XML DOM element depth:" + this.myNodeStack.size();
    }

    @Override
    public int getAttributeCount() {
        TagSnapshot node = this.getCurrentNode();
        if (node != null) {
            return node.attributes.size();
        }
        return 0;
    }

    @Override
    public String getAttributeName(int i2) {
        AttributeSnapshot attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.name;
        }
        return null;
    }

    @Override
    public String getAttributeNamespace(int i2) {
        AttributeSnapshot attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.namespace;
        }
        return "";
    }

    @Override
    public String getAttributePrefix(int i2) {
        AttributeSnapshot attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.prefix;
        }
        return null;
    }

    @Override
    public String getAttributeValue(int i2) {
        AttributeSnapshot attribute = this.getAttribute(i2);
        if (attribute != null) {
            return attribute.value;
        }
        return null;
    }

    @Override
    public String getAttributeValue(String namespace, String localName) {
        AttributeSnapshot attribute;
        int n2;
        String vertical;
        TagSnapshot tag = this.getCurrentNode();
        if (tag == null) {
            return null;
        }
        if ("layout".equals(localName) && FragmentTagUtil.isFragmentTag(tag.tagName)) {
            String layout = tag.getAttribute("layout", "http://schemas.android.com/tools");
            if (layout != null) {
                return layout;
            }
            String navGraph = tag.getAttribute("navGraph", "http://schemas.android.com/apk/res-auto");
            if (navGraph != null && this.myNavGraphResolver != null) {
                return this.myNavGraphResolver.resolve(navGraph);
            }
        } else if (this.myUseSrcCompat && "src".equals(localName) && TAGS_SUPPORTING_SRC_COMPAT.contains(tag.tagName)) {
            String srcCompatValue = this.getAttributeValue("http://schemas.android.com/apk/res-auto", "srcCompat");
            if (srcCompatValue != null) {
                return srcCompatValue;
            }
        } else if ("paddingLeft".equals(localName) || "paddingRight".equals(localName)) {
            String horizontal = this.getAttributeValue("http://schemas.android.com/apk/res/android", "paddingHorizontal");
            if (horizontal != null) {
                return horizontal;
            }
        } else if (("paddingTop".equals(localName) || "paddingBottom".equals(localName)) && (vertical = this.getAttributeValue("http://schemas.android.com/apk/res/android", "paddingVertical")) != null) {
            return vertical;
        }
        String value = null;
        if (namespace == null) {
            value = tag.getAttribute(localName);
        } else if (!this.myUseToolsPositionAndVisibility && namespace.equals("http://schemas.android.com/tools")) {
            value = null;
        } else if (namespace.equals("http://schemas.android.com/apk/res/android") || namespace.equals("http://schemas.android.com/apk/res-auto")) {
            if (!this.myHasToolsNamespace || !this.myUseToolsPositionAndVisibility && this.myToolsPositionAndVisibilityAttributes.contains(localName)) {
                value = tag.getAttribute(localName, namespace);
            } else {
                n2 = tag.attributes.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String uri;
                    attribute = tag.attributes.get(i2);
                    if (!localName.equals(attribute.name)) continue;
                    String attrPrefix = attribute.prefix;
                    String string2 = uri = attrPrefix != null ? this.myNamespacePrefixToUri.computeIfAbsent(attrPrefix, prefix -> LayoutRenderPullParser.computeUriFromPrefix(this.myRoot, prefix)) : null;
                    if ("http://schemas.android.com/tools".equals(uri)) {
                        value = attribute.value;
                        if (value != null && value.isEmpty()) {
                            value = tag.getAttribute(localName, "http://schemas.android.com/apk/res/android") != null ? null : value;
                        }
                        break;
                    }
                    if (!namespace.equals(attribute.namespace)) continue;
                    value = attribute.value;
                }
            }
        } else if (!"http://schemas.android.com/tools".equals(namespace)) {
            n2 = tag.attributes.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                attribute = tag.attributes.get(i3);
                if (!localName.equals(attribute.name) || !namespace.equals(attribute.namespace) && !"http://schemas.android.com/apk/res-auto".equals(attribute.namespace)) continue;
                value = attribute.value;
                break;
            }
        } else {
            value = tag.getAttribute(localName, namespace);
        }
        if (value != null) {
            if ("match_parent".equals(value) && ("layout_width".equals(localName) || "layout_height".equals(localName)) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "fill_parent";
            }
            value = value.replaceAll("\\s", " ");
            n2 = value.length();
            for (int i4 = 0; i4 < n2; ++i4) {
                char c2 = value.charAt(i4);
                if (c2 != '&' && c2 != '\\') continue;
                value = ValueXmlHelper.unescapeResourceString(value, true, false);
                break;
            }
        }
        return value;
    }

    @Override
    public int getDepth() {
        return this.myNodeStack.size();
    }

    @Override
    public String getName() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            String name2 = currentNode.tagName;
            String viewHandlerTag = currentNode.getAttribute("useHandler", "http://schemas.android.com/tools");
            if (StringUtil.isNotEmpty(viewHandlerTag)) {
                name2 = viewHandlerTag;
            }
            if (FragmentTagUtil.isFragmentTag(name2)) {
                String navGraph;
                String layout = currentNode.getAttribute("layout", "http://schemas.android.com/tools");
                if (layout == null && (navGraph = currentNode.getAttribute("navGraph", "http://schemas.android.com/apk/res-auto")) != null && this.myNavGraphResolver != null) {
                    layout = this.myNavGraphResolver.resolve(navGraph);
                }
                if (layout != null) {
                    return "include";
                }
                String fragmentId = currentNode.getAttribute("class");
                if ((fragmentId == null || fragmentId.isEmpty()) && ((fragmentId = currentNode.getAttribute("name", "http://schemas.android.com/apk/res/android")) == null || fragmentId.isEmpty())) {
                    fragmentId = currentNode.getAttribute("id", "http://schemas.android.com/apk/res/android");
                }
                this.myLogger.warning("missing.fragment", "Missing fragment association", null, fragmentId);
            } else if (name2.endsWith("Compat") && name2.indexOf(46) == -1) {
                return name2.substring(0, name2.length() - "Compat".length());
            }
            return name2;
        }
        return null;
    }

    @Override
    public String getNamespace() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.namespace;
        }
        return null;
    }

    @Override
    public String getPrefix() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.prefix;
        }
        return null;
    }

    @Override
    public String getNamespace(String prefix) {
        for (int i2 = this.myNodeStack.size() - 1; i2 >= 0; --i2) {
            String uri = this.myNodeStack.get((int)i2).namespaceDeclarations.get(prefix);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }

    @Override
    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.myParsingState == 2) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.children.isEmpty();
        }
        throw new XmlPullParserException("Call to isEmptyElementTag while not in START_TAG", this, null);
    }

    @Override
    protected void onNextFromStartDocument() {
        if (this.myRoot != null) {
            this.push(this.myRoot);
            this.myParsingState = 2;
        } else {
            this.myParsingState = 1;
        }
    }

    @Override
    protected void onNextFromStartTag() {
        TagSnapshot node = this.getCurrentNode();
        assert (node != null);
        List<TagSnapshot> children2 = node.children;
        if (!children2.isEmpty()) {
            this.push(children2.get(0));
            this.myParsingState = 2;
        } else {
            this.myParsingState = this.myParsingState == 0 ? 1 : 3;
        }
    }

    @Override
    protected void onNextFromEndTag() {
        TagSnapshot node = this.getCurrentNode();
        assert (node != null);
        TagSnapshot sibling = node.getNextSibling();
        if (sibling != null) {
            node = sibling;
            this.pop();
            this.push(node);
            this.myParsingState = 2;
        } else {
            this.pop();
            this.myParsingState = this.myNodeStack.isEmpty() ? 1 : 3;
        }
    }

    private static int distanceToLayoutTag(@NotNull RenderXmlTag tag) {
        int distance = 0;
        while ((tag = tag.getParentTag()) != null) {
            String tagName = tag.getName();
            if (!"merge".equals(tagName)) {
                ++distance;
            }
            if (!"layout".equals(tagName)) continue;
            break;
        }
        return tag != null ? distance : -1;
    }

    private static TagSnapshot createSnapshot(@NotNull RenderXmlTag tag, boolean honorMergeParentTag, @NotNull Consumer<TagSnapshot> tagPostProcessor) {
        String rootTag;
        Consumer<TagSnapshot> tagDecorator = TAG_SNAPSHOT_DECORATOR.andThen(tagPostProcessor);
        if (tag.getName().equals("layout")) {
            final String layoutRootName = tag.getContainingFileNameWithoutExtension();
            tagDecorator = tagDecorator.andThen(new Consumer<TagSnapshot>(){
                int counter = 0;

                @Override
                public void accept(TagSnapshot snapshot) {
                    if (snapshot.tag == null) {
                        return;
                    }
                    if (LayoutRenderPullParser.distanceToLayoutTag(snapshot.tag) == 1) {
                        snapshot.setAttribute("tag", "http://schemas.android.com/apk/res/android", "android", "layout/" + layoutRootName + "_" + this.counter++, false);
                    }
                }
            });
        }
        if ((tag = LayoutRenderPullParser.getRootTag(tag)) == null || tag.isEmpty() && tag.getName().isEmpty()) {
            return EMPTY_LAYOUT;
        }
        switch (rootTag = tag.getName()) {
            case "androidx.fragment.app.FragmentContainerView": 
            case "fragment": {
                return LayoutRenderPullParser.createSnapshotForViewFragment(rootTag, tag, tagPostProcessor);
            }
            case "FrameLayout": {
                return LayoutRenderPullParser.createSnapshotForFrameLayout(tag, tagDecorator);
            }
            case "merge": {
                return LayoutRenderPullParser.createSnapshotForMerge(tag, honorMergeParentTag, tagDecorator);
            }
        }
        return TagSnapshot.createTagSnapshot(tag, tagDecorator);
    }

    @NotNull
    private static TagSnapshot createSnapshotForViewFragment(@NotNull String rootTagName, @NotNull RenderXmlTag rootTag, @NotNull Consumer<TagSnapshot> tagPostProcessor) {
        List<RenderXmlAttribute> renderAttributes = rootTag.getAttributes();
        ArrayList<AttributeSnapshot> attributes = Lists.newArrayListWithCapacity(renderAttributes.size());
        for (RenderXmlAttribute renderXmlAttribute : renderAttributes) {
            AttributeSnapshot attribute = AttributeSnapshot.createAttributeSnapshot(renderXmlAttribute);
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        ArrayList<AttributeSnapshot> includeAttributes = Lists.newArrayListWithCapacity(renderAttributes.size());
        for (RenderXmlAttribute renderAttribute : renderAttributes) {
            AttributeSnapshot attribute;
            String localName;
            String name2 = renderAttribute.getName();
            if (name2.startsWith("xmlns:") || (localName = renderAttribute.getLocalName()).startsWith("layout_margin") || localName.startsWith("padding") || localName.equals("id") || (attribute = AttributeSnapshot.createAttributeSnapshot(renderAttribute)) == null) continue;
            includeAttributes.add(attribute);
        }
        TagSnapshot tagSnapshot = TagSnapshot.createSyntheticTag(null, rootTagName, "", "", includeAttributes, Collections.emptyList(), null);
        return TagSnapshot.createSyntheticTag(rootTag, "FrameLayout", "", "", attributes, Collections.singletonList(tagSnapshot), tagPostProcessor);
    }

    @NotNull
    private static TagSnapshot createSnapshotForFrameLayout(@NotNull RenderXmlTag rootTag, @NotNull Consumer<TagSnapshot> tagDecorator) {
        String visibleChild;
        String prefix;
        TagSnapshot root = TagSnapshot.createTagSnapshot(rootTag, tagDecorator);
        String layout = rootTag.getAttributeValue("layout", "http://schemas.android.com/tools");
        if (layout != null && root.children.isEmpty() && (prefix = rootTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android")) != null) {
            ArrayList<TagSnapshot> children2 = new ArrayList<TagSnapshot>();
            root.children = children2;
            ArrayList attributes = Lists.newArrayListWithExpectedSize(3);
            attributes.add(new AttributeSnapshot("", "", "layout", layout));
            attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", prefix, "layout_width", "fill_parent"));
            attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", prefix, "layout_height", "fill_parent"));
            TagSnapshot element = TagSnapshot.createSyntheticTag(null, "include", "", "", attributes, Collections.emptyList(), null);
            children2.add(element);
        }
        if ((visibleChild = rootTag.getAttributeValue("visibleChildren", "http://schemas.android.com/tools")) != null) {
            HashSet<Integer> indices = Sets.newHashSet();
            for (String s2 : Splitter.on(',').trimResults().omitEmptyStrings().split(visibleChild)) {
                try {
                    indices.add(Integer.parseInt(s2));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            String prefix2 = rootTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
            if (prefix2 != null) {
                int n2 = root.children.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    TagSnapshot child = root.children.get(i2);
                    boolean visible = indices.contains(i2);
                    child.setAttribute("visibility", "http://schemas.android.com/apk/res/android", prefix2, visible ? "visible" : "gone");
                }
            }
        }
        return root;
    }

    @NotNull
    private static TagSnapshot createSnapshotForMerge(@NotNull RenderXmlTag rootTag, boolean honorMergeParentTag, @NotNull Consumer<TagSnapshot> tagDecorator) {
        String parentTag;
        TagSnapshot root = TagSnapshot.createTagSnapshot(rootTag, tagDecorator);
        String string2 = parentTag = honorMergeParentTag ? rootTag.getAttributeValue("parentTag", "http://schemas.android.com/tools") : null;
        if (parentTag == null) {
            return root;
        }
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(rootTag);
        LayoutRenderPullParser.addAttributeIfMissing(rootTag, "layout_width", attributes);
        LayoutRenderPullParser.addAttributeIfMissing(rootTag, "layout_height", attributes);
        return TagSnapshot.createSyntheticTag(rootTag, parentTag, "", "", attributes, root.children, null);
    }

    private static void addAttributeIfMissing(@NotNull RenderXmlTag tag, @NotNull String attrName, @NotNull List<AttributeSnapshot> attributes) {
        String value = tag.getAttributeValue(attrName, "http://schemas.android.com/apk/res/android");
        if (value == null) {
            value = tag.getAttributeValue(attrName, "http://schemas.android.com/tools");
        }
        if (value == null) {
            attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android"), attrName, "match_parent"));
        }
    }

    public static RenderXmlTag getRootTag(@NotNull RenderXmlTag tag) {
        if (tag.getName().equals("layout")) {
            for (RenderXmlTag subTag : tag.getSubTags()) {
                String subTagName = subTag.getName();
                if (subTagName.equals("data")) continue;
                return subTag;
            }
            return null;
        }
        return tag;
    }

    public void setUseSrcCompat(boolean useSrcCompat) {
        this.myUseSrcCompat = useSrcCompat;
    }

    static class AttributeFilteredLayoutParser
    extends LayoutRenderPullParser {
        private final RenderTask.AttributeFilter myFilter;

        public AttributeFilteredLayoutParser(@NotNull RenderXmlTag root, @NotNull ILayoutLog logger, RenderTask.AttributeFilter filter2, ResourceRepositoryManager resourceRepositoryManager) {
            super(root, logger, true, null, resourceRepositoryManager);
            this.myFilter = filter2;
        }

        public AttributeFilteredLayoutParser(@NotNull RenderXmlFile file2, @NotNull ILayoutLog logger, RenderTask.AttributeFilter filter2, ResourceRepositoryManager resourceRepositoryManager) {
            super(file2, logger, true, resourceRepositoryManager);
            this.myFilter = filter2;
        }

        @Override
        public String getAttributeValue(String namespace, String localName) {
            String value;
            RenderXmlTag tag;
            TagSnapshot element;
            if (this.myFilter != null && (element = this.getCurrentNode()) != null && (tag = element.tag) != null && (value = ApplicationManager.getApplication().isReadAccessAllowed() ? this.myFilter.getAttribute(tag, namespace, localName) : ApplicationManager.getApplication().runReadAction(() -> this.myFilter.getAttribute(tag, namespace, localName))) != null) {
                if (value.isEmpty()) {
                    return null;
                }
                return value;
            }
            return super.getAttributeValue(namespace, localName);
        }
    }
}

