/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.ide.common.rendering.api.AssetRepository;
import com.android.tools.res.AssetFileOpener;
import com.android.tools.res.FileResourceReader;
import com.android.tools.res.ResourceFiles;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/res/AssetRepositoryBase;", "Lcom/android/ide/common/rendering/api/AssetRepository;", "assetFileOpener", "Lcom/android/tools/res/AssetFileOpener;", "(Lcom/android/tools/res/AssetFileOpener;)V", "isFileResource", "", "path", "", "isSupported", "openAsset", "Ljava/io/InputStream;", "mode", "", "openNonAsset", "cookie", "unnamed"})
public final class AssetRepositoryBase
extends AssetRepository {
    @NotNull
    private final AssetFileOpener assetFileOpener;

    public AssetRepositoryBase(@NotNull AssetFileOpener assetFileOpener) {
        Intrinsics.checkNotNullParameter(assetFileOpener, "assetFileOpener");
        this.assetFileOpener = assetFileOpener;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public boolean isFileResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return ResourceFiles.isResourceFile(path);
    }

    @Override
    @Nullable
    public InputStream openNonAsset(int cookie, @NotNull String path, int mode) {
        Intrinsics.checkNotNullParameter(path, "path");
        if (StringsKt.startsWith$default(path, "apk:", false, 2, null) || StringsKt.startsWith$default(path, "jar:", false, 2, null)) {
            return new ByteArrayInputStream(FileResourceReader.readBytes(path));
        }
        return this.assetFileOpener.openNonAssetFile(path);
    }

    @Override
    @Nullable
    public InputStream openAsset(@NotNull String path, int mode) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.assetFileOpener.openAssetFile(path);
    }
}

