/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.ide.common.resources.ProtoXmlPullParser;
import com.android.ide.common.util.PathString;
import com.android.tools.apk.analyzer.BinaryXmlParser;
import com.android.tools.apk.analyzer.ResourceIdResolver;
import com.android.utils.XmlUtils;
import com.android.zipflinger.ZipMap;
import com.android.zipflinger.ZipRepo;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Shorts;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FileResourceReader {
    private static final String APK_PROTOCOL = "apk";
    private static final LoadingCache<String, ZipMap> sZipCache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(5L, TimeUnit.MINUTES).build(new CacheLoader<String, ZipMap>(){

        @Override
        public ZipMap load(String path) throws IOException {
            return ZipMap.from(Paths.get(path, new String[0]));
        }
    });

    public static byte[] readBytes(PathString resourcePath, ResourceIdResolver resourceIdResolver) throws IOException {
        String scheme;
        switch (scheme = resourcePath.getFilesystemUri().getScheme()) {
            case "file": {
                return FileResourceReader.readFileBytes(resourcePath.getRawPath());
            }
            case "apk": 
            case "jar": {
                String path = resourcePath.getRawPath();
                int separatorPos = path.indexOf("!/");
                int separatorEnd = separatorPos + "!/".length();
                if (separatorPos <= 0 || separatorEnd == path.length()) {
                    throw new IllegalArgumentException("Invalid path in \"" + resourcePath + "\"");
                }
                byte[] rawContent = FileResourceReader.readZipEntryBytes(path.substring(0, separatorPos), path.substring(separatorEnd));
                if (FileResourceReader.isBinaryEncoded(scheme, path, rawContent)) {
                    return BinaryXmlParser.decodeXml(rawContent, resourceIdResolver);
                }
                return rawContent;
            }
        }
        throw new IllegalArgumentException("Unknown schema in \"" + resourcePath + "\"");
    }

    private static boolean isBinaryEncoded(String scheme, String path, byte[] resourceBytes) {
        return scheme.equals(APK_PROTOCOL) && path.endsWith(".xml") && resourceBytes.length > 2 && Shorts.fromBytes(resourceBytes[1], resourceBytes[0]) == Chunk.Type.XML.code();
    }

    public static byte[] readBytes(String resourcePath) throws IOException {
        if (resourcePath.startsWith("apk:") || resourcePath.startsWith("jar:")) {
            int separatorPos;
            int prefixLength = "apk:".length();
            if (resourcePath.startsWith("//", prefixLength)) {
                prefixLength += "//".length();
            }
            if ((separatorPos = resourcePath.lastIndexOf("!/")) < prefixLength) {
                throw new IllegalArgumentException("Invalid resource path \"" + resourcePath + "\"");
            }
            return FileResourceReader.readZipEntryBytes(resourcePath.substring(prefixLength, separatorPos), resourcePath.substring(separatorPos + "!/".length()));
        }
        if (resourcePath.startsWith("file:")) {
            int prefixLength = "file:".length();
            if (resourcePath.startsWith("//", prefixLength)) {
                prefixLength += "//".length();
            }
            resourcePath = resourcePath.substring(prefixLength);
        }
        return FileResourceReader.readFileBytes(resourcePath);
    }

    private static byte[] readFileBytes(String filePath) throws IOException {
        try (FileInputStream fileStream = new FileInputStream(filePath);){
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ByteStreams.copy(fileStream, byteOutputStream);
            byte[] byArray = byteOutputStream.toByteArray();
            return byArray;
        }
    }

    private static byte[] readZipEntryBytes(String zipPath, String zipEntryPath) throws IOException {
        ZipMap zipMap;
        try {
            zipMap = sZipCache.get(zipPath);
        }
        catch (ExecutionException e2) {
            Throwable nested = e2.getCause();
            if (nested instanceof IOException) {
                throw (IOException)nested;
            }
            if (nested instanceof RuntimeException) {
                throw (RuntimeException)nested;
            }
            if (nested instanceof Error) {
                throw (Error)nested;
            }
            throw new UncheckedExecutionException(nested);
        }
        try (ZipRepo zipRepo = new ZipRepo(zipMap);){
            ByteBuffer entryContent = zipRepo.getContent(zipEntryPath);
            byte[] bytes2 = new byte[entryContent.remaining()];
            entryContent.get(bytes2);
            byte[] byArray = bytes2;
            return byArray;
        }
    }

    public static XmlPullParser createXmlPullParser(PathString resourcePath, ResourceIdResolver resIdResolver) throws IOException {
        try {
            byte[] contents = FileResourceReader.readBytes(resourcePath, resIdResolver);
            return FileResourceReader.createXmlPullParser(contents);
        }
        catch (FileNotFoundException e2) {
            return null;
        }
    }

    public static XmlPullParser createXmlPullParser(byte[] contents) {
        try {
            XmlPullParser parser;
            if (XmlUtils.isProtoXml(contents)) {
                parser = new ProtoXmlPullParser();
            } else {
                parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            parser.setInput(new ByteArrayInputStream(contents), null);
            return parser;
        }
        catch (XmlPullParserException e2) {
            throw new Error("Internal error", e2);
        }
    }

    private FileResourceReader() {
    }
}

