/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res;

import com.android.annotations.TestOnly;
import com.android.annotations.concurrency.Slow;
import com.android.resources.aar.CachingData;
import com.android.resources.aar.FrameworkResourceRepository;
import com.android.tools.res.CodeVersionAdapter;
import com.android.tools.res.FrameworkResourceRepositoryManager;
import com.google.common.hash.Hashing;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0017R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/res/FrameworkResourceRepositoryManagerImpl;", "Lcom/android/tools/res/FrameworkResourceRepositoryManager;", "systemCachePath", "", "diskIoExecutor", "Ljava/util/concurrent/Executor;", "(Ljava/lang/String;Ljava/util/concurrent/Executor;)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/tools/res/FrameworkResourceRepositoryManagerImpl$CacheKey;", "Lcom/android/resources/aar/FrameworkResourceRepository;", "clearCache", "", "createCachingData", "Lcom/android/resources/aar/CachingData;", "resFolderOrJar", "Ljava/nio/file/Path;", "getFrameworkResources", "resourceDirectoryOrFile", "useCompiled9Patches", "", "languages", "", "CacheKey", "unnamed"})
public class FrameworkResourceRepositoryManagerImpl
implements FrameworkResourceRepositoryManager {
    @NotNull
    private final String systemCachePath;
    @NotNull
    private final Executor diskIoExecutor;
    @NotNull
    private final ConcurrentHashMap<CacheKey, FrameworkResourceRepository> cache;

    public FrameworkResourceRepositoryManagerImpl(@NotNull String systemCachePath, @NotNull Executor diskIoExecutor) {
        Intrinsics.checkNotNullParameter(systemCachePath, "systemCachePath");
        Intrinsics.checkNotNullParameter(diskIoExecutor, "diskIoExecutor");
        this.systemCachePath = systemCachePath;
        this.diskIoExecutor = diskIoExecutor;
        this.cache = new ConcurrentHashMap();
    }

    public /* synthetic */ FrameworkResourceRepositoryManagerImpl(String string2, Executor executor, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string2 = "";
        }
        this(string2, executor);
    }

    @Override
    @Slow
    @NotNull
    public FrameworkResourceRepository getFrameworkResources(@NotNull Path resourceDirectoryOrFile, boolean useCompiled9Patches, @NotNull Set<String> languages) {
        Intrinsics.checkNotNullParameter(resourceDirectoryOrFile, "resourceDirectoryOrFile");
        Intrinsics.checkNotNullParameter(languages, "languages");
        Path path = resourceDirectoryOrFile;
        CacheKey cacheKey = new CacheKey(path, useCompiled9Patches);
        CachingData cachingData = this.createCachingData(path);
        FrameworkResourceRepository frameworkResourceRepository = this.cache.computeIfAbsent(cacheKey, new Function(path, languages, cachingData, useCompiled9Patches){
            final /* synthetic */ Path $path;
            final /* synthetic */ Set<String> $languages;
            final /* synthetic */ CachingData $cachingData;
            final /* synthetic */ boolean $useCompiled9Patches;
            {
                this.$path = $path;
                this.$languages = $languages;
                this.$cachingData = $cachingData;
                this.$useCompiled9Patches = $useCompiled9Patches;
            }

            @NotNull
            public final FrameworkResourceRepository apply(@NotNull CacheKey it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return FrameworkResourceRepository.create(this.$path, this.$languages, this.$cachingData, this.$useCompiled9Patches);
            }
        });
        Intrinsics.checkNotNullExpressionValue(frameworkResourceRepository, "useCompiled9Patches: Boo\u2026seCompiled9Patches)\n    }");
        FrameworkResourceRepository cached2 = frameworkResourceRepository;
        if (languages.isEmpty()) {
            return cached2;
        }
        FrameworkResourceRepository repository = cached2.loadMissingLanguages(languages, cachingData);
        if (repository != cached2) {
            Map map2 = this.cache;
            Intrinsics.checkNotNullExpressionValue(repository, "repository");
            map2.put(cacheKey, repository);
        }
        Intrinsics.checkNotNullExpressionValue(repository, "repository");
        return repository;
    }

    private final CachingData createCachingData(Path resFolderOrJar) {
        String string2;
        if (StringsKt.endsWith(((Object)resFolderOrJar.getFileName()).toString(), ".jar", true)) {
            return null;
        }
        if (((CharSequence)this.systemCachePath).length() == 0) {
            return null;
        }
        String string3 = CodeVersionAdapter.Companion.getCodeVersion();
        if (string3 == null) {
            return null;
        }
        String codeVersion = string3;
        try {
            string2 = Files.getLastModifiedTime(resFolderOrJar.resolve("../../package.xml"), new LinkOption[0]).toString();
        }
        catch (NoSuchFileException e2) {
            string2 = "";
        }
        String string4 = string2;
        Intrinsics.checkNotNullExpressionValue(string4, "try {\n      Files.getLas\u2026ception) {\n      \"\"\n    }");
        String contentVersion = string4;
        String string5 = Hashing.farmHashFingerprint64().hashUnencodedChars(((Object)resFolderOrJar).toString()).toString();
        Intrinsics.checkNotNullExpressionValue(string5, "farmHashFingerprint64().\u2026ar.toString()).toString()");
        String pathHash = string5;
        Object object = resFolderOrJar.getParent();
        if (object == null || (object = object.getParent()) == null || (object = object.getFileName()) == null || (object = object.toString()) == null) {
            object = "framework";
        }
        Object prefix = object;
        String[] stringArray = "%s_%s.dat";
        Object[] objectArray = new Object[]{prefix, pathHash};
        String string6 = String.format((String)stringArray, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string6, "format(...)");
        String filename = string6;
        stringArray = new String[]{"caches/resources", filename};
        Path cacheFile = Paths.get(this.systemCachePath, stringArray);
        Intrinsics.checkNotNullExpressionValue(cacheFile, "cacheFile");
        return new CachingData(cacheFile, contentVersion, codeVersion, this.diskIoExecutor);
    }

    @TestOnly
    public final void clearCache() {
        this.cache.clear();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/res/FrameworkResourceRepositoryManagerImpl$CacheKey;", "", "path", "Ljava/nio/file/Path;", "useCompiled9Patches", "", "(Ljava/nio/file/Path;Z)V", "getPath", "()Ljava/nio/file/Path;", "getUseCompiled9Patches", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "unnamed"})
    private static final class CacheKey {
        @NotNull
        private final Path path;
        private final boolean useCompiled9Patches;

        public CacheKey(@NotNull Path path, boolean useCompiled9Patches) {
            Intrinsics.checkNotNullParameter(path, "path");
            this.path = path;
            this.useCompiled9Patches = useCompiled9Patches;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public final boolean getUseCompiled9Patches() {
            return this.useCompiled9Patches;
        }

        @NotNull
        public final Path component1() {
            return this.path;
        }

        public final boolean component2() {
            return this.useCompiled9Patches;
        }

        @NotNull
        public final CacheKey copy(@NotNull Path path, boolean useCompiled9Patches) {
            Intrinsics.checkNotNullParameter(path, "path");
            return new CacheKey(path, useCompiled9Patches);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, Path path, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                path = cacheKey.path;
            }
            if ((n2 & 2) != 0) {
                bl2 = cacheKey.useCompiled9Patches;
            }
            return cacheKey.copy(path, bl2);
        }

        @NotNull
        public String toString() {
            return "CacheKey(path=" + this.path + ", useCompiled9Patches=" + this.useCompiled9Patches + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.path).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.useCompiled9Patches);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual(this.path, cacheKey.path)) {
                return false;
            }
            return this.useCompiled9Patches == cacheKey.useCompiled9Patches;
        }
    }
}

