/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res.apk;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.res.apk.ResourceEntryProcessor;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceConfiguration;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceIdentifier;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.PackageChunk;
import com.google.devrel.gmscore.tools.apk.arsc.ResourceTableChunk;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeSpecChunk;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"forEveryResource", "", "apkPath", "", "processor", "Lcom/android/tools/res/apk/ResourceEntryProcessor;", "unnamed"})
@JvmName(name="ApkResourcesIterator")
@SourceDebugExtension(value={"SMAP\nApkResourcesIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApkResourcesIterator.kt\ncom/android/tools/res/apk/ApkResourcesIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,60:1\n1#2:61\n215#3,2:62\n*S KotlinDebug\n*F\n+ 1 ApkResourcesIterator.kt\ncom/android/tools/res/apk/ApkResourcesIterator\n*L\n44#1:62,2\n*E\n"})
public final class ApkResourcesIterator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forEveryResource(@NotNull String apkPath, @NotNull ResourceEntryProcessor processor) {
        Intrinsics.checkNotNullParameter(apkPath, "apkPath");
        Intrinsics.checkNotNullParameter(processor, "processor");
        Closeable closeable = new ZipFile(apkPath);
        Throwable throwable = null;
        try {
            ZipEntry zipEntry;
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl2 = false;
            ZipEntry zipEntry2 = zipEntry = zipFile.getEntry("resources.arsc");
            if (zipEntry2 != null) {
                Intrinsics.checkNotNullExpressionValue(zipEntry2, "zipFile.getEntry(\"resources.arsc\") ?: return@use");
                ZipEntry zipEntry3 = zipEntry;
                BinaryResourceFile resourceFile = BinaryResourceFile.fromInputStream(zipFile.getInputStream(zipEntry3));
                List<Chunk> list2 = resourceFile.getChunks();
                Intrinsics.checkNotNullExpressionValue(list2, "resourceFile.chunks");
                Chunk chunk = CollectionsKt.firstOrNull(list2);
                ResourceTableChunk resourceTableChunk = chunk instanceof ResourceTableChunk ? (ResourceTableChunk)chunk : null;
                if (resourceTableChunk != null) {
                    ResourceTableChunk resourceTable = resourceTableChunk;
                    boolean bl3 = false;
                    StringPoolChunk stringPool = resourceTable.getStringPool();
                    for (PackageChunk pkg : resourceTable.getPackages()) {
                        for (TypeSpecChunk typeSpec : pkg.getTypeSpecChunks()) {
                            Intrinsics.checkNotNull((Object)ResourceType.fromXmlTagName(typeSpec.getTypeName()));
                            for (TypeChunk typeChunk : pkg.getTypeChunks(typeSpec.getId())) {
                                Map<Integer, TypeChunk.Entry> $this$forEach$iv;
                                String string2;
                                BinaryResourceConfiguration binResConfig = typeChunk.getConfiguration();
                                Object it = binResConfig.toString();
                                boolean bl4 = false;
                                switch (((String)it).hashCode()) {
                                    case 1544803905: {
                                        if (((String)it).equals("default")) {
                                            string2 = "";
                                            break;
                                        }
                                    }
                                    default: {
                                        Intrinsics.checkNotNullExpressionValue(it, "it");
                                        string2 = it;
                                    }
                                }
                                String qualifierString = string2;
                                it = FolderConfiguration.getConfigForQualifierString(qualifierString);
                                if (it == null) {
                                    throw new RuntimeException("Unrecognized configuration " + qualifierString);
                                }
                                Object folderConfig = it;
                                Intrinsics.checkNotNullExpressionValue(typeChunk.getEntries(), "typeChunk.entries");
                                boolean $i$f$forEach = false;
                                Iterator<Map.Entry<Integer, TypeChunk.Entry>> iterator2 = $this$forEach$iv.entrySet().iterator();
                                while (iterator2.hasNext()) {
                                    ResourceType resType;
                                    Map.Entry<Integer, TypeChunk.Entry> element$iv;
                                    Map.Entry<Integer, TypeChunk.Entry> entry = element$iv = iterator2.next();
                                    boolean bl5 = false;
                                    Integer rowId = entry.getKey();
                                    TypeChunk.Entry typeChunkEntry = entry.getValue();
                                    int n2 = pkg.getId();
                                    int n3 = typeSpec.getId();
                                    Intrinsics.checkNotNullExpressionValue(rowId, "rowId");
                                    BinaryResourceIdentifier binaryId = BinaryResourceIdentifier.create(n2, n3, rowId);
                                    Intrinsics.checkNotNullExpressionValue(stringPool, "stringPool");
                                    int n4 = binaryId.resourceId();
                                    Intrinsics.checkNotNullExpressionValue(typeChunkEntry, "typeChunkEntry");
                                    processor.onResourceEntry(stringPool, resType, (FolderConfiguration)folderConfig, n4, typeChunkEntry);
                                }
                            }
                        }
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }
}

