/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.res.ids;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.RClassNaming;
import com.android.resources.ResourceType;
import com.android.tools.environment.Logger;
import com.android.tools.log.LogAnonymizer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ResourceClassGenerator {
    private static final Logger LOG = Logger.getInstance(ResourceClassGenerator.class);
    private long myIdGeneratorGeneration = -1L;
    private Map<ResourceType, Object2IntOpenHashMap<String>> myCache;
    private Map<String, IntArrayList> myStyleableCache;
    private final ResourceRepository myResources;
    private final NumericIdProvider myIdProvider;
    private final ResourceNamespace myNamespace;

    private ResourceClassGenerator(NumericIdProvider idProvider, ResourceRepository resources, ResourceNamespace namespace) {
        this.myIdProvider = idProvider;
        this.myResources = resources;
        this.myNamespace = namespace;
    }

    public static ResourceClassGenerator create(NumericIdProvider manager, ResourceRepository resources, ResourceNamespace namespace) {
        return new ResourceClassGenerator(manager, resources, namespace);
    }

    public byte[] generate(String fqcn) {
        String className = fqcn.replace('.', '/');
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("generate(%s)", LogAnonymizer.anonymizeClassName(className)));
        }
        ClassWriter cw = new ClassWriter(0);
        cw.visit(50, 49, className, null, Type.getInternalName(Object.class), null);
        int index2 = className.lastIndexOf(36);
        if (index2 != -1) {
            String typeName = className.substring(index2 + 1);
            ResourceType type = ResourceType.fromClassName(typeName);
            if (type == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("  type '%s' doesn't exist", typeName));
                }
                return null;
            }
            cw.visitInnerClass(className, className.substring(0, index2), typeName, 25);
            long currentIdGeneration = this.myIdProvider.getGeneration();
            if (this.myIdGeneratorGeneration != currentIdGeneration || this.myCache == null) {
                this.myCache = Maps.newHashMap();
                this.myStyleableCache = null;
                this.myIdGeneratorGeneration = currentIdGeneration;
            }
            if (type == ResourceType.STYLEABLE) {
                if (this.myStyleableCache == null) {
                    this.myCache.put(ResourceType.STYLEABLE, new Object2IntOpenHashMap());
                    this.myStyleableCache = Maps.newHashMap();
                    this.generateStyleable(cw, className);
                } else {
                    Object2IntOpenHashMap<String> indexFieldsCache = this.myCache.get((Object)ResourceType.STYLEABLE);
                    assert (indexFieldsCache != null);
                    ResourceClassGenerator.generateFields(cw, indexFieldsCache);
                    this.generateIntArraysFromCache(cw, className);
                }
            } else {
                Object2IntOpenHashMap<String> typeCache = this.myCache.get((Object)type);
                if (typeCache == null) {
                    typeCache = new Object2IntOpenHashMap();
                    this.myCache.put(type, typeCache);
                    this.generateValuesForType(cw, type, typeCache);
                } else {
                    ResourceClassGenerator.generateFields(cw, typeCache);
                }
            }
        } else {
            for (ResourceType t2 : this.myResources.getResourceTypes(this.myNamespace)) {
                if (!t2.getHasInnerClass()) continue;
                cw.visitInnerClass(className + "$" + t2.getName(), className, t2.getName(), 25);
            }
        }
        ResourceClassGenerator.generateConstructor(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateValuesForType(ClassWriter cw, ResourceType resType, Object2IntOpenHashMap<String> cache2) {
        Set<String> resourceNames = this.myResources.getResourceNames(this.myNamespace, resType);
        for (String name2 : resourceNames) {
            int initialValue = this.myIdProvider.getOrGenerateId(new ResourceReference(this.myNamespace, resType, name2));
            name2 = RClassNaming.getFieldNameByResourceName(name2);
            ResourceClassGenerator.generateField(cw, name2, initialValue);
            cache2.put(name2, initialValue);
        }
    }

    private static List<ResourceReference> getStyleableAttributes(ResourceItem item) {
        ResourceValue resourceValue = item.getResourceValue();
        assert (resourceValue instanceof StyleableResourceValue);
        StyleableResourceValue dv = (StyleableResourceValue)resourceValue;
        return Lists.transform(dv.getAllAttributes(), ResourceValue::asReference);
    }

    private void generateStyleable(ClassWriter cw, String className) {
        String fieldName;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("generateStyleable(%s)", LogAnonymizer.anonymizeClassName(className)));
        }
        boolean debug = LOG.isDebugEnabled() && LogAnonymizer.isPublicClass(className);
        Object2IntOpenHashMap<String> indexFieldsCache = this.myCache.get((Object)ResourceType.STYLEABLE);
        Set<String> styleableNames = this.myResources.getResourceNames(this.myNamespace, ResourceType.STYLEABLE);
        ArrayList<MergedStyleable> mergedStyleables = new ArrayList<MergedStyleable>(styleableNames.size());
        for (String styleableName : styleableNames) {
            List<ResourceItem> items = this.myResources.getResources(this.myNamespace, ResourceType.STYLEABLE, styleableName);
            if (items.isEmpty()) {
                if (!debug) continue;
                LOG.debug("  No items for " + styleableName);
                continue;
            }
            fieldName = RClassNaming.getFieldNameByResourceName(styleableName);
            cw.visitField(25, fieldName, "[I", null, null);
            if (debug) {
                LOG.debug("  Defined styleable " + fieldName);
            }
            LinkedHashSet<ResourceReference> mergedAttributes = new LinkedHashSet<ResourceReference>();
            for (ResourceItem resourceItem : items) {
                mergedAttributes.addAll(ResourceClassGenerator.getStyleableAttributes(resourceItem));
            }
            mergedStyleables.add(new MergedStyleable(styleableName, mergedAttributes));
            int idx = 0;
            for (ResourceReference attr : mergedAttributes) {
                String styleableEntryName = this.getResourceName(fieldName, attr);
                int fieldValue = idx++;
                cw.visitField(25, styleableEntryName, "I", null, fieldValue);
                indexFieldsCache.put(styleableEntryName, fieldValue);
                if (!debug) continue;
                LOG.debug("  Defined styleable " + styleableEntryName);
            }
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        for (MergedStyleable mergedStyleable : mergedStyleables) {
            fieldName = RClassNaming.getFieldNameByResourceName(mergedStyleable.name);
            IntArrayList values2 = new IntArrayList();
            for (ResourceReference resourceReference : mergedStyleable.attrs) {
                values2.add(this.myIdProvider.getOrGenerateId(resourceReference));
            }
            this.myStyleableCache.put(fieldName, values2);
            ResourceClassGenerator.generateArrayInitialization(mv, className, fieldName, values2);
        }
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        mv.visitEnd();
    }

    private static void generateFields(ClassWriter cw, Object2IntOpenHashMap<String> values2) {
        values2.forEach((name2, value) -> ResourceClassGenerator.generateField(cw, name2, value));
    }

    private static void generateField(ClassWriter cw, String name2, int value) {
        cw.visitField(25, name2, "I", null, value).visitEnd();
    }

    private void generateIntArraysFromCache(ClassWriter cw, String className) {
        for (String name2 : this.myStyleableCache.keySet()) {
            cw.visitField(25, name2, "[I", null, null);
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        this.myStyleableCache.forEach((arrayName, values2) -> ResourceClassGenerator.generateArrayInitialization(mv, className, arrayName, values2));
        mv.visitInsn(177);
        mv.visitMaxs(4, 0);
        mv.visitEnd();
    }

    private static void pushIntValue(MethodVisitor mv, int value) {
        if (value >= -1 && value <= 5) {
            mv.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            mv.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, value);
        } else {
            mv.visitLdcInsn(value);
        }
    }

    private static void generateArrayInitialization(MethodVisitor mv, String className, String fieldName, IntArrayList values2) {
        if (values2.isEmpty()) {
            return;
        }
        ResourceClassGenerator.pushIntValue(mv, values2.size());
        mv.visitIntInsn(188, 10);
        for (int idx = 0; idx < values2.size(); ++idx) {
            mv.visitInsn(89);
            ResourceClassGenerator.pushIntValue(mv, idx);
            mv.visitLdcInsn(values2.get(idx));
            mv.visitInsn(79);
        }
        mv.visitFieldInsn(179, className, fieldName, "[I");
    }

    private static void generateConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public String getResourceName(String styleableName, ResourceReference value) {
        String packageName;
        StringBuilder sb = new StringBuilder(30);
        sb.append(styleableName);
        sb.append('_');
        if (!value.getNamespace().equals(this.myNamespace) && (packageName = value.getNamespace().getPackageName()) != null) {
            ResourceClassGenerator.appendEscaped(sb, packageName);
            sb.append('_');
        }
        ResourceClassGenerator.appendEscaped(sb, value.getName());
        return sb.toString();
    }

    private static void appendEscaped(StringBuilder sb, String v2) {
        int n2 = v2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = v2.charAt(i2);
            if (c2 == '.' || c2 == ':' || c2 == '-') {
                sb.append('_');
                continue;
            }
            sb.append(c2);
        }
    }

    public static interface NumericIdProvider {
        public long getGeneration();

        public int getOrGenerateId(ResourceReference var1);
    }

    private static class MergedStyleable {
        final String name;
        final LinkedHashSet<ResourceReference> attrs;

        private MergedStyleable(String name2, LinkedHashSet<ResourceReference> attrs) {
            this.name = name2;
            this.attrs = attrs;
        }
    }
}

