/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sdk;

import com.android.annotations.TestOnly;
import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceItemWithVisibility;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.dom.attrs.AttributeDefinitionsImpl;
import com.android.tools.dom.attrs.FilteredAttributeDefinitions;
import com.android.tools.environment.Logger;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLibraryLoader;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.res.FrameworkResourceRepositoryManager;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidSdkData;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.android.tools.sdk.EmbeddedRenderTarget;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AndroidTargetData {
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.android.sdk.AndroidTargetData");
    private final AndroidSdkData mySdkData;
    private final IAndroidTarget myTarget;
    private final Object myAttrDefsLock = new Object();
    private AttributeDefinitions myAttrDefs;
    private LayoutLibrary myLayoutLibrary;
    private volatile MyStaticConstantsData myStaticConstantsData;
    private static final Map<AndroidSdkData, Map<String, SoftReference<AndroidTargetData>>> myTargetDataCache = new WeakHashMap<AndroidSdkData, Map<String, SoftReference<AndroidTargetData>>>();

    @VisibleForTesting
    public AndroidTargetData(AndroidSdkData sdkData, IAndroidTarget target) {
        this.mySdkData = sdkData;
        this.myTarget = target;
    }

    public AttributeDefinitions getPublicAttrDefs() {
        AttributeDefinitions attrDefs = this.getAllAttrDefs();
        return new PublicAttributeDefinitions(attrDefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeDefinitions getAllAttrDefs() {
        Object object = this.myAttrDefsLock;
        synchronized (object) {
            if (this.myAttrDefs == null) {
                String attrsPath = this.myTarget.getPath(8).toString().replace('\\', '/');
                String attrsManifestPath = this.myTarget.getPath(9).toString().replace('\\', '/');
                this.myAttrDefs = AttributeDefinitionsImpl.parseFrameworkFiles(new File(attrsPath), new File(attrsManifestPath));
            }
            return this.myAttrDefs;
        }
    }

    public boolean isResourcePublic(ResourceType type, String name2) {
        ResourceRepository frameworkResources = this.getFrameworkResources(Collections.emptySet());
        if (frameworkResources == null) {
            return false;
        }
        List<ResourceItem> resources = frameworkResources.getResources(ResourceNamespace.ANDROID, type, name2);
        return !resources.isEmpty() && ((ResourceItemWithVisibility)resources.get(0)).getVisibility() == ResourceVisibility.PUBLIC;
    }

    @Slow
    LayoutLibrary getLayoutLibrary(Consumer<LayoutLibrary> register, Supplier<Boolean> hasLayoutlibCrash) throws RenderingException {
        if (this.myLayoutLibrary == null || this.myLayoutLibrary.isDisposed()) {
            IAndroidTarget target;
            AndroidTargetData targetData;
            if (this.myTarget instanceof CompatibilityRenderTarget && (targetData = AndroidTargetData.get(this.mySdkData, target = ((CompatibilityRenderTarget)this.myTarget).getRenderTarget())) != this) {
                this.myLayoutLibrary = targetData.getLayoutLibrary(register, hasLayoutlibCrash);
                return this.myLayoutLibrary;
            }
            if (!(this.myTarget instanceof EmbeddedRenderTarget)) {
                LOG.warn("Rendering will not use the EmbeddedRenderTarget");
            }
            this.myLayoutLibrary = LayoutLibraryLoader.load(this.myTarget, this.getFrameworkEnumValues(), hasLayoutlibCrash);
            register.accept(this.myLayoutLibrary);
        }
        return this.myLayoutLibrary;
    }

    @Slow
    private Map<String, Map<String, Integer>> getFrameworkEnumValues() {
        ResourceRepository resources = this.getFrameworkResources(ImmutableSet.of());
        if (resources == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Integer>> result2 = new HashMap<String, Map<String, Integer>>();
        Collection items = resources.getResources(ResourceNamespace.ANDROID, ResourceType.ATTR).values();
        for (ResourceItem item : items) {
            Map<String, Integer> valueMap;
            ResourceValue attr = item.getResourceValue();
            if (!(attr instanceof AttrResourceValue) || (valueMap = ((AttrResourceValue)attr).getAttributeValues()).isEmpty()) continue;
            result2.put(attr.getName(), valueMap);
        }
        items = resources.getResources(ResourceNamespace.ANDROID, ResourceType.STYLEABLE).values();
        for (ResourceItem item : items) {
            ResourceValue styleable = item.getResourceValue();
            if (!(styleable instanceof StyleableResourceValue)) continue;
            List<AttrResourceValue> attrs = ((StyleableResourceValue)styleable).getAllAttributes();
            for (AttrResourceValue attr : attrs) {
                Map<String, Integer> valueMap = attr.getAttributeValues();
                if (valueMap.isEmpty()) continue;
                result2.put(attr.getName(), valueMap);
            }
        }
        return result2;
    }

    public void clearLayoutBitmapCache(Object moduleKey) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearResourceCaches(moduleKey);
        }
    }

    public void clearFontCache(String path) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearFontCache(path);
        }
    }

    public void clearAllCaches(Object moduleKey) {
        if (this.myLayoutLibrary != null) {
            this.myLayoutLibrary.clearAllCaches(moduleKey);
        }
    }

    public IAndroidTarget getTarget() {
        return this.myTarget;
    }

    public synchronized MyStaticConstantsData getStaticConstantsData() {
        if (this.myStaticConstantsData == null) {
            this.myStaticConstantsData = new MyStaticConstantsData();
        }
        return this.myStaticConstantsData;
    }

    @Slow
    public synchronized ResourceRepository getFrameworkResources(Set<String> languages) {
        Path resFolderOrJar = this.myTarget.getPath(11);
        if (!Files.exists(resFolderOrJar, new LinkOption[0])) {
            LOG.error(String.format("\"%s\" directory or file cannot be found", resFolderOrJar));
            return null;
        }
        return FrameworkResourceRepositoryManager.getInstance().getFrameworkResources(resFolderOrJar, this.myTarget instanceof CompatibilityRenderTarget, languages);
    }

    public static AndroidTargetData getTargetData(IAndroidTarget target, AndroidPlatform platform) {
        return platform != null ? AndroidTargetData.get(platform.getSdkData(), target) : null;
    }

    public static AndroidTargetData get(AndroidSdkData sdk, IAndroidTarget target) {
        AndroidTargetData targetData;
        String key;
        Map targetDataByTarget = myTargetDataCache.computeIfAbsent(sdk, s2 -> Maps.newHashMap());
        SoftReference targetDataRef = (SoftReference)targetDataByTarget.get(key = target.hashString());
        AndroidTargetData androidTargetData = targetData = targetDataRef != null ? (AndroidTargetData)targetDataRef.get() : null;
        if (targetData == null) {
            targetData = new AndroidTargetData(sdk, target);
            targetDataByTarget.put(key, new SoftReference<AndroidTargetData>(targetData));
        }
        return targetData;
    }

    @TestOnly
    public static void clearCache() {
        myTargetDataCache.clear();
    }

    private class PublicAttributeDefinitions
    extends FilteredAttributeDefinitions {
        protected PublicAttributeDefinitions(AttributeDefinitions wrappee) {
            super(wrappee);
        }

        @Override
        protected boolean isAttributeAcceptable(ResourceReference attr) {
            return attr.getNamespace().equals(ResourceNamespace.ANDROID) && !attr.getName().startsWith("__removed") && AndroidTargetData.this.isResourcePublic(ResourceType.ATTR, attr.getName());
        }
    }

    public class MyStaticConstantsData {
        private final Set<String> myActivityActions = this.collectValues(14);
        private final Set<String> myServiceActions = this.collectValues(16);
        private final Set<String> myReceiverActions = this.collectValues(15);
        private final Set<String> myCategories = this.collectValues(17);

        private MyStaticConstantsData() {
        }

        public Set<String> getActivityActions() {
            return this.myActivityActions;
        }

        public Set<String> getServiceActions() {
            return this.myServiceActions;
        }

        public Set<String> getReceiverActions() {
            return this.myReceiverActions;
        }

        public Set<String> getCategories() {
            return this.myCategories;
        }

        private Set<String> collectValues(int pathId) {
            HashSet<String> hashSet;
            block9: {
                BufferedReader reader = Files.newBufferedReader(AndroidTargetData.this.myTarget.getPath(pathId));
                try {
                    String line;
                    HashSet<String> result2 = new HashSet<String>();
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                        result2.add(line);
                    }
                    hashSet = result2;
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e2) {
                        return null;
                    }
                }
                reader.close();
            }
            return hashSet;
        }
    }
}

