/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sdk;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionUtils;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class CompatibilityRenderTarget
implements IAndroidTarget {
    private final int myApiLevel;
    private final IAndroidTarget myDelegate;
    private final AndroidVersion myVersion;
    private final IAndroidTarget myRealTarget;
    private final String myHashString;

    public CompatibilityRenderTarget(IAndroidTarget delegate2, int apiLevel, IAndroidTarget realTarget) {
        this.myDelegate = delegate2;
        this.myApiLevel = apiLevel;
        this.myRealTarget = realTarget;
        this.myVersion = realTarget != null ? realTarget.getVersion() : new AndroidVersion(apiLevel, null);
        this.myHashString = "compat-" + AndroidTargetHash.getPlatformHashString(this.myVersion);
    }

    public static IAndroidTarget copyWithNewDelegate(CompatibilityRenderTarget original, IAndroidTarget newDelegate) {
        return new CompatibilityRenderTarget(newDelegate, original.myApiLevel, original.myRealTarget);
    }

    public IAndroidTarget getRenderTarget() {
        return this.myDelegate;
    }

    public IAndroidTarget getRealTarget() {
        return this.myRealTarget;
    }

    @Override
    public AndroidVersion getVersion() {
        return this.myVersion;
    }

    @Override
    public String getVersionName() {
        return AndroidVersionUtils.getFullApiName(this.myVersion, true, true);
    }

    @Override
    public String hashString() {
        return this.myHashString;
    }

    @Override
    public int compareTo(IAndroidTarget other) {
        int delta = this.myApiLevel - other.getVersion().getApiLevel();
        if (delta != 0) {
            return delta;
        }
        return this.myDelegate.compareTo(other);
    }

    @Override
    public int getRevision() {
        return 1;
    }

    @Override
    public Path getPath(int pathId) {
        return this.myDelegate.getPath(pathId);
    }

    @Override
    public String getLocation() {
        return this.myDelegate.getLocation();
    }

    @Override
    public String getVendor() {
        return this.myDelegate.getVendor();
    }

    @Override
    public String getName() {
        return this.myDelegate.getName();
    }

    @Override
    public String getFullName() {
        return this.myDelegate.getFullName();
    }

    @Override
    public String getClasspathName() {
        return this.myDelegate.getClasspathName();
    }

    @Override
    public String getShortClasspathName() {
        return this.myDelegate.getShortClasspathName();
    }

    @Override
    public boolean isPlatform() {
        return this.myDelegate.isPlatform();
    }

    @Override
    public IAndroidTarget getParent() {
        return this.myDelegate.getParent();
    }

    @Override
    public BuildToolInfo getBuildToolInfo() {
        return this.myDelegate.getBuildToolInfo();
    }

    @Override
    public List<String> getBootClasspath() {
        return this.myDelegate.getBootClasspath();
    }

    @Override
    public boolean hasRenderingLibrary() {
        return this.myDelegate.hasRenderingLibrary();
    }

    @Override
    public List<Path> getSkins() {
        return this.myDelegate.getSkins();
    }

    @Override
    public Path getDefaultSkin() {
        return this.myDelegate.getDefaultSkin();
    }

    @Override
    public List<OptionalLibrary> getOptionalLibraries() {
        return this.myDelegate.getOptionalLibraries();
    }

    @Override
    public List<OptionalLibrary> getAdditionalLibraries() {
        return this.myDelegate.getAdditionalLibraries();
    }

    @Override
    public String[] getPlatformLibraries() {
        return this.myDelegate.getPlatformLibraries();
    }

    @Override
    public String getProperty(String name2) {
        return this.myDelegate.getProperty(name2);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.myDelegate.getProperties();
    }

    @Override
    public boolean canRunOn(IAndroidTarget target) {
        return this.myDelegate.canRunOn(target);
    }
}

