/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sdk;

import com.android.annotations.TestOnly;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class EmbeddedRenderTarget
implements IAndroidTarget {
    private static final String ONLY_FOR_RENDERING_ERROR = "This target is only for rendering";
    private static final String FRAMEWORK_RES_JAR = "framework_res.jar";
    private final String myBasePath;
    private final String myBaseResPath;
    private static EmbeddedRenderTarget ourStudioEmbeddedTarget;

    public static CompatibilityRenderTarget getCompatibilityTarget(IAndroidTarget target, Supplier<String> layoutlibDataPathSupplier, Supplier<String> layoutlibResPathSupplier) {
        int api = target.getVersion().getApiLevel();
        if (target instanceof CompatibilityRenderTarget) {
            CompatibilityRenderTarget compatRenderTarget = (CompatibilityRenderTarget)target;
            target = compatRenderTarget.getRealTarget();
        }
        return new CompatibilityRenderTarget(EmbeddedRenderTarget.getInstance(layoutlibDataPathSupplier, layoutlibResPathSupplier), api, target);
    }

    public static CompatibilityRenderTarget getCompatibilityTarget(IAndroidTarget target, Supplier<String> layoutlibPathSupplier) {
        return EmbeddedRenderTarget.getCompatibilityTarget(target, layoutlibPathSupplier, layoutlibPathSupplier);
    }

    private static EmbeddedRenderTarget getInstance(Supplier<String> layoutlibDataPathSupplier, Supplier<String> layoutlibResPathSupplier) {
        if (ourStudioEmbeddedTarget == null) {
            if (layoutlibDataPathSupplier == layoutlibResPathSupplier) {
                String layoutlibPath = layoutlibDataPathSupplier.get();
                ourStudioEmbeddedTarget = new EmbeddedRenderTarget(layoutlibPath, layoutlibPath);
            } else {
                ourStudioEmbeddedTarget = new EmbeddedRenderTarget(layoutlibDataPathSupplier.get(), layoutlibResPathSupplier.get());
            }
        }
        return ourStudioEmbeddedTarget;
    }

    @TestOnly
    public static void resetRenderTarget() {
        ourStudioEmbeddedTarget = null;
    }

    private EmbeddedRenderTarget(String layoutlibDataPath, String layoutlibResPath) {
        this.myBasePath = layoutlibDataPath;
        this.myBaseResPath = layoutlibResPath;
    }

    @Override
    public String getLocation() {
        Preconditions.checkState(this.myBasePath != null, "Embedded layoutlib not found");
        return this.myBasePath;
    }

    @Override
    public String getVendor() {
        return "Android Open Source Project";
    }

    @Override
    public AndroidVersion getVersion() {
        throw new UnsupportedOperationException("This target can only be used as a CompatibilityRenderTarget delegate");
    }

    @Override
    public String getVersionName() {
        throw new UnsupportedOperationException("This target can only be used as a CompatibilityRenderTarget delegate");
    }

    @Override
    public int getRevision() {
        return 1;
    }

    @Override
    public boolean isPlatform() {
        return true;
    }

    @Override
    public IAndroidTarget getParent() {
        return null;
    }

    @Override
    public Path getPath(int pathId) {
        switch (pathId) {
            case 7: {
                return Paths.get(this.getLocation(), "data");
            }
            case 11: {
                return Paths.get(this.myBaseResPath, "data", FRAMEWORK_RES_JAR);
            }
            case 12: {
                return Paths.get(this.getLocation(), "data", "fonts");
            }
        }
        assert (false) : this.getClass().getSimpleName() + " does not support path of type " + pathId;
        return Paths.get(this.getLocation(), new String[0]);
    }

    @Override
    public BuildToolInfo getBuildToolInfo() {
        return null;
    }

    @Override
    public List<String> getBootClasspath() {
        return ImmutableList.of(this.getPath(1).toString());
    }

    @Override
    public boolean hasRenderingLibrary() {
        return true;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public String getClasspathName() {
        return this.getName();
    }

    @Override
    public String getShortClasspathName() {
        return this.getName();
    }

    @Override
    public List<OptionalLibrary> getOptionalLibraries() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @Override
    public List<OptionalLibrary> getAdditionalLibraries() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @Override
    public List<Path> getSkins() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @Override
    public Path getDefaultSkin() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @Override
    public String[] getPlatformLibraries() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @Override
    public String getProperty(String name2) {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @Override
    public Map<String, String> getProperties() {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @Override
    public boolean canRunOn(IAndroidTarget target) {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }

    @Override
    public String hashString() {
        return "studio-embedded-render-target";
    }

    @Override
    public int compareTo(IAndroidTarget o2) {
        throw new UnsupportedOperationException(ONLY_FOR_RENDERING_ERROR);
    }
}

