/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\t"}, d2={"findGradleBuildFile", "Ljava/io/File;", "dirPath", "findGradleSettingsFile", "isDefaultGradleBuildFile", "", "filePath", "isGradleScript", "isGradleSettingsFile", "common"})
@JvmName(name="BuildScriptUtil")
public final class BuildScriptUtil {
    @NotNull
    public static final File findGradleBuildFile(@NotNull File dirPath) {
        Intrinsics.checkNotNullParameter(dirPath, "dirPath");
        File groovyBuildFile = new File(dirPath, "build.gradle");
        if (groovyBuildFile.isFile()) {
            return groovyBuildFile;
        }
        File kotlinBuildFile = new File(dirPath, "build.gradle.kts");
        if (kotlinBuildFile.isFile()) {
            return kotlinBuildFile;
        }
        File declarativeBuildFile = new File(dirPath, "build.gradle.dcl");
        if (declarativeBuildFile.isFile()) {
            return declarativeBuildFile;
        }
        return groovyBuildFile;
    }

    @NotNull
    public static final File findGradleSettingsFile(@NotNull File dirPath) {
        Intrinsics.checkNotNullParameter(dirPath, "dirPath");
        File groovySettingsFile = new File(dirPath, "settings.gradle");
        if (groovySettingsFile.isFile()) {
            return groovySettingsFile;
        }
        File kotlinSettingsFile = new File(dirPath, "settings.gradle.kts");
        if (kotlinSettingsFile.isFile()) {
            return kotlinSettingsFile;
        }
        File declarativeSettingsFile = new File(dirPath, "settings.gradle.dcl");
        if (declarativeSettingsFile.isFile()) {
            return declarativeSettingsFile;
        }
        return groovySettingsFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGradleScript(@NotNull File filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        if (!filePath.isFile()) return false;
        String string2 = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "filePath.path");
        if (StringsKt.endsWith$default(string2, "gradle", false, 2, null)) return true;
        String string3 = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue(string3, "filePath.path");
        if (StringsKt.endsWith$default(string3, "gradle.kts", false, 2, null)) return true;
        String string4 = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue(string4, "filePath.path");
        if (!StringsKt.endsWith$default(string4, "gradle.dcl", false, 2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDefaultGradleBuildFile(@NotNull File filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        if (!filePath.isFile()) return false;
        String string2 = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "filePath.path");
        if (StringsKt.endsWith$default(string2, "build.gradle", false, 2, null)) {
            if (Intrinsics.areEqual(filePath.getName(), "build.gradle")) return true;
        }
        String string3 = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue(string3, "filePath.path");
        if (StringsKt.endsWith$default(string3, "build.gradle.kts", false, 2, null)) {
            if (Intrinsics.areEqual(filePath.getName(), "build.gradle.kts")) return true;
        }
        String string4 = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue(string4, "filePath.path");
        if (!StringsKt.endsWith$default(string4, "build.gradle.dcl", false, 2, null)) return false;
        if (!Intrinsics.areEqual(filePath.getName(), "build.gradle.dcl")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGradleSettingsFile(@NotNull File filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        if (!filePath.isFile()) return false;
        String string2 = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "filePath.path");
        if (StringsKt.endsWith$default(string2, "settings.gradle", false, 2, null)) {
            if (Intrinsics.areEqual(filePath.getName(), "settings.gradle")) return true;
        }
        String string3 = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue(string3, "filePath.path");
        if (StringsKt.endsWith$default(string3, "settings.gradle.kts", false, 2, null)) {
            if (Intrinsics.areEqual(filePath.getName(), "settings.gradle.kts")) return true;
        }
        String string4 = filePath.getPath();
        Intrinsics.checkNotNullExpressionValue(string4, "filePath.path");
        if (!StringsKt.endsWith$default(string4, "settings.gradle.dcl", false, 2, null)) return false;
        if (!Intrinsics.areEqual(filePath.getName(), "settings.gradle.dcl")) return false;
        return true;
    }
}

