/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.CpuArchitecture;
import com.android.utils.Environment;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0010\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0012"}, d2={"OS_LINUX_PREFIX", "", "OS_MAC_PREFIX", "OS_WIN_PREFIX", "TRANSLATED", "", "jvmArchitecture", "Lcom/android/utils/CpuArchitecture;", "getJvmArchitecture", "()Lcom/android/utils/CpuArchitecture;", "osArchitecture", "getOsArchitecture", "architectureFromString", "cpuArchName", "computeIsRosetta", "", "ensureInitialized", "", "common"})
public final class ComputerArchUtilsKt {
    @NotNull
    private static final String OS_MAC_PREFIX = "mac";
    @NotNull
    private static final String OS_WIN_PREFIX = "win";
    @NotNull
    private static final String OS_LINUX_PREFIX = "linux";
    private static final int TRANSLATED = 1;

    private static final void ensureInitialized() {
        if (!Environment.Companion.getInitialized()) {
            Environment.Companion.initialize$default(Environment.Companion, null, 1, null);
        }
    }

    @NotNull
    public static final CpuArchitecture getJvmArchitecture() {
        ComputerArchUtilsKt.ensureInitialized();
        String arch = Environment.Companion.getInstance().getSystemProperty(Environment.SystemProperty.OS_ARCH);
        return ComputerArchUtilsKt.architectureFromString(arch);
    }

    @NotNull
    public static final CpuArchitecture getOsArchitecture() {
        String string2;
        CpuArchitecture jvmArchitecture;
        block11: {
            block10: {
                jvmArchitecture = ComputerArchUtilsKt.getJvmArchitecture();
                String string3 = Environment.Companion.getInstance().getSystemProperty(Environment.SystemProperty.OS_NAME);
                if (string3 == null) break block10;
                String string4 = string3;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue(locale, "US");
                String string5 = string4.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string5, "toLowerCase(...)");
                string2 = string5;
                if (string2 != null) break block11;
            }
            return jvmArchitecture;
        }
        String os = string2;
        if (jvmArchitecture == CpuArchitecture.X86) {
            if (StringsKt.startsWith$default(os, OS_WIN_PREFIX, false, 2, null)) {
                String w6432 = Environment.Companion.getInstance().getVariable(Environment.EnvironmentVariable.PROCESSOR_ARCHITEW6432);
                if (w6432 != null && StringsKt.contains$default((CharSequence)w6432, "64", false, 2, null)) {
                    return CpuArchitecture.X86_64;
                }
            } else if (StringsKt.startsWith$default(os, OS_LINUX_PREFIX, false, 2, null)) {
                String hostType = Environment.Companion.getInstance().getVariable(Environment.EnvironmentVariable.HOST_TYPE);
                return ComputerArchUtilsKt.architectureFromString(hostType);
            }
        }
        if (jvmArchitecture == CpuArchitecture.X86_64 && StringsKt.startsWith$default(os, OS_MAC_PREFIX, false, 2, null) && Environment.Companion.getInstance().isRosetta()) {
            return CpuArchitecture.X86_ON_ARM;
        }
        return jvmArchitecture;
    }

    private static final boolean computeIsRosetta() {
        Object object;
        Object e22;
        Object e32;
        Field e42;
        Class<?> clazz;
        try {
            Class<?> clazz2 = Class.forName("com.sun.jna.platform.mac.SystemB");
            Class<Object> clazz3 = clazz2 instanceof Class ? clazz2 : null;
            if (clazz3 == null) {
                return false;
            }
            clazz = clazz3;
        }
        catch (ClassNotFoundException e5) {
            return false;
        }
        catch (LinkageError e42) {
            return false;
        }
        Class<?> clazz4 = clazz;
        try {
            e42 = clazz4.getField("INSTANCE");
        }
        catch (NoSuchFieldException e32) {
            return false;
        }
        Field instanceField = e42;
        try {
            e32 = instanceField.get(null);
        }
        catch (IllegalArgumentException e22) {
            return false;
        }
        Object instance2 = e32;
        try {
            e22 = new Class[]{String.class, Pointer.class, IntByReference.class, Pointer.class, Integer.TYPE};
            e22 = clazz4.getMethod("sysctlbyname", (Class<?>)e22);
        }
        catch (NoSuchMethodException e6) {
            return false;
        }
        Object sysctlbyname = e22;
        Memory memory = new Memory(4L);
        IntByReference retSize = new IntByReference(4);
        try {
            object = new Object[]{"sysctl.proc_translated", memory, retSize, null, 0};
            object = ((Method)sysctlbyname).invoke(instance2, object);
        }
        catch (Exception e7) {
            return false;
        }
        Object errorCode = object;
        return Intrinsics.areEqual(errorCode, (Object)0) && memory.getInt(0L) == 1;
    }

    @NotNull
    public static final CpuArchitecture architectureFromString(@Nullable String cpuArchName) {
        CharSequence charSequence = cpuArchName;
        return charSequence == null || charSequence.length() == 0 ? CpuArchitecture.UNKNOWN : (StringsKt.equals(cpuArchName, "x86_64", true) ? CpuArchitecture.X86_64 : (StringsKt.equals(cpuArchName, "ia64", true) ? CpuArchitecture.X86_64 : (StringsKt.equals(cpuArchName, "amd64", true) ? CpuArchitecture.X86_64 : (StringsKt.equals(cpuArchName, "x86", true) ? CpuArchitecture.X86 : (StringsKt.equals(cpuArchName, "aarch64", true) ? CpuArchitecture.ARM : (StringsKt.equals(cpuArchName, "arm64", true) ? CpuArchitecture.ARM : (cpuArchName.length() == 4 && cpuArchName.charAt(0) == 'i' && StringsKt.endsWith$default(cpuArchName, "86", false, 2, null) ? CpuArchitecture.X86 : CpuArchitecture.UNKNOWN)))))));
    }

    public static final /* synthetic */ boolean access$computeIsRosetta() {
        return ComputerArchUtilsKt.computeIsRosetta();
    }
}

