/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.CharSequences;

public class OffsetTrackingDecodedXmlValue {
    private static final char[] DECODED = new char[]{'<', '>', '&', '\'', '\"'};
    private static final String[] ENCODED = new String[]{"&lt;", "&gt;", "&amp;", "&apos;", "&quot;"};
    private final CharSequence myDecodedCharacters;
    private final int[] myOffsetMap;

    public OffsetTrackingDecodedXmlValue(CharSequence encodedValue) {
        StringBuilder decodedValue = null;
        int[] offsetMap = null;
        int escapedLength = encodedValue.length();
        int i2 = 0;
        block0: while (i2 < escapedLength) {
            for (int j2 = 0; j2 < ENCODED.length; ++j2) {
                String toReplace = ENCODED[j2];
                if (i2 + toReplace.length() > escapedLength || !CharSequences.regionMatches(encodedValue, i2, toReplace, 0, toReplace.length())) continue;
                if (decodedValue == null) {
                    decodedValue = new StringBuilder(escapedLength);
                    offsetMap = new int[escapedLength];
                    for (int k2 = 0; k2 < i2; ++k2) {
                        offsetMap[k2] = k2;
                        decodedValue.append(encodedValue.charAt(k2));
                    }
                }
                decodedValue.append(DECODED[j2]);
                offsetMap[decodedValue.length() - 1] = i2 += toReplace.length();
                continue block0;
            }
            if (decodedValue != null) {
                decodedValue.append(encodedValue.charAt(i2));
                offsetMap[decodedValue.length() - 1] = i2;
            }
            ++i2;
        }
        this.myOffsetMap = offsetMap;
        this.myDecodedCharacters = decodedValue == null ? encodedValue : decodedValue.toString();
    }

    public CharSequence getDecodedCharacters() {
        return this.myDecodedCharacters;
    }

    public int getEncodedOffset(int decodedOffset) {
        if (this.myOffsetMap == null || decodedOffset <= 0) {
            return decodedOffset;
        }
        if (decodedOffset <= this.myDecodedCharacters.length()) {
            return this.myOffsetMap[decodedOffset - 1];
        }
        return this.myOffsetMap[this.myDecodedCharacters.length() - 1] + decodedOffset - this.myDecodedCharacters.length();
    }
}

