/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SdkUtils {
    public static final String FILENAME_PREFIX = "From: ";
    public static final List<String> IMAGE_EXTENSIONS = ImmutableList.of(".png", ".9.png", ".gif", ".jpeg", ".jpg", ".bmp", ".webp", ".avif");

    public static boolean endsWithIgnoreCase(String string2, String suffix) {
        return string2.regionMatches(true, string2.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean endsWith(CharSequence sequence, CharSequence suffix) {
        return SdkUtils.endsWith(sequence, sequence.length(), suffix);
    }

    public static boolean endsWith(CharSequence sequence, int endOffset, CharSequence suffix) {
        if (endOffset < suffix.length()) {
            return false;
        }
        int i2 = endOffset - 1;
        for (int j2 = suffix.length() - 1; j2 >= 0; --j2) {
            if (sequence.charAt(i2) != suffix.charAt(j2)) {
                return false;
            }
            --i2;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String string2, String prefix) {
        return string2.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static String wrap(String text, int lineWidth, String hangingIndent) {
        return SdkUtils.wrap(text, lineWidth, lineWidth, hangingIndent);
    }

    public static String wrap(String text, int firstLineWidth, int nextLineWidth, String hangingIndent) {
        return SdkUtils.wrap(text, firstLineWidth, nextLineWidth, hangingIndent, true);
    }

    public static String wrap(String text, int firstLineWidth, int nextLineWidth, String hangingIndent, boolean forceBreak) {
        if (hangingIndent == null) {
            hangingIndent = "";
        }
        int lineWidth = firstLineWidth;
        int explanationLength = text.length();
        StringBuilder sb = new StringBuilder(explanationLength * 2);
        int index2 = 0;
        while (index2 < explanationLength) {
            int next;
            int lineEnd = text.indexOf(10, index2);
            if (lineEnd != -1 && lineEnd - index2 < lineWidth) {
                next = lineEnd + 1;
            } else {
                lineEnd = Math.min(index2 + lineWidth, explanationLength);
                if (lineEnd - index2 < lineWidth) {
                    next = explanationLength;
                } else {
                    int lastSpace = text.lastIndexOf(32, lineEnd);
                    if (lastSpace > index2) {
                        lineEnd = lastSpace;
                        next = lastSpace + 1;
                    } else if (!forceBreak) {
                        for (next = lineEnd; next < explanationLength; ++next) {
                            char c2 = text.charAt(next);
                            if (Character.isWhitespace(c2)) {
                                ++next;
                                break;
                            }
                            ++lineEnd;
                        }
                    }
                }
            }
            if (sb.length() > 0) {
                sb.append(hangingIndent);
            } else {
                lineWidth = nextLineWidth - hangingIndent.length();
            }
            sb.append(text, index2, lineEnd);
            sb.append('\n');
            index2 = next;
        }
        return sb.toString();
    }

    public static File urlToFile(String url) throws MalformedURLException {
        return SdkUtils.urlToFile(new URL(url));
    }

    public static File urlToFile(URL url) throws MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException e2) {
            MalformedURLException ex = new MalformedURLException(e2.getLocalizedMessage());
            ex.initCause(e2);
            throw ex;
        }
        catch (URISyntaxException e3) {
            return new File(url.getPath());
        }
    }

    public static FileLineColumnUrlData parseDecoratedFileUrlString(String string2) {
        Matcher matcher = FileLineColumnUrlData.PATTERN.matcher(string2);
        if (matcher.matches()) {
            Integer line = matcher.group(2) == null ? null : Integer.decode(matcher.group(2));
            Integer column = matcher.group(3) == null ? null : Integer.decode(matcher.group(3));
            return new FileLineColumnUrlData(string2.substring(0, matcher.start(1)), line, column);
        }
        return new FileLineColumnUrlData(string2, null, null);
    }

    public static String fileToUrlString(File file2) throws MalformedURLException {
        String url = SdkUtils.fileToUrl(file2).toExternalForm();
        if (!url.startsWith("file:///")) {
            url = url.replaceFirst("file:/", "file:///");
        }
        return url;
    }

    public static URL fileToUrl(File file2) throws MalformedURLException {
        return file2.toURI().toURL();
    }

    public static String createPathComment(File file2, boolean includePadding) throws MalformedURLException {
        String url = SdkUtils.fileToUrlString(file2);
        int dashes = url.indexOf("--");
        if (dashes != -1) {
            url = url.replace("--", "%2D%2D");
        }
        if (includePadding) {
            return " From: " + url + " ";
        }
        return FILENAME_PREFIX + url;
    }

    public static String xmlNameToConstantName(String xmlName) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, xmlName);
    }

    public static String camelCaseToConstantName(String camelCaseName) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, camelCaseName);
    }

    public static String constantNameToCamelCase(String constantName) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, constantName);
    }

    public static String constantNameToXmlName(String constantName) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, constantName);
    }

    public static String fileNameToResourceName(String fileName) {
        int lastExtension = fileName.lastIndexOf(46);
        if (lastExtension <= 0) {
            return fileName;
        }
        if (fileName.endsWith(".9.png")) {
            if (fileName.length() > ".9.png".length()) {
                return fileName.substring(0, fileName.length() - ".9.png".length());
            }
            return fileName;
        }
        return fileName.substring(0, lastExtension);
    }

    public static String getLayoutName(File layoutFile) {
        String name2 = layoutFile.getName();
        int dotIndex = name2.indexOf(46);
        if (dotIndex != -1) {
            name2 = name2.substring(0, dotIndex);
        }
        return name2;
    }

    public static boolean hasImageExtension(String path) {
        for (String ext : IMAGE_EXTENSIONS) {
            if (!SdkUtils.endsWithIgnoreCase(path, ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBitmapFile(File file2) {
        return SdkUtils.hasImageExtension(file2.getPath());
    }

    public static String escapePropertyValue(String value) {
        Properties properties = new Properties();
        properties.setProperty("k", value);
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, null);
            String s2 = writer.toString();
            int end = s2.length();
            String lineSeparator = System.lineSeparator();
            if (s2.endsWith(lineSeparator)) {
                end -= lineSeparator.length();
            }
            int start = s2.indexOf(61);
            assert (start != -1) : s2;
            return s2.substring(start + 1, end);
        }
        catch (IOException e2) {
            return value;
        }
    }

    public static String globToRegexp(String glob) {
        StringBuilder sb = new StringBuilder(glob.length() * 2);
        int begin = 0;
        sb.append('^');
        int n2 = glob.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = glob.charAt(i2);
            if (c2 == '*') {
                begin = SdkUtils.appendQuoted(sb, glob, begin, i2) + 1;
                if (i2 < n2 - 1 && glob.charAt(i2 + 1) == '*') {
                    ++i2;
                    ++begin;
                }
                sb.append(".*?");
                continue;
            }
            if (c2 != '?') continue;
            begin = SdkUtils.appendQuoted(sb, glob, begin, i2) + 1;
            sb.append(".?");
        }
        SdkUtils.appendQuoted(sb, glob, begin, glob.length());
        sb.append('$');
        return sb.toString();
    }

    private static int appendQuoted(StringBuilder sb, String s2, int from2, int to) {
        if (to > from2) {
            int i2;
            boolean isSimple = true;
            for (i2 = from2; i2 < to; ++i2) {
                char c2 = s2.charAt(i2);
                if (Character.isLetterOrDigit(c2) || c2 == '/' || c2 == ' ') continue;
                isSimple = false;
                break;
            }
            if (isSimple) {
                for (i2 = from2; i2 < to; ++i2) {
                    sb.append(s2.charAt(i2));
                }
                return to;
            }
            sb.append(Pattern.quote(s2.substring(from2, to)));
        }
        return to;
    }

    public static boolean isServiceKey(String name2) {
        switch (name2) {
            case "gcm_defaultSenderId": 
            case "google_app_id": 
            case "google_api_key": 
            case "google_storage_bucket": 
            case "ga_trackingID": 
            case "default_web_client_id": 
            case "firebase_database_url": 
            case "google_crash_reporting_api_key": {
                return true;
            }
        }
        return false;
    }

    public static class FileLineColumnUrlData {
        public static final Pattern PATTERN = Pattern.compile(".*?(:(\\d+)(?::(\\d+))?)$");
        public final String urlString;
        public final Integer line;
        public final Integer column;

        FileLineColumnUrlData(String urlString, Integer line, Integer column) {
            this.urlString = urlString;
            this.line = line;
            this.column = column;
        }
    }
}

