/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.SdkConstants;
import com.android.utils.TokenizedCommandLineKt;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0007J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0007J\u000e\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010%\u001a\u00020\u0007J\u0010\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\u0007J6\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00072\b\b\u0002\u0010+\u001a\u00020\u00052\b\b\u0002\u0010,\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020\u0005J\b\u0010.\u001a\u00020\u0003H\u0016J\u000e\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000301J*\u00102\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00052\b\b\u0002\u0010-\u001a\u00020\u0005H\u0007J\u0010\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0007H\u0002J\u0010\u00105\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u00106\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/utils/TokenizedCommandLine;", "", "commandLine", "", "raw", "", "platform", "", "indexes", "", "(Ljava/lang/String;ZI[I)V", "getCommandLine", "()Ljava/lang/String;", "generation", "getPlatform", "()I", "getRaw", "()Z", "toStringValue", "bothSlash", "c1", "", "c2", "charAt", "i", "(I)Ljava/lang/Character;", "checkGeneration", "", "computeNormalizedCommandLineHashCode", "invalidate", "isEndOfCommand", "isEndOfToken", "isStartOfToken", "nextTokenAfter", "offset", "normalizedCommandLineEquals", "other", "normalizedCommandLineLength", "removeNth", "n", "removeTokenGroup", "token", "extra", "matchPrefix", "returnFirstExtra", "filePathSlashAgnostic", "toString", "separator", "toTokenList", "", "tokenMatches", "tokenStartingAt", "start", "zeroAllocTokenizePOSIX", "zeroAllocTokenizeWindows", "common"})
public final class TokenizedCommandLine {
    @NotNull
    private final String commandLine;
    private final boolean raw;
    private final int platform;
    @NotNull
    private int[] indexes;
    private final int generation;
    @Nullable
    private String toStringValue;

    public TokenizedCommandLine(@NotNull String commandLine, boolean raw, int platform, @NotNull int[] indexes) {
        Intrinsics.checkNotNullParameter(commandLine, "commandLine");
        Intrinsics.checkNotNullParameter(indexes, "indexes");
        this.commandLine = commandLine;
        this.raw = raw;
        this.platform = platform;
        int[] nArray = this.indexes = indexes;
        nArray[0] = nArray[0] + 1;
        this.generation = nArray[0];
        this.checkGeneration();
        if (this.platform == 2) {
            this.zeroAllocTokenizeWindows(this.raw);
        } else {
            this.zeroAllocTokenizePOSIX(this.raw);
        }
    }

    public /* synthetic */ TokenizedCommandLine(String string2, boolean bl2, int n2, int[] nArray, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = SdkConstants.currentPlatform();
        }
        if ((n3 & 8) != 0) {
            nArray = TokenizedCommandLineKt.allocateTokenizeCommandLineBuffer(string2);
        }
        this(string2, bl2, n2, nArray);
    }

    @NotNull
    public final String getCommandLine() {
        return this.commandLine;
    }

    public final boolean getRaw() {
        return this.raw;
    }

    public final int getPlatform() {
        return this.platform;
    }

    @Nullable
    public final String removeTokenGroup(@NotNull String token2, int extra, boolean matchPrefix, boolean returnFirstExtra, boolean filePathSlashAgnostic) {
        Intrinsics.checkNotNullParameter(token2, "token");
        this.checkGeneration();
        this.invalidate();
        int read2 = 1;
        int write2 = 1;
        String firstExtra = null;
        do {
            boolean bl2;
            boolean bl3 = bl2 = read2 >= write2;
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bl2 = this.isStartOfToken(read2);
            if (_Assertions.ENABLED && !bl2) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            bl2 = this.isStartOfToken(write2);
            if (_Assertions.ENABLED && !bl2) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            if (this.tokenMatches(token2, read2, matchPrefix, filePathSlashAgnostic)) {
                if (returnFirstExtra) {
                    firstExtra = matchPrefix ? this.tokenStartingAt(read2 + token2.length()) : this.tokenStartingAt(this.nextTokenAfter(read2));
                }
                for (int count2 = 0; count2 != extra + 1 && !this.isEndOfCommand(read2); ++count2) {
                    read2 = this.nextTokenAfter(read2);
                }
            } else {
                if (this.isEndOfCommand(read2) || this.isEndOfCommand(write2)) continue;
                do {
                    this.indexes[write2++] = this.indexes[read2++];
                } while (!this.isEndOfToken(read2 - 1));
            }
        } while (!this.isEndOfCommand(read2));
        this.indexes[write2] = Integer.MIN_VALUE;
        return firstExtra;
    }

    public static /* synthetic */ String removeTokenGroup$default(TokenizedCommandLine tokenizedCommandLine, String string2, int n2, boolean bl2, boolean bl3, boolean bl4, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl2 = false;
        }
        if ((n3 & 8) != 0) {
            bl3 = false;
        }
        if ((n3 & 0x10) != 0) {
            bl4 = false;
        }
        return tokenizedCommandLine.removeTokenGroup(string2, n2, bl2, bl3, bl4);
    }

    private final String tokenStartingAt(int start) {
        this.checkGeneration();
        StringBuilder token2 = new StringBuilder();
        int n2 = this.indexes.length;
        block4: for (int read2 = start; read2 < n2; ++read2) {
            int offset = this.indexes[read2];
            switch (offset) {
                case -2147483648: {
                    break block4;
                }
                case 0x7FFFFFFF: {
                    break block4;
                }
                default: {
                    token2.append(this.commandLine.charAt(offset));
                    continue block4;
                }
            }
        }
        return ((Object)StringsKt.trim(token2)).toString();
    }

    @Nullable
    public final String removeNth(int n2) {
        this.checkGeneration();
        this.invalidate();
        StringBuilder token2 = new StringBuilder();
        int tokenNumber = 0;
        int write2 = 1;
        int n3 = this.indexes.length;
        block4: for (int read2 = 1; read2 < n3; ++read2) {
            if (tokenNumber != n2) {
                this.indexes[write2++] = this.indexes[read2];
            }
            int offset = this.indexes[read2];
            switch (offset) {
                case -2147483648: {
                    if (((CharSequence)token2).length() == 0) {
                        return null;
                    }
                    return token2.toString();
                }
                case 0x7FFFFFFF: {
                    ++tokenNumber;
                    continue block4;
                }
                default: {
                    if (tokenNumber != n2) continue block4;
                    token2.append(this.commandLine.charAt(offset));
                }
            }
        }
        return null;
    }

    @NotNull
    public final List<String> toTokenList() {
        this.checkGeneration();
        List result2 = new ArrayList();
        StringBuilder token2 = new StringBuilder();
        int i2 = 1;
        while (!this.isEndOfCommand(i2)) {
            Character c2 = this.charAt(i2);
            if (c2 == null) {
                if (((CharSequence)token2).length() > 0) {
                    String string2 = token2.toString();
                    Intrinsics.checkNotNullExpressionValue(string2, "token.toString()");
                    result2.add(string2);
                    token2.setLength(0);
                }
            } else {
                token2.append(c2.charValue());
            }
            ++i2;
        }
        return result2;
    }

    private final TokenizedCommandLine zeroAllocTokenizeWindows(boolean raw) {
        int n2;
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        int i2 = 0;
        int length = this.commandLine.length();
        Character c2 = null;
        int offset = 0;
        offset = 1;
        while (i2 < length && Character.isWhitespace(this.commandLine.charAt(i2))) {
            n2 = i2;
            i2 = n2 + 1;
        }
        block1: while (i2 < length) {
            c2 = Character.valueOf(this.commandLine.charAt(i2));
            n2 = 34;
            if (c2.charValue() == n2) {
                if (raw) {
                    n2 = offset;
                    offset = n2 + 1;
                    this.indexes[n2] = i2;
                }
                quoting = !quoting;
                ++i2;
                continue;
            }
            n2 = 92;
            if (c2.charValue() == n2) {
                boolean quote;
                int forward = i2 + 1;
                int slashCount = 1;
                c2 = StringsKt.getOrNull(this.commandLine, forward);
                while (true) {
                    Character c3 = c2;
                    char c4 = '\\';
                    if (c3 == null || c3.charValue() != c4) break;
                    ++slashCount;
                    c2 = StringsKt.getOrNull(this.commandLine, ++forward);
                }
                boolean odd = slashCount % 2 == 1;
                Character c5 = c2;
                int n3 = 34;
                boolean bl2 = quote = c5 != null && c5.charValue() == n3;
                if (!raw && quote) {
                    slashCount /= 2;
                }
                n3 = 0;
                while (n3 < slashCount) {
                    int j2 = n3++;
                    boolean bl3 = false;
                    int n4 = offset;
                    offset = n4 + 1;
                    this.indexes[n4] = i2 + j2;
                }
                if (odd && quote) {
                    n3 = offset;
                    offset = n3 + 1;
                    this.indexes[n3] = forward++;
                }
                i2 = forward;
                continue;
            }
            if (!quoting) {
                n2 = 94;
                if (c2.charValue() == n2) {
                    c2 = StringsKt.getOrNull(this.commandLine, ++i2);
                    if (raw || c2 == null) {
                        n2 = offset;
                        offset = n2 + 1;
                        this.indexes[n2] = i2 - 1;
                    }
                    Character c6 = c2;
                    n2 = 94;
                    if (c6 != null && c6.charValue() == n2) {
                        n2 = offset;
                        offset = n2 + 1;
                        int n5 = n2;
                        n2 = i2;
                        i2 = n2 + 1;
                        this.indexes[n5] = n2;
                    }
                    while (true) {
                        Character c7 = c2;
                        n2 = 13;
                        if (c7 == null || c7.charValue() != n2) {
                            Character c8 = c2;
                            n2 = 10;
                            if (c8 == null || c8.charValue() != n2) continue block1;
                        }
                        c2 = StringsKt.getOrNull(this.commandLine, ++i2);
                    }
                }
            }
            if (!quoting && Character.isWhitespace(c2.charValue())) {
                n2 = offset;
                offset = n2 + 1;
                this.indexes[n2] = Integer.MAX_VALUE;
                c2 = StringsKt.getOrNull(this.commandLine, ++i2);
                while (c2 != null && Character.isWhitespace(c2.charValue())) {
                    c2 = StringsKt.getOrNull(this.commandLine, ++i2);
                }
                continue;
            }
            n2 = offset;
            offset = n2 + 1;
            int n6 = n2;
            n2 = i2;
            i2 = n2 + 1;
            this.indexes[n6] = n2;
        }
        if (!this.isEndOfToken(offset - 1)) {
            n2 = offset;
            offset = n2 + 1;
            this.indexes[n2] = Integer.MAX_VALUE;
        }
        n2 = offset;
        offset = n2 + 1;
        this.indexes[n2] = Integer.MIN_VALUE;
        return this;
    }

    private final TokenizedCommandLine zeroAllocTokenizePOSIX(boolean raw) {
        this.checkGeneration();
        this.invalidate();
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        boolean skipping = true;
        int i2 = 0;
        char c2 = '\u0000';
        int length = this.commandLine.length();
        int offset = 1;
        while (i2 < length) {
            c2 = this.commandLine.charAt(i2++);
            if (skipping) {
                if (Character.isWhitespace(c2)) continue;
                skipping = false;
            }
            if ((quoting || !Character.isWhitespace(c2)) && raw) {
                this.indexes[offset++] = i2 - 1;
            }
            if (escaping) {
                escaping = false;
                if (c2 == '\n' || raw) continue;
                this.indexes[offset++] = i2 - 1;
                continue;
            }
            if (!(c2 != '\\' || quoting && quote != '\"')) {
                escaping = true;
                continue;
            }
            if (!(quoting || c2 != '\"' && c2 != '\'')) {
                quoting = true;
                quote = c2;
                continue;
            }
            if (quoting && c2 == quote) {
                quoting = false;
                quote = '\u0000';
                continue;
            }
            if (!quoting && Character.isWhitespace(c2)) {
                skipping = true;
                this.indexes[offset++] = Integer.MAX_VALUE;
                continue;
            }
            if (raw) continue;
            this.indexes[offset++] = i2 - 1;
        }
        if (!this.isEndOfToken(offset - 1)) {
            this.indexes[offset++] = Integer.MAX_VALUE;
        }
        this.indexes[offset] = Integer.MIN_VALUE;
        return this;
    }

    @VisibleForTesting
    public final boolean tokenMatches(@NotNull String token2, int offset, boolean matchPrefix, boolean filePathSlashAgnostic) {
        Intrinsics.checkNotNullParameter(token2, "token");
        this.checkGeneration();
        int i2 = 0;
        int index2 = this.indexes[offset];
        while (index2 != Integer.MIN_VALUE) {
            char c2;
            boolean endOfToken;
            boolean bl2 = endOfToken = index2 == Integer.MAX_VALUE;
            if (i2 == token2.length()) {
                return endOfToken || matchPrefix;
            }
            if (endOfToken) {
                return false;
            }
            char c1 = token2.charAt(i2);
            if (!(c1 == (c2 = this.commandLine.charAt(index2)) || filePathSlashAgnostic && this.bothSlash(c1, c2))) {
                return false;
            }
            index2 = this.indexes[offset + ++i2];
        }
        return false;
    }

    public static /* synthetic */ boolean tokenMatches$default(TokenizedCommandLine tokenizedCommandLine, String string2, int n2, boolean bl2, boolean bl3, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl3 = false;
        }
        return tokenizedCommandLine.tokenMatches(string2, n2, bl2, bl3);
    }

    private final boolean bothSlash(char c1, char c2) {
        if (c1 != '\\' && c1 != '/') {
            return false;
        }
        return c2 == '\\' || c2 == '/';
    }

    @VisibleForTesting
    public final int nextTokenAfter(int offset) {
        this.checkGeneration();
        int result2 = offset;
        while (!this.isEndOfToken(result2) && !this.isEndOfCommand(result2)) {
            ++result2;
        }
        return result2 + 1;
    }

    private final boolean isEndOfToken(int i2) {
        return i2 < this.indexes.length && this.indexes[i2] == Integer.MAX_VALUE;
    }

    private final boolean isEndOfCommand(int i2) {
        return i2 >= this.indexes.length || this.indexes[i2] == Integer.MIN_VALUE;
    }

    private final boolean isStartOfToken(int i2) {
        return i2 == 1 || this.isEndOfToken(i2 - 1);
    }

    private final Character charAt(int i2) {
        return this.isEndOfToken(i2) ? null : Character.valueOf(this.commandLine.charAt(this.indexes[i2]));
    }

    public final int normalizedCommandLineLength() {
        int n2;
        if (this.isEndOfCommand(1)) {
            n2 = 0;
        } else {
            int i2 = 1;
            while (!this.isEndOfCommand(i2 + 1)) {
                ++i2;
            }
            n2 = i2 - 1;
        }
        return n2;
    }

    public final int computeNormalizedCommandLineHashCode() {
        this.checkGeneration();
        long hash = 1469598103934665603L;
        int i2 = 1;
        while (!this.isEndOfCommand(i2) && !this.isEndOfCommand(i2 + 1)) {
            Character c2 = this.charAt(i2);
            hash ^= (long)(c2 != null ? c2.charValue() : 32);
            hash *= 1099511628211L;
            ++i2;
        }
        return (int)hash;
    }

    public final boolean normalizedCommandLineEquals(@NotNull String other) {
        Intrinsics.checkNotNullParameter(other, "other");
        int length1 = this.normalizedCommandLineLength();
        int length2 = other.length();
        if (length1 == 0 && length2 == 0) {
            return true;
        }
        if (length1 != length2) {
            return false;
        }
        for (int i2 = 1; i2 < length1; ++i2) {
            Character c2 = this.charAt(i2);
            if ((c2 != null ? c2.charValue() : (char)' ') == other.charAt(i2 - 1)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final String toString(@NotNull String separator) {
        Intrinsics.checkNotNullParameter(separator, "separator");
        this.checkGeneration();
        int i2 = 1;
        if (this.isEndOfCommand(i2)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (!this.isEndOfCommand(i2 + 1)) {
            Object object = this.charAt(i2);
            if (object == null) {
                object = separator;
            }
            sb.append(object);
            ++i2;
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return string2;
    }

    @NotNull
    public String toString() {
        if (this.toStringValue != null) {
            String string2 = this.toStringValue;
            Intrinsics.checkNotNull(string2);
            return string2;
        }
        String string3 = this.toStringValue = this.toString(" ");
        Intrinsics.checkNotNull(string3);
        return string3;
    }

    private final void invalidate() {
        this.toStringValue = null;
    }

    private final void checkGeneration() {
        if (this.generation != Math.abs(this.indexes[0])) {
            throw new Exception("Buffer indexes was shared with another TokenizedCommandLine after this one");
        }
    }
}

