/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Compressor;
import com.android.zipflinger.Crc32;
import com.android.zipflinger.NoCopyByteArrayOutputStream;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;

public class BytesSource
extends Source {
    private ByteBuffer zipEntryPayload;

    protected BytesSource(String name2) {
        super(name2);
    }

    public BytesSource(byte[] bytes2, String name2, int compressionLevel) throws IOException {
        super(name2);
        this.build(bytes2, bytes2.length, compressionLevel);
    }

    public BytesSource(Path file2, String name2, int compressionLevel) throws IOException {
        super(name2);
        byte[] bytes2 = Files.readAllBytes(file2);
        this.build(bytes2, bytes2.length, compressionLevel);
    }

    @Deprecated
    public BytesSource(File file2, String name2, int compressionLevel) throws IOException {
        this(file2.toPath(), name2, compressionLevel);
    }

    public BytesSource(InputStream stream, String name2, int compressionLevel) throws IOException {
        super(name2);
        try (NoCopyByteArrayOutputStream ncbos = new NoCopyByteArrayOutputStream(16000);){
            int bytesRead;
            byte[] tmpBuffer = new byte[16000];
            while ((bytesRead = stream.read(tmpBuffer)) != -1) {
                ncbos.write(tmpBuffer, 0, bytesRead);
            }
            stream.close();
            this.build(ncbos.buf(), ncbos.getCount(), compressionLevel);
        }
    }

    protected void build(byte[] bytes2, int size, int compressionLevel) throws IOException {
        this.crc = Crc32.crc32(bytes2, 0, size);
        this.uncompressedSize = size;
        if (compressionLevel == 0) {
            this.zipEntryPayload = ByteBuffer.wrap(bytes2, 0, size);
            this.compressedSize = this.uncompressedSize;
            this.compressionFlag = 0;
        } else {
            this.zipEntryPayload = Compressor.deflate(bytes2, 0, size, compressionLevel);
            this.compressedSize = this.zipEntryPayload.limit();
            this.compressionFlag = (short)8;
        }
    }

    @Override
    public void prepare() {
    }

    @Override
    public long writeTo(ZipWriter writer) throws IOException {
        return writer.write(this.zipEntryPayload);
    }
}

