/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Ints;
import com.android.zipflinger.Location;
import com.android.zipflinger.Zip64;
import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

class EndOfCentralDirectory {
    private static final int SIGNATURE = 101010256;
    static final int SIZE = 22;
    private static final long MAX_SIZE = 65557L;
    static final short DISK_NUMBER = 0;
    private int numEntries = 0;
    private Location location;
    private Location cdLocation;
    private byte[] comment = new byte[0];

    private EndOfCentralDirectory() {
        this.location = Location.INVALID;
        this.cdLocation = Location.INVALID;
    }

    private void parse(ByteBuffer buffer) {
        buffer.position(buffer.position() + 6);
        this.numEntries = Ints.ushortToInt(buffer.getShort());
        long cdSize = Ints.uintToLong(buffer.getInt());
        long cdOffset = Ints.uintToLong(buffer.getInt());
        this.cdLocation = new Location(cdOffset, cdSize);
        int commentLength = Ints.ushortToInt(buffer.getShort());
        if (buffer.remaining() < commentLength) {
            long remaining = buffer.remaining();
            String msg = "Declared comment size (" + commentLength + ") bigger than remaining bytes (" + remaining + ")";
            throw new IllegalStateException(msg);
        }
        this.comment = new byte[commentLength];
        buffer.get(this.comment);
    }

    public Location getLocation() {
        return this.location;
    }

    public Location getCdLocation() {
        return this.cdLocation;
    }

    byte[] getComment() {
        return this.comment;
    }

    public int numEntries() {
        return this.numEntries;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public static EndOfCentralDirectory find(FileChannel channel) throws IOException {
        long fileSize = channel.size();
        EndOfCentralDirectory eocd = new EndOfCentralDirectory();
        if (fileSize < 22L) {
            return eocd;
        }
        int sizeToRead = Math.toIntExact(Math.min(fileSize, 65557L));
        long offset = fileSize - (long)sizeToRead;
        ByteBuffer buffer = ByteBuffer.allocate(sizeToRead).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(buffer, offset);
        buffer.position(buffer.capacity() - 22);
        while (true) {
            int signature;
            if ((signature = buffer.getInt()) == 101010256) {
                eocd.parse(buffer);
                eocd.setLocation(new Location(offset + (long)buffer.position() - 22L, 22L));
                break;
            }
            if (buffer.position() <= 4) break;
            buffer.position(buffer.position() - 4 - 1);
        }
        return eocd;
    }

    public static Location write(ZipWriter writer, Location cdLocation, long entriesCount, byte[] comment) throws IOException {
        int eocdOffset;
        boolean isZip64 = Zip64.needZip64Footer(entriesCount, cdLocation);
        short numEntries = isZip64 ? (short)-1 : (short)Ints.longToUshort(entriesCount);
        int eocdSize = isZip64 ? -1 : Ints.longToUint(cdLocation.size());
        int n2 = eocdOffset = isZip64 ? -1 : Ints.longToUint(cdLocation.first);
        if ((long)comment.length > 65535L) {
            String msg = "Comment too big (" + comment.length + ") max= 65535";
            throw new IllegalStateException(msg);
        }
        int totalSize = 22 + comment.length;
        ByteBuffer eocd = ByteBuffer.allocate(totalSize).order(ByteOrder.LITTLE_ENDIAN);
        eocd.putInt(101010256);
        eocd.putShort((short)0);
        eocd.putShort((short)0);
        eocd.putShort(numEntries);
        eocd.putShort(numEntries);
        eocd.putInt(eocdSize);
        eocd.putInt(eocdOffset);
        eocd.putShort(Ints.longToUshort(comment.length));
        eocd.put(comment);
        eocd.rewind();
        long position = writer.position();
        writer.write(eocd);
        return new Location(position, 22L);
    }
}

