/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.unsafe;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.io.ByteBufferInput;
import com.esotericsoftware.kryo.kryo5.unsafe.UnsafeUtil;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;

public class UnsafeByteBufferInput
extends ByteBufferInput {
    private long bufferAddress;

    public UnsafeByteBufferInput() {
    }

    public UnsafeByteBufferInput(int bufferSize) {
        super(bufferSize);
        this.updateBufferAddress();
    }

    public UnsafeByteBufferInput(byte[] bytes2) {
        super(bytes2);
        this.updateBufferAddress();
    }

    public UnsafeByteBufferInput(byte[] bytes2, int offset, int count2) {
        super(bytes2, offset, count2);
        this.updateBufferAddress();
    }

    public UnsafeByteBufferInput(ByteBuffer buffer) {
        super(buffer);
        this.updateBufferAddress();
    }

    public UnsafeByteBufferInput(long address, int size) {
        super(UnsafeUtil.newDirectBuffer(address, size));
        this.updateBufferAddress();
    }

    public UnsafeByteBufferInput(InputStream inputStream) {
        super(inputStream);
        this.updateBufferAddress();
    }

    public UnsafeByteBufferInput(InputStream inputStream, int bufferSize) {
        super(inputStream, bufferSize);
        this.updateBufferAddress();
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        if (!(buffer instanceof DirectBuffer)) {
            throw new IllegalArgumentException("buffer must be direct.");
        }
        if (buffer != this.byteBuffer) {
            UnsafeUtil.dispose(this.byteBuffer);
        }
        super.setBuffer(buffer);
        this.updateBufferAddress();
    }

    private void updateBufferAddress() {
        this.bufferAddress = ((DirectBuffer)((Object)this.byteBuffer)).address();
    }

    private void setBufferPosition(Buffer buffer, int position) {
        buffer.position(position);
    }

    @Override
    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        int result2 = UnsafeUtil.unsafe.getByte(this.bufferAddress + (long)this.position++) & 0xFF;
        this.setBufferPosition(this.byteBuffer, this.position);
        return result2;
    }

    @Override
    public byte readByte() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        byte result2 = UnsafeUtil.unsafe.getByte(this.bufferAddress + (long)this.position++);
        this.setBufferPosition(this.byteBuffer, this.position);
        return result2;
    }

    @Override
    public int readByteUnsigned() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        int result2 = UnsafeUtil.unsafe.getByte(this.bufferAddress + (long)this.position++) & 0xFF;
        this.setBufferPosition(this.byteBuffer, this.position);
        return result2;
    }

    @Override
    public int readInt() throws KryoException {
        this.require(4);
        int result2 = UnsafeUtil.unsafe.getInt(this.bufferAddress + (long)this.position);
        this.position += 4;
        this.setBufferPosition(this.byteBuffer, this.position);
        return result2;
    }

    @Override
    public long readLong() throws KryoException {
        this.require(8);
        long result2 = UnsafeUtil.unsafe.getLong(this.bufferAddress + (long)this.position);
        this.position += 8;
        this.setBufferPosition(this.byteBuffer, this.position);
        return result2;
    }

    @Override
    public float readFloat() throws KryoException {
        this.require(4);
        float result2 = UnsafeUtil.unsafe.getFloat(this.bufferAddress + (long)this.position);
        this.position += 4;
        this.setBufferPosition(this.byteBuffer, this.position);
        return result2;
    }

    @Override
    public double readDouble() throws KryoException {
        this.require(8);
        double result2 = UnsafeUtil.unsafe.getDouble(this.bufferAddress + (long)this.position);
        this.position += 8;
        this.setBufferPosition(this.byteBuffer, this.position);
        return result2;
    }

    @Override
    public short readShort() throws KryoException {
        this.require(2);
        short result2 = UnsafeUtil.unsafe.getShort(this.bufferAddress + (long)this.position);
        this.position += 2;
        this.setBufferPosition(this.byteBuffer, this.position);
        return result2;
    }

    @Override
    public char readChar() throws KryoException {
        this.require(2);
        char result2 = UnsafeUtil.unsafe.getChar(this.bufferAddress + (long)this.position);
        this.position += 2;
        this.setBufferPosition(this.byteBuffer, this.position);
        return result2;
    }

    @Override
    public boolean readBoolean() throws KryoException {
        if (this.position == this.limit) {
            this.require(1);
        }
        boolean result2 = UnsafeUtil.unsafe.getByte(this.bufferAddress + (long)this.position++) != 0;
        this.setBufferPosition(this.byteBuffer, this.position);
        return result2;
    }

    @Override
    public int[] readInts(int length) throws KryoException {
        int[] array2 = new int[length];
        this.readBytes(array2, UnsafeUtil.intArrayBaseOffset, length << 2);
        return array2;
    }

    @Override
    public long[] readLongs(int length) throws KryoException {
        long[] array2 = new long[length];
        this.readBytes(array2, UnsafeUtil.longArrayBaseOffset, length << 3);
        return array2;
    }

    @Override
    public float[] readFloats(int length) throws KryoException {
        float[] array2 = new float[length];
        this.readBytes(array2, UnsafeUtil.floatArrayBaseOffset, length << 2);
        return array2;
    }

    @Override
    public double[] readDoubles(int length) throws KryoException {
        double[] array2 = new double[length];
        this.readBytes(array2, UnsafeUtil.doubleArrayBaseOffset, length << 3);
        return array2;
    }

    @Override
    public short[] readShorts(int length) throws KryoException {
        short[] array2 = new short[length];
        this.readBytes(array2, UnsafeUtil.shortArrayBaseOffset, length << 1);
        return array2;
    }

    @Override
    public char[] readChars(int length) throws KryoException {
        char[] array2 = new char[length];
        this.readBytes(array2, UnsafeUtil.charArrayBaseOffset, length << 1);
        return array2;
    }

    @Override
    public boolean[] readBooleans(int length) throws KryoException {
        boolean[] array2 = new boolean[length];
        this.readBytes(array2, UnsafeUtil.booleanArrayBaseOffset, length);
        return array2;
    }

    @Override
    public void readBytes(byte[] bytes2, int offset, int count2) throws KryoException {
        this.readBytes((Object)bytes2, UnsafeUtil.byteArrayBaseOffset + (long)offset, count2);
    }

    public void readBytes(Object to, long offset, int count2) throws KryoException {
        int copyCount = Math.min(this.limit - this.position, count2);
        while (true) {
            UnsafeUtil.unsafe.copyMemory(null, this.bufferAddress + (long)this.position, to, offset, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) break;
            offset += (long)copyCount;
            copyCount = Math.min(count2, this.capacity);
            this.require(copyCount);
        }
        this.setBufferPosition(this.byteBuffer, this.position);
    }
}

