/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.stax;

import com.fasterxml.aalto.UncheckedStreamException;
import com.fasterxml.aalto.WFCException;
import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.in.InputBootstrapper;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.util.TextAccumulator;
import com.fasterxml.aalto.util.XmlNames;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.AttributeInfo;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.ri.Stax2Util;
import org.codehaus.stax2.ri.typed.CharArrayBase64Decoder;
import org.codehaus.stax2.ri.typed.ValueDecoderFactory;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedValueDecoder;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.codehaus.stax2.validation.DTDValidationSchema;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public class StreamReaderImpl
implements XMLStreamReader2,
AttributeInfo,
DTDInfo,
LocationInfo {
    static final int STATE_PROLOG = 0;
    static final int STATE_TREE = 1;
    static final int STATE_EPILOG = 2;
    static final int STATE_CLOSED = 3;
    protected final XmlScanner _scanner;
    protected final boolean _cfgCoalesceText;
    protected final boolean _cfgReportTextAsChars;
    protected int _currToken;
    protected int _parseState;
    protected PName _currName;
    protected int _attrCount;
    protected ValueDecoderFactory _decoderFactory;
    protected CharArrayBase64Decoder _base64Decoder = null;
    protected PName _dtdRootName;
    private static final int MASK_GET_TEXT = 6768;
    private static final int MASK_GET_TEXT_XXX = 4208;
    private static final int MASK_GET_TEXT_WITH_WRITER = 6776;
    private static final int MASK_GET_ELEMENT_TEXT = 4688;
    private static final int MASK_TYPED_ACCESS_ARRAY = 4182;
    private static final int MASK_TYPED_ACCESS_BINARY = 4178;

    public StreamReaderImpl(XmlScanner scanner) {
        this._scanner = scanner;
        this._currToken = 7;
        ReaderConfig cfg = scanner.getConfig();
        this._cfgCoalesceText = cfg.willCoalesceText();
        this._cfgReportTextAsChars = !cfg.willReportCData();
    }

    public static StreamReaderImpl construct(InputBootstrapper bs) throws XMLStreamException {
        return new StreamReaderImpl(bs.bootstrap());
    }

    public XmlScanner getScanner() {
        return this._scanner;
    }

    @Override
    public final String getCharacterEncodingScheme() {
        return this._scanner.getConfig().getXmlDeclEncoding();
    }

    @Override
    public final String getEncoding() {
        return this._scanner.getConfig().getActualEncoding();
    }

    @Override
    public String getVersion() {
        return this._scanner.getConfig().getXmlDeclVersion();
    }

    @Override
    public final boolean isStandalone() {
        return this._scanner.getConfig().getXmlDeclStandalone() == 1;
    }

    @Override
    public final boolean standaloneSet() {
        return this._scanner.getConfig().getXmlDeclStandalone() != 0;
    }

    @Override
    public Object getProperty(String name2) {
        if (name2.equals("javax.xml.stream.entities")) {
            return Collections.EMPTY_LIST;
        }
        if (name2.equals("javax.xml.stream.notations")) {
            return Collections.EMPTY_LIST;
        }
        return this._scanner.getConfig().getProperty(name2, false);
    }

    public ReaderConfig getConfig() {
        return this._scanner.getConfig();
    }

    @Override
    public final int getAttributeCount() {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._attrCount;
    }

    @Override
    public final String getAttributeLocalName(int index2) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index2 >= this._attrCount || index2 < 0) {
            this.reportInvalidAttrIndex(index2);
        }
        return this._scanner.getAttrLocalName(index2);
    }

    @Override
    public final QName getAttributeName(int index2) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index2 >= this._attrCount || index2 < 0) {
            this.reportInvalidAttrIndex(index2);
        }
        return this._scanner.getAttrQName(index2);
    }

    @Override
    public final String getAttributeNamespace(int index2) {
        String p2;
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index2 >= this._attrCount || index2 < 0) {
            this.reportInvalidAttrIndex(index2);
        }
        return (p2 = this._scanner.getAttrNsURI(index2)) == null ? "" : p2;
    }

    @Override
    public final String getAttributePrefix(int index2) {
        String p2;
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index2 >= this._attrCount || index2 < 0) {
            this.reportInvalidAttrIndex(index2);
        }
        return (p2 = this._scanner.getAttrPrefix(index2)) == null ? "" : p2;
    }

    @Override
    public final String getAttributeType(int index2) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index2 >= this._attrCount || index2 < 0) {
            this.reportInvalidAttrIndex(index2);
        }
        return this._scanner.getAttrType(index2);
    }

    @Override
    public final String getAttributeValue(int index2) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (index2 >= this._attrCount || index2 < 0) {
            this.reportInvalidAttrIndex(index2);
        }
        return this._scanner.getAttrValue(index2);
    }

    @Override
    public final String getAttributeValue(String nsURI, String localName) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.getAttrValue(nsURI, localName);
    }

    @Override
    public final String getElementText() throws XMLStreamException {
        int type;
        int type2;
        if (this._currToken != 1) {
            this.throwWfe(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        do {
            if ((type2 = this.next()) != 2) continue;
            return "";
        } while (type2 == 5 || type2 == 3);
        if ((1 << type2 & 0x1250) == 0) {
            this._reportNonTextEvent(type2);
        }
        String text = this._scanner.getText();
        TextAccumulator acc = null;
        while ((type = this.next()) != 2) {
            if ((1 << type & 0x1250) != 0) {
                if (acc == null) {
                    acc = new TextAccumulator();
                    acc.addText(text);
                }
                acc.addText(this.getText());
                continue;
            }
            if (type == 5 || type == 3) continue;
            this._reportNonTextEvent(type);
        }
        return acc == null ? text : acc.getAndClear();
    }

    @Override
    public final int getEventType() {
        if (this._currToken == 12 && (this._cfgCoalesceText || this._cfgReportTextAsChars)) {
            return 4;
        }
        return this._currToken;
    }

    @Override
    public final String getLocalName() {
        if (this._currToken == 1 || this._currToken == 2 || this._currToken == 9) {
            return this._currName.getLocalName();
        }
        throw new IllegalStateException("Current state not START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE");
    }

    @Override
    public final QName getName() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this._scanner.getQName();
    }

    @Override
    public final NamespaceContext getNamespaceContext() {
        return this._scanner;
    }

    @Override
    public final int getNamespaceCount() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this._scanner.getNsCount();
    }

    @Override
    public final String getNamespacePrefix(int index2) {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String p2 = this._scanner.getNamespacePrefix(index2);
        return p2 == null ? "" : p2;
    }

    @Override
    public final String getNamespaceURI() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String uri = this._scanner.getNamespaceURI();
        return uri == null ? "" : uri;
    }

    @Override
    public final String getNamespaceURI(int index2) {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String uri = this._scanner.getNamespaceURI(index2);
        return uri == null ? "" : uri;
    }

    @Override
    public final String getNamespaceURI(String prefix) {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this._scanner.getNamespaceURI(prefix);
    }

    @Override
    public final String getPIData() {
        if (this._currToken != 3) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_PI);
        }
        try {
            return this._scanner.getText();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    @Override
    public final String getPITarget() {
        if (this._currToken != 3) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_PI);
        }
        return this._currName.getLocalName();
    }

    @Override
    public final String getPrefix() {
        if (this._currToken != 1 && this._currToken != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        String p2 = this._currName.getPrefix();
        return p2 == null ? "" : p2;
    }

    @Override
    public final String getText() {
        if ((1 << this._currToken & 0x1A70) == 0) {
            this.throwNotTextual(this._currToken);
        }
        try {
            return this._scanner.getText();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    @Override
    public final char[] getTextCharacters() {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        try {
            return this._scanner.getTextCharacters();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    @Override
    public final int getTextCharacters(int srcStart, char[] target, int targetStart, int len) {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        try {
            return this._scanner.getTextCharacters(srcStart, target, targetStart, len);
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    @Override
    public final int getTextLength() {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        try {
            return this._scanner.getTextLength();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    @Override
    public final int getTextStart() {
        if ((1 << this._currToken & 0x1070) == 0) {
            this.throwNotTextXxx(this._currToken);
        }
        return 0;
    }

    @Override
    public final boolean hasName() {
        return this._currToken == 1 || this._currToken == 2;
    }

    @Override
    public final boolean hasNext() {
        return this._currToken != 8;
    }

    @Override
    public final boolean hasText() {
        return (1 << this._currToken & 0x1A70) != 0;
    }

    @Override
    public final boolean isAttributeSpecified(int index2) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.isAttrSpecified(index2);
    }

    @Override
    public final boolean isCharacters() {
        return this.getEventType() == 4;
    }

    @Override
    public final boolean isEndElement() {
        return this._currToken == 2;
    }

    @Override
    public final boolean isStartElement() {
        return this._currToken == 1;
    }

    @Override
    public final boolean isWhiteSpace() {
        if (this._currToken == 4 || this._currToken == 12) {
            try {
                return this._scanner.isTextWhitespace();
            }
            catch (XMLStreamException sex) {
                throw UncheckedStreamException.createFrom(sex);
            }
        }
        return this._currToken == 6;
    }

    @Override
    public final void require(int type, String nsUri, String localName) throws XMLStreamException {
        int curr = this._currToken;
        if (curr != type) {
            if (curr == 12) {
                if (this._cfgCoalesceText || this._cfgReportTextAsChars) {
                    curr = 4;
                }
            } else if (curr == 6) {
                // empty if block
            }
        }
        if (type != curr) {
            this.throwWfe("Expected type " + ErrorConsts.tokenTypeDesc(type) + ", current type " + ErrorConsts.tokenTypeDesc(curr));
        }
        if (localName != null) {
            String n2;
            if (curr != 1 && curr != 2 && curr != 9) {
                this.throwWfe("Expected non-null local name, but current token not a START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE (was " + ErrorConsts.tokenTypeDesc(this._currToken) + ")");
            }
            if ((n2 = this.getLocalName()) != localName && !n2.equals(localName)) {
                this.throwWfe("Expected local name '" + localName + "'; current local name '" + n2 + "'.");
            }
        }
        if (nsUri != null) {
            if (curr != 1 && curr != 2) {
                this.throwWfe("Expected non-null NS URI, but current token not a START_ELEMENT or END_ELEMENT (was " + ErrorConsts.tokenTypeDesc(curr) + ")");
            }
            String uri = this.getNamespaceURI();
            if (nsUri.length() == 0) {
                if (uri != null && uri.length() > 0) {
                    this.throwWfe("Expected empty namespace, instead have '" + uri + "'.");
                }
            } else if (nsUri != uri && !nsUri.equals(uri)) {
                this.throwWfe("Expected namespace '" + nsUri + "'; have '" + uri + "'.");
            }
        }
    }

    @Override
    public final int next() throws XMLStreamException {
        int type;
        if (this._parseState == 1) {
            int type2 = this._scanner.nextFromTree();
            if (type2 == -1) {
                this.handleTreeEoi();
            }
            this._currToken = type2;
            if (type2 == 12) {
                if (this._cfgCoalesceText || this._cfgReportTextAsChars) {
                    return 4;
                }
            } else {
                this._currName = this._scanner.getName();
                if (type2 == 2) {
                    if (this._scanner.hasEmptyStack()) {
                        this._parseState = 2;
                    }
                } else if (type2 == 1) {
                    this._attrCount = this._scanner.getAttrCount();
                }
            }
            return type2;
        }
        if (this._parseState == 0) {
            type = this._scanner.nextFromProlog(true);
            if (type == 1) {
                this._parseState = 1;
                this._attrCount = this._scanner.getAttrCount();
            } else if (type == 11) {
                if (this._dtdRootName != null) {
                    this.throwWfe("Duplicate DOCTYPE declaration");
                }
                this._dtdRootName = this._scanner.getName();
            }
        } else if (this._parseState == 2) {
            type = this._scanner.nextFromProlog(false);
        } else {
            throw new NoSuchElementException();
        }
        if (type < 0) {
            return this.handlePrologEoi(this._parseState == 0);
        }
        this._currName = this._scanner.getName();
        this._currToken = type;
        return this._currToken;
    }

    @Override
    public final int nextTag() throws XMLStreamException {
        block5: while (true) {
            int next = this.next();
            switch (next) {
                case 3: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (this.isWhiteSpace()) continue block5;
                    this.throwWfe("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().");
                    break;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
            this.throwWfe("Received event " + ErrorConsts.tokenTypeDesc(next) + ", instead of START_ELEMENT or END_ELEMENT.");
        }
    }

    @Override
    public final void close() throws XMLStreamException {
        this._closeScanner(false);
    }

    @Override
    public final Location getLocation() {
        return this.getStartLocation();
    }

    @Override
    public final boolean getElementAsBoolean() throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder dec = this._decoderFactory().getBooleanDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    @Override
    public final int getElementAsInt() throws XMLStreamException {
        ValueDecoderFactory.IntDecoder dec = this._decoderFactory().getIntDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    @Override
    public final long getElementAsLong() throws XMLStreamException {
        ValueDecoderFactory.LongDecoder dec = this._decoderFactory().getLongDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    @Override
    public final float getElementAsFloat() throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder dec = this._decoderFactory().getFloatDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    @Override
    public final double getElementAsDouble() throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder dec = this._decoderFactory().getDoubleDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    @Override
    public final BigInteger getElementAsInteger() throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder dec = this._decoderFactory().getIntegerDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    @Override
    public final BigDecimal getElementAsDecimal() throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder dec = this._decoderFactory().getDecimalDecoder();
        this.getElementAs(dec);
        return dec.getValue();
    }

    @Override
    public final QName getElementAsQName() throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder dec = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getElementAs(dec);
        return this.verifyQName(dec.getValue());
    }

    @Override
    public final byte[] getElementAsBinary() throws XMLStreamException {
        return this.getElementAsBinary(Base64Variants.getDefaultVariant());
    }

    @Override
    public final void getElementAs(TypedValueDecoder tvd) throws XMLStreamException {
        String value = this.getElementText();
        if ((value = value.trim()).length() == 0) {
            this._handleEmptyValue(tvd);
            return;
        }
        try {
            tvd.decode(value);
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, value);
        }
    }

    @Override
    public final byte[] getElementAsBinary(Base64Variant v2) throws XMLStreamException {
        Stax2Util.ByteAggregator aggr = this._base64Decoder().getByteAggregator();
        byte[] buffer = aggr.startAggregation();
        while (true) {
            int readCount;
            int offset = 0;
            int len = buffer.length;
            do {
                if ((readCount = this.readElementAsBinary(buffer, offset, len, v2)) < 1) {
                    return aggr.aggregateAll(buffer, offset);
                }
                offset += readCount;
            } while ((len -= readCount) > 0);
            buffer = aggr.addFullBlock(buffer);
        }
    }

    @Override
    public final int readElementAsIntArray(int[] value, int from2, int length) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getIntArrayDecoder(value, from2, length));
    }

    @Override
    public final int readElementAsLongArray(long[] value, int from2, int length) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getLongArrayDecoder(value, from2, length));
    }

    @Override
    public final int readElementAsFloatArray(float[] value, int from2, int length) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getFloatArrayDecoder(value, from2, length));
    }

    @Override
    public final int readElementAsDoubleArray(double[] value, int from2, int length) throws XMLStreamException {
        return this.readElementAsArray(this._decoderFactory().getDoubleArrayDecoder(value, from2, length));
    }

    @Override
    public final int readElementAsArray(TypedArrayDecoder dec) throws XMLStreamException {
        boolean reset;
        int type = this._currToken;
        if ((1 << type & 0x1056) == 0) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM_OR_TEXT);
        }
        if (type == 1) {
            if (this._scanner.isEmptyTag()) {
                this.next();
                return -1;
            }
            do {
                if ((type = this.next()) != 2) continue;
                return -1;
            } while (type == 5 || type == 3);
            if (type != 4 && type != 12) {
                throw this._constructUnexpectedInTyped(type);
            }
            reset = true;
        } else {
            reset = false;
        }
        int count2 = 0;
        while (type != 2) {
            if (type == 4 || type == 12 || type == 6) {
                count2 += this._scanner.decodeElements(dec, reset);
                if (!dec.hasRoom()) {
                    break;
                }
            } else if (type != 5 && type != 3) {
                throw this._constructUnexpectedInTyped(type);
            }
            reset = true;
            type = this.next();
        }
        return count2 > 0 ? count2 : -1;
    }

    @Override
    public final int readElementAsBinary(byte[] resultBuffer, int offset, int maxLength) throws XMLStreamException {
        return this.readElementAsBinary(resultBuffer, offset, maxLength, Base64Variants.getDefaultVariant());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final int readElementAsBinary(byte[] resultBuffer, int offset, int maxLength, Base64Variant v2) throws XMLStreamException {
        if (resultBuffer == null) {
            throw new IllegalArgumentException("resultBuffer is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Illegal offset (" + offset + "), must be [0, " + resultBuffer.length + "[");
        }
        if (maxLength < 1 || offset + maxLength > resultBuffer.length) {
            if (maxLength != 0) throw new IllegalArgumentException("Illegal maxLength (" + maxLength + "), has to be positive number, and offset+maxLength can not exceed" + resultBuffer.length);
            return 0;
        }
        CharArrayBase64Decoder dec = this._base64Decoder();
        int type = this._currToken;
        if ((1 << type & 0x1052) == 0) {
            if (type != 2) throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM_OR_TEXT);
            if (!dec.hasData()) {
                return -1;
            }
        } else if (type == 1) {
            if (this._scanner.isEmptyTag()) {
                this.next();
                return -1;
            }
            do {
                if ((type = this.next()) != 2) continue;
                return -1;
            } while (type == 5 || type == 3);
            if (type != 4) {
                if (type != 12) throw this._constructUnexpectedInTyped(type);
            }
            this._scanner.resetForDecoding(v2, dec, true);
        }
        int totalCount = 0;
        while (true) {
            int count2;
            try {
                count2 = dec.decode(resultBuffer, offset, maxLength);
            }
            catch (IllegalArgumentException iae) {
                throw this._constructTypeException(iae.getMessage(), "");
            }
            offset += count2;
            totalCount += count2;
            if ((maxLength -= count2) < 1 || this._currToken == 2) break;
            while ((type = this.next()) == 5 || type == 3 || type == 6) {
            }
            if (type == 2) {
                int left = dec.endOfContent();
                if (left < 0) {
                    throw this._constructTypeException("Incomplete base64 triplet at the end of decoded content", "");
                }
                if (left <= 0) break;
                continue;
            }
            this._scanner.resetForDecoding(v2, dec, false);
        }
        if (totalCount <= 0) return -1;
        int n2 = totalCount;
        return n2;
    }

    @Override
    public final int getAttributeIndex(String namespaceURI, String localName) {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this.findAttributeIndex(namespaceURI, localName);
    }

    @Override
    public final boolean getAttributeAsBoolean(int index2) throws XMLStreamException {
        ValueDecoderFactory.BooleanDecoder dec = this._decoderFactory().getBooleanDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    @Override
    public final int getAttributeAsInt(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntDecoder dec = this._decoderFactory().getIntDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    @Override
    public final long getAttributeAsLong(int index2) throws XMLStreamException {
        ValueDecoderFactory.LongDecoder dec = this._decoderFactory().getLongDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    @Override
    public final float getAttributeAsFloat(int index2) throws XMLStreamException {
        ValueDecoderFactory.FloatDecoder dec = this._decoderFactory().getFloatDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    @Override
    public final double getAttributeAsDouble(int index2) throws XMLStreamException {
        ValueDecoderFactory.DoubleDecoder dec = this._decoderFactory().getDoubleDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    @Override
    public final BigInteger getAttributeAsInteger(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntegerDecoder dec = this._decoderFactory().getIntegerDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    @Override
    public final BigDecimal getAttributeAsDecimal(int index2) throws XMLStreamException {
        ValueDecoderFactory.DecimalDecoder dec = this._decoderFactory().getDecimalDecoder();
        this.getAttributeAs(index2, dec);
        return dec.getValue();
    }

    @Override
    public final QName getAttributeAsQName(int index2) throws XMLStreamException {
        ValueDecoderFactory.QNameDecoder dec = this._decoderFactory().getQNameDecoder(this.getNamespaceContext());
        this.getAttributeAs(index2, dec);
        return this.verifyQName(dec.getValue());
    }

    @Override
    public final void getAttributeAs(int index2, TypedValueDecoder tvd) throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        try {
            this._scanner.decodeAttrValue(index2, tvd);
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, this.getAttributeValue(index2));
        }
    }

    @Override
    public final int[] getAttributeAsIntArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.IntArrayDecoder dec = this._decoderFactory().getIntArrayDecoder();
        this.getAttributeAsArray(index2, dec);
        return dec.getValues();
    }

    @Override
    public final long[] getAttributeAsLongArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.LongArrayDecoder dec = this._decoderFactory().getLongArrayDecoder();
        this.getAttributeAsArray(index2, dec);
        return dec.getValues();
    }

    @Override
    public final float[] getAttributeAsFloatArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.FloatArrayDecoder dec = this._decoderFactory().getFloatArrayDecoder();
        this.getAttributeAsArray(index2, dec);
        return dec.getValues();
    }

    @Override
    public final double[] getAttributeAsDoubleArray(int index2) throws XMLStreamException {
        ValueDecoderFactory.DoubleArrayDecoder dec = this._decoderFactory().getDoubleArrayDecoder();
        this.getAttributeAsArray(index2, dec);
        return dec.getValues();
    }

    @Override
    public final int getAttributeAsArray(int index2, TypedArrayDecoder tad) throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.decodeAttrValues(index2, tad);
    }

    @Override
    public final byte[] getAttributeAsBinary(int index2) throws XMLStreamException {
        return this.getAttributeAsBinary(index2, Base64Variants.getDefaultVariant());
    }

    @Override
    public final byte[] getAttributeAsBinary(int index2, Base64Variant v2) throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this._scanner.decodeAttrBinaryValue(index2, v2, this._base64Decoder());
    }

    protected QName verifyQName(QName n2) throws TypedXMLStreamException {
        String ln = n2.getLocalPart();
        int ix = XmlNames.findIllegalNameChar(ln, false);
        if (ix >= 0) {
            String prefix = n2.getPrefix();
            String pname = prefix != null && prefix.length() > 0 ? prefix + ":" + ln : ln;
            throw this._constructTypeException("Invalid local name \"" + ln + "\" (character at #" + ix + " is invalid)", pname);
        }
        return n2;
    }

    @Override
    @Deprecated
    public final Object getFeature(String name2) {
        return null;
    }

    @Override
    @Deprecated
    public final void setFeature(String name2, Object value) {
    }

    @Override
    public final boolean isPropertySupported(String name2) {
        return this._scanner.getConfig().isPropertySupported(name2);
    }

    @Override
    public final boolean setProperty(String name2, Object value) {
        return this._scanner.getConfig().setProperty(name2, value);
    }

    @Override
    public final void skipElement() throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        int nesting = 1;
        while (true) {
            int type;
            if ((type = this.next()) == 1) {
                ++nesting;
                continue;
            }
            if (type == 2 && --nesting == 0) break;
        }
    }

    @Override
    public final AttributeInfo getAttributeInfo() throws XMLStreamException {
        if (this._currToken != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return this;
    }

    @Override
    public final DTDInfo getDTDInfo() throws XMLStreamException {
        if (this._currToken != 11) {
            return null;
        }
        return this;
    }

    @Override
    public final LocationInfo getLocationInfo() {
        return this;
    }

    @Override
    public final int getText(Writer w2, boolean preserveContents) throws XMLStreamException {
        if ((1 << this._currToken & 0x1A78) == 0) {
            this.throwNotTextual(this._currToken);
        }
        return this._scanner.getText(w2, preserveContents);
    }

    @Override
    public final int getDepth() {
        int d2 = this._scanner.getDepth();
        if (this._currToken == 2) {
            ++d2;
        }
        return d2;
    }

    @Override
    public final boolean isEmptyElement() throws XMLStreamException {
        return this._currToken == 1 ? this._scanner.isEmptyTag() : false;
    }

    @Override
    public final NamespaceContext getNonTransientNamespaceContext() {
        return this._scanner.getNonTransientNamespaceContext();
    }

    @Override
    public final String getPrefixedName() {
        switch (this._currToken) {
            case 1: 
            case 2: {
                return this._currName.getPrefixedName();
            }
            case 9: {
                return this.getLocalName();
            }
            case 3: {
                return this.getPITarget();
            }
            case 11: {
                return this.getDTDRootName();
            }
        }
        throw new IllegalStateException("Current state not START_ELEMENT, END_ELEMENT, ENTITY_REFERENCE, PROCESSING_INSTRUCTION or DTD");
    }

    @Override
    public final void closeCompletely() throws XMLStreamException {
        this._closeScanner(true);
    }

    @Override
    public final Object getProcessedDTD() {
        return null;
    }

    @Override
    public final String getDTDRootName() {
        if (this._currToken != 11) {
            return null;
        }
        return this._currName == null ? null : this._currName.getPrefixedName();
    }

    @Override
    public final String getDTDPublicId() {
        return this._scanner.getDTDPublicId();
    }

    @Override
    public final String getDTDSystemId() {
        return this._scanner.getDTDSystemId();
    }

    @Override
    public final String getDTDInternalSubset() {
        if (this._currToken != 11) {
            return null;
        }
        try {
            return this._scanner.getText();
        }
        catch (XMLStreamException sex) {
            throw UncheckedStreamException.createFrom(sex);
        }
    }

    @Override
    public final DTDValidationSchema getProcessedDTDSchema() {
        return null;
    }

    @Override
    public final long getStartingByteOffset() {
        return this._scanner.getStartingByteOffset();
    }

    @Override
    public final long getStartingCharOffset() {
        return this._scanner.getStartingCharOffset();
    }

    @Override
    public final long getEndingByteOffset() throws XMLStreamException {
        return this._scanner.getEndingByteOffset();
    }

    @Override
    public final long getEndingCharOffset() throws XMLStreamException {
        return this._scanner.getEndingCharOffset();
    }

    @Override
    public final XMLStreamLocation2 getStartLocation() {
        return this._scanner.getStartLocation();
    }

    @Override
    public final XMLStreamLocation2 getEndLocation() throws XMLStreamException {
        return this._scanner.getEndLocation();
    }

    @Override
    public final XMLStreamLocation2 getCurrentLocation() {
        return this._scanner.getCurrentLocation();
    }

    @Override
    public final int findAttributeIndex(String nsURI, String localName) {
        return this._scanner.findAttrIndex(nsURI, localName);
    }

    @Override
    public final int getIdAttributeIndex() {
        return -1;
    }

    @Override
    public final int getNotationAttributeIndex() {
        return -1;
    }

    @Override
    public final XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    @Override
    public final XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    @Override
    public final XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        return null;
    }

    @Override
    public final ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler h2) {
        return null;
    }

    protected void _reportNonTextEvent(int type) throws XMLStreamException {
        this.throwWfe("Expected a text token, got " + ErrorConsts.tokenTypeDesc(type) + ".");
    }

    protected Location getLastCharLocation() {
        return this._scanner.getCurrentLocation();
    }

    protected int handlePrologEoi(boolean isProlog) throws XMLStreamException {
        this.close();
        if (isProlog) {
            this.throwUnexpectedEOI(ErrorConsts.SUFFIX_IN_PROLOG);
        }
        return 8;
    }

    protected void handleTreeEoi() throws XMLStreamException {
        this._currToken = 8;
        this.throwUnexpectedEOI(ErrorConsts.SUFFIX_IN_TREE);
    }

    protected void throwWfe(String msg) throws XMLStreamException {
        throw new WFCException(msg, this.getLastCharLocation());
    }

    private void throwNotTextual(int type) {
        throw new IllegalStateException("Not a textual event (" + ErrorConsts.tokenTypeDesc(this._currToken) + ")");
    }

    private void throwNotTextXxx(int type) {
        throw new IllegalStateException("getTextXxx() methods can not be called on " + ErrorConsts.tokenTypeDesc(this._currToken));
    }

    protected void throwFromIOE(IOException ioe) throws XMLStreamException {
        throw new IoStreamException(ioe);
    }

    protected void throwUnexpectedEOI(String msg) throws XMLStreamException {
        this.throwWfe("Unexpected End-of-input" + msg);
    }

    protected XMLStreamException _constructUnexpectedInTyped(int nextToken) {
        if (nextToken == 1) {
            return this._constructTypeException("Element content can not contain child START_ELEMENT when using Typed Access methods", null);
        }
        return this._constructTypeException("Expected a text token, got " + ErrorConsts.tokenTypeDesc(nextToken), null);
    }

    private TypedXMLStreamException _constructTypeException(IllegalArgumentException iae, String lexicalValue) {
        return new TypedXMLStreamException(lexicalValue, iae.getMessage(), this.getStartLocation(), iae);
    }

    private TypedXMLStreamException _constructTypeException(String msg, String lexicalValue) {
        return new TypedXMLStreamException(lexicalValue, msg, this.getStartLocation());
    }

    protected void reportInvalidAttrIndex(int index2) {
        throw new IllegalArgumentException("Illegal attribute index, " + index2 + ", current START_ELEMENT has " + this._attrCount + " attributes");
    }

    protected void _closeScanner(boolean forceStreamClose) throws XMLStreamException {
        if (this._parseState != 3) {
            this._parseState = 3;
            if (this._currToken != 8) {
                this._currToken = 8;
            }
        }
        this._scanner.close(forceStreamClose);
    }

    protected final ValueDecoderFactory _decoderFactory() {
        if (this._decoderFactory == null) {
            this._decoderFactory = new ValueDecoderFactory();
        }
        return this._decoderFactory;
    }

    protected CharArrayBase64Decoder _base64Decoder() {
        if (this._base64Decoder == null) {
            this._base64Decoder = new CharArrayBase64Decoder();
        }
        return this._base64Decoder;
    }

    private void _handleEmptyValue(TypedValueDecoder dec) throws XMLStreamException {
        try {
            dec.handleEmptyValue();
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypeException(iae, "");
        }
    }

    public final String toString() {
        return "[Aalto stream reader, scanner: " + this._scanner + "]";
    }
}

