/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;

final class Async {
    static final long ASYNC_EXPIRY = 0x5FFFFFFFFFFFFFFEL;

    private Async() {
    }

    static boolean isReady(@Nullable CompletableFuture<?> future2) {
        return future2 != null && future2.isDone() && !future2.isCompletedExceptionally() && future2.join() != null;
    }

    static <V> @Nullable V getIfReady(@Nullable CompletableFuture<V> future2) {
        return Async.isReady(future2) ? (V)future2.join() : null;
    }

    static <V> @Nullable V getWhenSuccessful(@Nullable CompletableFuture<V> future2) {
        try {
            return future2 == null ? null : (V)future2.join();
        }
        catch (CancellationException | CompletionException e2) {
            return null;
        }
    }

    static final class AsyncExpiry<K, V>
    implements Expiry<K, CompletableFuture<V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Expiry<? super K, ? super V> delegate;

        AsyncExpiry(Expiry<? super K, ? super V> delegate2) {
            this.delegate = Objects.requireNonNull(delegate2);
        }

        @Override
        public long expireAfterCreate(K key, CompletableFuture<V> future2, long currentTime) {
            if (Async.isReady(future2)) {
                long duration = this.delegate.expireAfterCreate(key, future2.join(), currentTime);
                return Math.min(duration, 0x3FFFFFFFFFFFFFFFL);
            }
            return 0x5FFFFFFFFFFFFFFEL;
        }

        @Override
        public long expireAfterUpdate(K key, CompletableFuture<V> future2, long currentTime, long currentDuration) {
            if (Async.isReady(future2)) {
                long duration = currentDuration > 0x3FFFFFFFFFFFFFFFL ? this.delegate.expireAfterCreate(key, future2.join(), currentTime) : this.delegate.expireAfterUpdate(key, future2.join(), currentTime, currentDuration);
                return Math.min(duration, 0x3FFFFFFFFFFFFFFFL);
            }
            return 0x5FFFFFFFFFFFFFFEL;
        }

        @Override
        public long expireAfterRead(K key, CompletableFuture<V> future2, long currentTime, long currentDuration) {
            if (Async.isReady(future2)) {
                long duration = this.delegate.expireAfterRead(key, future2.join(), currentTime, currentDuration);
                return Math.min(duration, 0x3FFFFFFFFFFFFFFFL);
            }
            return 0x5FFFFFFFFFFFFFFEL;
        }

        Object writeReplace() {
            return this.delegate;
        }
    }

    static final class AsyncWeigher<K, V>
    implements Weigher<K, CompletableFuture<V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Weigher<K, V> delegate;

        AsyncWeigher(Weigher<K, V> delegate2) {
            this.delegate = Objects.requireNonNull(delegate2);
        }

        @Override
        public int weigh(K key, CompletableFuture<V> future2) {
            return Async.isReady(future2) ? this.delegate.weigh(key, future2.join()) : 0;
        }

        Object writeReplace() {
            return this.delegate;
        }
    }

    static final class AsyncEvictionListener<K, V>
    implements RemovalListener<K, CompletableFuture<V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final RemovalListener<K, V> delegate;

        AsyncEvictionListener(RemovalListener<K, V> delegate2) {
            this.delegate = Objects.requireNonNull(delegate2);
        }

        @Override
        public void onRemoval(@Nullable K key, @Nullable CompletableFuture<V> future2, RemovalCause cause) {
            V value = Async.getIfReady(future2);
            if (value != null) {
                this.delegate.onRemoval(key, value, cause);
            }
        }

        Object writeReplace() {
            return this.delegate;
        }
    }

    static final class AsyncRemovalListener<K, V>
    implements RemovalListener<K, CompletableFuture<V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final RemovalListener<K, V> delegate;
        final Executor executor;

        AsyncRemovalListener(RemovalListener<K, V> delegate2, Executor executor) {
            this.delegate = Objects.requireNonNull(delegate2);
            this.executor = Objects.requireNonNull(executor);
        }

        @Override
        public void onRemoval(@Nullable K key, @Nullable CompletableFuture<V> future2, RemovalCause cause) {
            if (future2 != null) {
                future2.thenAcceptAsync(value -> {
                    if (value != null) {
                        this.delegate.onRemoval(key, value, cause);
                    }
                }, this.executor);
            }
        }

        Object writeReplace() {
            return this.delegate;
        }
    }
}

