/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AccessOrderDeque;
import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.FrequencySketch;
import com.github.benmanes.caffeine.cache.LocalCacheFactory;
import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.WI;
import org.checkerframework.checker.nullness.qual.Nullable;

class WIMW<K, V>
extends WI<K, V> {
    static final LocalCacheFactory FACTORY = WIMW::new;
    long maximum;
    long weightedSize;
    long windowMaximum;
    long windowWeightedSize;
    long mainProtectedMaximum;
    long mainProtectedWeightedSize;
    double stepSize;
    long adjustment;
    int hitsInSample;
    int missesInSample;
    double previousSampleHitRate;
    final FrequencySketch<K> sketch = new FrequencySketch();
    final AccessOrderDeque<Node<K, V>> accessOrderWindowDeque;
    final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque;
    final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque;

    WIMW(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl2) {
        super(caffeine, asyncCacheLoader, bl2);
        if (caffeine.hasInitialCapacity()) {
            long l2 = Math.min(caffeine.getMaximum(), (long)caffeine.getInitialCapacity());
            this.sketch.ensureCapacity(l2);
        }
        this.accessOrderWindowDeque = caffeine.evicts() || caffeine.expiresAfterAccess() ? new AccessOrderDeque() : null;
        this.accessOrderProbationDeque = new AccessOrderDeque();
        this.accessOrderProtectedDeque = new AccessOrderDeque();
    }

    @Override
    protected final boolean evicts() {
        return true;
    }

    @Override
    protected final long maximum() {
        return this.maximum;
    }

    @Override
    protected final void setMaximum(long l2) {
        this.maximum = l2;
    }

    @Override
    protected final long weightedSize() {
        return this.weightedSize;
    }

    @Override
    protected final void setWeightedSize(long l2) {
        this.weightedSize = l2;
    }

    @Override
    protected final long windowMaximum() {
        return this.windowMaximum;
    }

    @Override
    protected final void setWindowMaximum(long l2) {
        this.windowMaximum = l2;
    }

    @Override
    protected final long windowWeightedSize() {
        return this.windowWeightedSize;
    }

    @Override
    protected final void setWindowWeightedSize(long l2) {
        this.windowWeightedSize = l2;
    }

    @Override
    protected final long mainProtectedMaximum() {
        return this.mainProtectedMaximum;
    }

    @Override
    protected final void setMainProtectedMaximum(long l2) {
        this.mainProtectedMaximum = l2;
    }

    @Override
    protected final long mainProtectedWeightedSize() {
        return this.mainProtectedWeightedSize;
    }

    @Override
    protected final void setMainProtectedWeightedSize(long l2) {
        this.mainProtectedWeightedSize = l2;
    }

    @Override
    protected final double stepSize() {
        return this.stepSize;
    }

    @Override
    protected final void setStepSize(double d2) {
        this.stepSize = d2;
    }

    @Override
    protected final long adjustment() {
        return this.adjustment;
    }

    @Override
    protected final void setAdjustment(long l2) {
        this.adjustment = l2;
    }

    @Override
    protected final int hitsInSample() {
        return this.hitsInSample;
    }

    @Override
    protected final void setHitsInSample(int n2) {
        this.hitsInSample = n2;
    }

    @Override
    protected final int missesInSample() {
        return this.missesInSample;
    }

    @Override
    protected final void setMissesInSample(int n2) {
        this.missesInSample = n2;
    }

    @Override
    protected final double previousSampleHitRate() {
        return this.previousSampleHitRate;
    }

    @Override
    protected final void setPreviousSampleHitRate(double d2) {
        this.previousSampleHitRate = d2;
    }

    @Override
    protected final FrequencySketch<K> frequencySketch() {
        return this.sketch;
    }

    @Override
    protected final AccessOrderDeque<Node<K, V>> accessOrderWindowDeque() {
        return this.accessOrderWindowDeque;
    }

    @Override
    protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
        return this.accessOrderProbationDeque;
    }

    @Override
    protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
        return this.accessOrderProtectedDeque;
    }
}

