/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Platform;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class ObjectArrays {
    private ObjectArrays() {
    }

    @GwtIncompatible
    public static <T> T[] newArray(Class<T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, length);
    }

    @GwtIncompatible
    public static <T> T[] concat(T[] first2, T[] second2, Class<T> type) {
        T[] result2 = ObjectArrays.newArray(type, first2.length + second2.length);
        System.arraycopy(first2, 0, result2, 0, first2.length);
        System.arraycopy(second2, 0, result2, first2.length, second2.length);
        return result2;
    }

    public static <T> T[] concat(@ParametricNullness T element, T[] array2) {
        T[] result2 = ObjectArrays.newArray(array2, array2.length + 1);
        result2[0] = element;
        System.arraycopy(array2, 0, result2, 1, array2.length);
        return result2;
    }

    public static <T> T[] concat(T[] array2, @ParametricNullness T element) {
        T[] result2 = Arrays.copyOf(array2, array2.length + 1);
        result2[array2.length] = element;
        return result2;
    }

    static <T> T[] toArrayImpl(Collection<?> c2, T[] array2) {
        int size = c2.size();
        if (array2.length < size) {
            array2 = ObjectArrays.newArray(array2, size);
        }
        ObjectArrays.fillArray(c2, array2);
        if (array2.length > size) {
            @Nullable T[] unsoundlyCovariantArray = array2;
            unsoundlyCovariantArray[size] = null;
        }
        return array2;
    }

    static <T> T[] toArrayImpl(@Nullable Object[] src, int offset, int len, T[] dst) {
        Preconditions.checkPositionIndexes(offset, offset + len, src.length);
        if (dst.length < len) {
            dst = ObjectArrays.newArray(dst, len);
        } else if (dst.length > len) {
            T[] unsoundlyCovariantArray = dst;
            unsoundlyCovariantArray[len] = null;
        }
        System.arraycopy(src, offset, dst, 0, len);
        return dst;
    }

    static @Nullable Object[] toArrayImpl(Collection<?> c2) {
        return ObjectArrays.fillArray(c2, new Object[c2.size()]);
    }

    static @Nullable Object[] copyAsObjectArray(@Nullable Object[] elements, int offset, int length) {
        Preconditions.checkPositionIndexes(offset, offset + length, elements.length);
        if (length == 0) {
            return new Object[0];
        }
        @Nullable Object[] result2 = new Object[length];
        System.arraycopy(elements, offset, result2, 0, length);
        return result2;
    }

    @CanIgnoreReturnValue
    private static @Nullable Object[] fillArray(Iterable<?> elements, @Nullable Object[] array2) {
        int i2 = 0;
        for (Object element : elements) {
            array2[i2++] = element;
        }
        return array2;
    }

    static void swap(Object[] array2, int i2, int j2) {
        Object temp = array2[i2];
        array2[i2] = array2[j2];
        array2[j2] = temp;
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object ... array2) {
        return ObjectArrays.checkElementsNotNull(array2, array2.length);
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object[] array2, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            ObjectArrays.checkElementNotNull(array2[i2], i2);
        }
        return array2;
    }

    @CanIgnoreReturnValue
    static Object checkElementNotNull(Object element, int index2) {
        if (element == null) {
            throw new NullPointerException("at index " + index2);
        }
        return element;
    }
}

