/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractNonStreamingHashFunction;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.LittleEndianByteArray;

@ElementTypesAreNonnullByDefault
final class Fingerprint2011
extends AbstractNonStreamingHashFunction {
    static final HashFunction FINGERPRINT_2011 = new Fingerprint2011();
    private static final long K0 = -6505348102511208375L;
    private static final long K1 = -8261664234251669945L;
    private static final long K2 = -4288712594273399085L;
    private static final long K3 = -4132994306676758123L;

    Fingerprint2011() {
    }

    @Override
    public HashCode hashBytes(byte[] input2, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, input2.length);
        return HashCode.fromLong(Fingerprint2011.fingerprint(input2, off, len));
    }

    @Override
    public int bits() {
        return 64;
    }

    public String toString() {
        return "Hashing.fingerprint2011()";
    }

    @VisibleForTesting
    static long fingerprint(byte[] bytes2, int offset, int length) {
        long result2 = length <= 32 ? Fingerprint2011.murmurHash64WithSeed(bytes2, offset, length, -1397348546323613475L) : (length <= 64 ? Fingerprint2011.hashLength33To64(bytes2, offset, length) : Fingerprint2011.fullFingerprint(bytes2, offset, length));
        long u2 = length >= 8 ? LittleEndianByteArray.load64(bytes2, offset) : -6505348102511208375L;
        long v2 = length >= 9 ? LittleEndianByteArray.load64(bytes2, offset + length - 8) : -6505348102511208375L;
        result2 = Fingerprint2011.hash128to64(result2 + v2, u2);
        return result2 == 0L || result2 == 1L ? result2 + -2L : result2;
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    @VisibleForTesting
    static long hash128to64(long high, long low) {
        long a2 = (low ^ high) * -4132994306676758123L;
        a2 ^= a2 >>> 47;
        long b2 = (high ^ a2) * -4132994306676758123L;
        b2 ^= b2 >>> 47;
        return b2 *= -4132994306676758123L;
    }

    private static void weakHashLength32WithSeeds(byte[] bytes2, int offset, long seedA, long seedB, long[] output) {
        long part1 = LittleEndianByteArray.load64(bytes2, offset);
        long part2 = LittleEndianByteArray.load64(bytes2, offset + 8);
        long part3 = LittleEndianByteArray.load64(bytes2, offset + 16);
        long part4 = LittleEndianByteArray.load64(bytes2, offset + 24);
        seedB = Long.rotateRight(seedB + (seedA += part1) + part4, 51);
        long c2 = seedA;
        seedA += part2;
        output[0] = seedA + part4;
        output[1] = (seedB += Long.rotateRight(seedA += part3, 23)) + c2;
    }

    private static long fullFingerprint(byte[] bytes2, int offset, int length) {
        long x2 = LittleEndianByteArray.load64(bytes2, offset);
        long y2 = LittleEndianByteArray.load64(bytes2, offset + length - 16) ^ 0x8D58AC26AFE12E47L;
        long z2 = LittleEndianByteArray.load64(bytes2, offset + length - 56) ^ 0xA5B85C5E198ED849L;
        long[] v2 = new long[2];
        long[] w2 = new long[2];
        Fingerprint2011.weakHashLength32WithSeeds(bytes2, offset + length - 64, length, y2, v2);
        Fingerprint2011.weakHashLength32WithSeeds(bytes2, offset + length - 32, (long)length * -8261664234251669945L, -6505348102511208375L, w2);
        x2 = Long.rotateRight((z2 += Fingerprint2011.shiftMix(v2[1]) * -8261664234251669945L) + x2, 39) * -8261664234251669945L;
        y2 = Long.rotateRight(y2, 33) * -8261664234251669945L;
        length = length - 1 & 0xFFFFFFC0;
        do {
            x2 = Long.rotateRight(x2 + y2 + v2[0] + LittleEndianByteArray.load64(bytes2, offset + 16), 37) * -8261664234251669945L;
            y2 = Long.rotateRight(y2 + v2[1] + LittleEndianByteArray.load64(bytes2, offset + 48), 42) * -8261664234251669945L;
            z2 = Long.rotateRight(z2 ^ w2[0], 33);
            Fingerprint2011.weakHashLength32WithSeeds(bytes2, offset, v2[1] * -8261664234251669945L, (x2 ^= w2[1]) + w2[0], v2);
            Fingerprint2011.weakHashLength32WithSeeds(bytes2, offset + 32, z2 + w2[1], y2 ^= v2[0], w2);
            long tmp = z2;
            z2 = x2;
            x2 = tmp;
            offset += 64;
        } while ((length -= 64) != 0);
        return Fingerprint2011.hash128to64(Fingerprint2011.hash128to64(v2[0], w2[0]) + Fingerprint2011.shiftMix(y2) * -8261664234251669945L + z2, Fingerprint2011.hash128to64(v2[1], w2[1]) + x2);
    }

    private static long hashLength33To64(byte[] bytes2, int offset, int length) {
        long z2 = LittleEndianByteArray.load64(bytes2, offset + 24);
        long a2 = LittleEndianByteArray.load64(bytes2, offset) + ((long)length + LittleEndianByteArray.load64(bytes2, offset + length - 16)) * -6505348102511208375L;
        long b2 = Long.rotateRight(a2 + z2, 52);
        long c2 = Long.rotateRight(a2, 37);
        long vf = (a2 += LittleEndianByteArray.load64(bytes2, offset + 16)) + z2;
        long vs = b2 + Long.rotateRight(a2, 31) + (c2 += Long.rotateRight(a2 += LittleEndianByteArray.load64(bytes2, offset + 8), 7));
        a2 = LittleEndianByteArray.load64(bytes2, offset + 16) + LittleEndianByteArray.load64(bytes2, offset + length - 32);
        z2 = LittleEndianByteArray.load64(bytes2, offset + length - 8);
        b2 = Long.rotateRight(a2 + z2, 52);
        c2 = Long.rotateRight(a2, 37);
        long wf = (a2 += LittleEndianByteArray.load64(bytes2, offset + length - 16)) + z2;
        long ws = b2 + Long.rotateRight(a2, 31) + (c2 += Long.rotateRight(a2 += LittleEndianByteArray.load64(bytes2, offset + length - 24), 7));
        long r2 = Fingerprint2011.shiftMix((vf + ws) * -4288712594273399085L + (wf + vs) * -6505348102511208375L);
        return Fingerprint2011.shiftMix(r2 * -6505348102511208375L + vs) * -4288712594273399085L;
    }

    @VisibleForTesting
    static long murmurHash64WithSeed(byte[] bytes2, int offset, int length, long seed) {
        long mul = -4132994306676758123L;
        int topBit = 7;
        int lengthAligned = length & ~topBit;
        int lengthRemainder = length & topBit;
        long hash = seed ^ (long)length * mul;
        for (int i2 = 0; i2 < lengthAligned; i2 += 8) {
            long loaded = LittleEndianByteArray.load64(bytes2, offset + i2);
            long data = Fingerprint2011.shiftMix(loaded * mul) * mul;
            hash ^= data;
            hash *= mul;
        }
        if (lengthRemainder != 0) {
            long data = LittleEndianByteArray.load64Safely(bytes2, offset + lengthAligned, lengthRemainder);
            hash ^= data;
            hash *= mul;
        }
        hash = Fingerprint2011.shiftMix(hash) * mul;
        hash = Fingerprint2011.shiftMix(hash);
        return hash;
    }
}

