/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class Booleans {
    private Booleans() {
    }

    public static Comparator<Boolean> trueFirst() {
        return BooleanComparator.TRUE_FIRST;
    }

    public static Comparator<Boolean> falseFirst() {
        return BooleanComparator.FALSE_FIRST;
    }

    public static int hashCode(boolean value) {
        return value ? 1231 : 1237;
    }

    public static int compare(boolean a2, boolean b2) {
        return a2 == b2 ? 0 : (a2 ? 1 : -1);
    }

    public static boolean contains(boolean[] array2, boolean target) {
        for (boolean value : array2) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(boolean[] array2, boolean target) {
        return Booleans.indexOf(array2, target, 0, array2.length);
    }

    private static int indexOf(boolean[] array2, boolean target, int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            if (array2[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(boolean[] array2, boolean[] target) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array2.length - target.length + 1; ++i2) {
            for (int j2 = 0; j2 < target.length; ++j2) {
                if (array2[i2 + j2] != target[j2]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array2, boolean target) {
        return Booleans.lastIndexOf(array2, target, 0, array2.length);
    }

    private static int lastIndexOf(boolean[] array2, boolean target, int start, int end) {
        for (int i2 = end - 1; i2 >= start; --i2) {
            if (array2[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static boolean[] concat(boolean[] ... arrays) {
        int length = 0;
        for (boolean[] array2 : arrays) {
            length += array2.length;
        }
        boolean[] result2 = new boolean[length];
        int pos = 0;
        for (boolean[] array3 : arrays) {
            System.arraycopy(array3, 0, result2, pos, array3.length);
            pos += array3.length;
        }
        return result2;
    }

    public static boolean[] ensureCapacity(boolean[] array2, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array2.length < minLength ? Arrays.copyOf(array2, minLength + padding) : array2;
    }

    public static String join(String separator, boolean ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 7);
        builder.append(array2[0]);
        for (int i2 = 1; i2 < array2.length; ++i2) {
            builder.append(separator).append(array2[i2]);
        }
        return builder.toString();
    }

    public static Comparator<boolean[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static boolean[] toArray(Collection<Boolean> collection) {
        if (collection instanceof BooleanArrayAsList) {
            return ((BooleanArrayAsList)collection).toBooleanArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        boolean[] array2 = new boolean[len];
        for (int i2 = 0; i2 < len; ++i2) {
            array2[i2] = (Boolean)Preconditions.checkNotNull(boxedArray[i2]);
        }
        return array2;
    }

    public static List<Boolean> asList(boolean ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new BooleanArrayAsList(backingArray);
    }

    public static int countTrue(boolean ... values2) {
        int count2 = 0;
        for (boolean value : values2) {
            if (!value) continue;
            ++count2;
        }
        return count2;
    }

    public static void reverse(boolean[] array2) {
        Preconditions.checkNotNull(array2);
        Booleans.reverse(array2, 0, array2.length);
    }

    public static void reverse(boolean[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i2 = fromIndex;
        for (int j2 = toIndex - 1; i2 < j2; ++i2, --j2) {
            boolean tmp = array2[i2];
            array2[i2] = array2[j2];
            array2[j2] = tmp;
        }
    }

    public static void rotate(boolean[] array2, int distance) {
        Booleans.rotate(array2, distance, 0, array2.length);
    }

    public static void rotate(boolean[] array2, int distance, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        if (array2.length <= 1) {
            return;
        }
        int length = toIndex - fromIndex;
        int m4 = -distance % length;
        m4 = m4 < 0 ? m4 + length : m4;
        int newFirstIndex = m4 + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Booleans.reverse(array2, fromIndex, newFirstIndex);
        Booleans.reverse(array2, newFirstIndex, toIndex);
        Booleans.reverse(array2, fromIndex, toIndex);
    }

    @GwtCompatible
    private static class BooleanArrayAsList
    extends AbstractList<Boolean>
    implements RandomAccess,
    Serializable {
        final boolean[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        BooleanArrayAsList(boolean[] array2) {
            this(array2, 0, array2.length);
        }

        BooleanArrayAsList(boolean[] array2, int start, int end) {
            this.array = array2;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Boolean get(int index2) {
            Preconditions.checkElementIndex(index2, this.size());
            return this.array[this.start + index2];
        }

        @Override
        public boolean contains(@CheckForNull Object target) {
            return target instanceof Boolean && Booleans.indexOf(this.array, (Boolean)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(@CheckForNull Object target) {
            int i2;
            if (target instanceof Boolean && (i2 = Booleans.indexOf(this.array, (Boolean)target, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@CheckForNull Object target) {
            int i2;
            if (target instanceof Boolean && (i2 = Booleans.lastIndexOf(this.array, (Boolean)target, this.start, this.end)) >= 0) {
                return i2 - this.start;
            }
            return -1;
        }

        @Override
        public Boolean set(int index2, Boolean element) {
            Preconditions.checkElementIndex(index2, this.size());
            boolean oldValue = this.array[this.start + index2];
            this.array[this.start + index2] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Boolean> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new BooleanArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof BooleanArrayAsList) {
                BooleanArrayAsList that = (BooleanArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i2 = 0; i2 < size; ++i2) {
                    if (this.array[this.start + i2] == that.array[that.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                result2 = 31 * result2 + Booleans.hashCode(this.array[i2]);
            }
            return result2;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 7);
            builder.append(this.array[this.start] ? "[true" : "[false");
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                builder.append(this.array[i2] ? ", true" : ", false");
            }
            return builder.append(']').toString();
        }

        boolean[] toBooleanArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<boolean[]>
    {
        INSTANCE;


        @Override
        public int compare(boolean[] left, boolean[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < minLength; ++i2) {
                int result2 = Booleans.compare(left[i2], right[i2]);
                if (result2 == 0) continue;
                return result2;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "Booleans.lexicographicalComparator()";
        }
    }

    private static enum BooleanComparator implements Comparator<Boolean>
    {
        TRUE_FIRST(1, "Booleans.trueFirst()"),
        FALSE_FIRST(-1, "Booleans.falseFirst()");

        private final int trueValue;
        private final String toString;

        private BooleanComparator(int trueValue, String toString2) {
            this.trueValue = trueValue;
            this.toString = toString2;
        }

        @Override
        public int compare(Boolean a2, Boolean b2) {
            int aVal = a2 != false ? this.trueValue : 0;
            int bVal = b2 != false ? this.trueValue : 0;
            return bVal - aVal;
        }

        public String toString() {
            return this.toString;
        }
    }
}

