/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Longs;
import com.google.common.primitives.ParseRequest;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class UnsignedLongs {
    public static final long MAX_VALUE = -1L;

    private UnsignedLongs() {
    }

    private static long flip(long a2) {
        return a2 ^ Long.MIN_VALUE;
    }

    public static int compare(long a2, long b2) {
        return Longs.compare(UnsignedLongs.flip(a2), UnsignedLongs.flip(b2));
    }

    public static long min(long ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        long min2 = UnsignedLongs.flip(array2[0]);
        for (int i2 = 1; i2 < array2.length; ++i2) {
            long next = UnsignedLongs.flip(array2[i2]);
            if (next >= min2) continue;
            min2 = next;
        }
        return UnsignedLongs.flip(min2);
    }

    public static long max(long ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        long max = UnsignedLongs.flip(array2[0]);
        for (int i2 = 1; i2 < array2.length; ++i2) {
            long next = UnsignedLongs.flip(array2[i2]);
            if (next <= max) continue;
            max = next;
        }
        return UnsignedLongs.flip(max);
    }

    public static String join(String separator, long ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 5);
        builder.append(UnsignedLongs.toString(array2[0]));
        for (int i2 = 1; i2 < array2.length; ++i2) {
            builder.append(separator).append(UnsignedLongs.toString(array2[i2]));
        }
        return builder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(long[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedLongs.sort(array2, 0, array2.length);
    }

    public static void sort(long[] array2, int fromIndex, int toIndex) {
        int i2;
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        for (i2 = fromIndex; i2 < toIndex; ++i2) {
            array2[i2] = UnsignedLongs.flip(array2[i2]);
        }
        Arrays.sort(array2, fromIndex, toIndex);
        for (i2 = fromIndex; i2 < toIndex; ++i2) {
            array2[i2] = UnsignedLongs.flip(array2[i2]);
        }
    }

    public static void sortDescending(long[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedLongs.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(long[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i2 = fromIndex;
        while (i2 < toIndex) {
            int n2 = i2++;
            array2[n2] = array2[n2] ^ Long.MAX_VALUE;
        }
        Arrays.sort(array2, fromIndex, toIndex);
        i2 = fromIndex;
        while (i2 < toIndex) {
            int n3 = i2++;
            array2[n3] = array2[n3] ^ Long.MAX_VALUE;
        }
    }

    public static long divide(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(UnsignedLongs.compare(rem, divisor) >= 0 ? 1 : 0);
    }

    public static long remainder(long dividend, long divisor) {
        long rem;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return dividend;
            }
            return dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem - (UnsignedLongs.compare(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
    }

    @CanIgnoreReturnValue
    public static long parseUnsignedLong(String string2) {
        return UnsignedLongs.parseUnsignedLong(string2, 10);
    }

    @CanIgnoreReturnValue
    public static long parseUnsignedLong(String string2, int radix) {
        Preconditions.checkNotNull(string2);
        if (string2.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("illegal radix: " + radix);
        }
        int maxSafePos = ParseOverflowDetection.maxSafeDigits[radix] - 1;
        long value = 0L;
        for (int pos = 0; pos < string2.length(); ++pos) {
            int digit = Character.digit(string2.charAt(pos), radix);
            if (digit == -1) {
                throw new NumberFormatException(string2);
            }
            if (pos > maxSafePos && ParseOverflowDetection.overflowInParse(value, digit, radix)) {
                throw new NumberFormatException("Too large for unsigned long: " + string2);
            }
            value = value * (long)radix + (long)digit;
        }
        return value;
    }

    @CanIgnoreReturnValue
    public static long decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedLongs.parseUnsignedLong(request.rawValue, request.radix);
        }
        catch (NumberFormatException e2) {
            NumberFormatException decodeException = new NumberFormatException("Error parsing value: " + stringValue);
            decodeException.initCause(e2);
            throw decodeException;
        }
    }

    public static String toString(long x2) {
        return UnsignedLongs.toString(x2, 10);
    }

    public static String toString(long x2, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        if (x2 == 0L) {
            return "0";
        }
        if (x2 > 0L) {
            return Long.toString(x2, radix);
        }
        char[] buf = new char[64];
        int i2 = buf.length;
        if ((radix & radix - 1) == 0) {
            int shift = Integer.numberOfTrailingZeros(radix);
            int mask = radix - 1;
            do {
                buf[--i2] = Character.forDigit((int)x2 & mask, radix);
            } while ((x2 >>>= shift) != 0L);
        } else {
            long quotient = (radix & 1) == 0 ? (x2 >>> 1) / (long)(radix >>> 1) : UnsignedLongs.divide(x2, radix);
            long rem = x2 - quotient * (long)radix;
            buf[--i2] = Character.forDigit((int)rem, radix);
            for (x2 = quotient; x2 > 0L; x2 /= (long)radix) {
                buf[--i2] = Character.forDigit((int)(x2 % (long)radix), radix);
            }
        }
        return new String(buf, i2, buf.length - i2);
    }

    private static final class ParseOverflowDetection {
        static final long[] maxValueDivs = new long[37];
        static final int[] maxValueMods = new int[37];
        static final int[] maxSafeDigits = new int[37];

        private ParseOverflowDetection() {
        }

        static boolean overflowInParse(long current2, int digit, int radix) {
            if (current2 >= 0L) {
                if (current2 < maxValueDivs[radix]) {
                    return false;
                }
                if (current2 > maxValueDivs[radix]) {
                    return true;
                }
                return digit > maxValueMods[radix];
            }
            return true;
        }

        static {
            BigInteger overflow = new BigInteger("10000000000000000", 16);
            for (int i2 = 2; i2 <= 36; ++i2) {
                ParseOverflowDetection.maxValueDivs[i2] = UnsignedLongs.divide(-1L, i2);
                ParseOverflowDetection.maxValueMods[i2] = (int)UnsignedLongs.remainder(-1L, i2);
                ParseOverflowDetection.maxSafeDigits[i2] = overflow.toString(i2).length() - 1;
            }
        }
    }

    static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left, long[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < minLength; ++i2) {
                if (left[i2] == right[i2]) continue;
                return UnsignedLongs.compare(left[i2], right[i2]);
            }
            return left.length - right.length;
        }

        public String toString() {
            return "UnsignedLongs.lexicographicalComparator()";
        }
    }
}

