/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import com.google.devrel.gmscore.tools.apk.arsc.SerializableResource;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class BinaryResourceConfiguration
implements SerializableResource {
    private final int size;
    private final int mcc;
    private final int mnc;
    private final byte[] language;
    private final byte[] region;
    private final int orientation;
    private final int touchscreen;
    private final int density;
    private final int keyboard;
    private final int navigation;
    private final int inputFlags;
    private final int screenWidth;
    private final int screenHeight;
    private final int sdkVersion;
    private final int minorVersion;
    private final int screenLayout;
    private final int uiMode;
    private final int smallestScreenWidthDp;
    private final int screenWidthDp;
    private final int screenHeightDp;
    private final byte[] localeScript;
    private final byte[] localeVariant;
    private final int screenLayout2;
    private final byte[] unknown;
    private static final int DENSITY_DPI_UNDEFINED = 0;
    private static final int DENSITY_DPI_LDPI = 120;
    private static final int DENSITY_DPI_MDPI = 160;
    private static final int DENSITY_DPI_TVDPI = 213;
    private static final int DENSITY_DPI_HDPI = 240;
    private static final int DENSITY_DPI_XHDPI = 320;
    private static final int DENSITY_DPI_XXHDPI = 480;
    private static final int DENSITY_DPI_XXXHDPI = 640;
    private static final int DENSITY_DPI_ANY = 65534;
    private static final int DENSITY_DPI_NONE = 65535;
    private static final Map<Integer, String> DENSITY_DPI_VALUES = ImmutableMap.builder().put(0, "").put(120, "ldpi").put(160, "mdpi").put(213, "tvdpi").put(240, "hdpi").put(320, "xhdpi").put(480, "xxhdpi").put(640, "xxxhdpi").put(65534, "anydpi").put(65535, "nodpi").build();
    private static final int KEYBOARD_NOKEYS = 1;
    private static final int KEYBOARD_QWERTY = 2;
    private static final int KEYBOARD_12KEY = 3;
    private static final Map<Integer, String> KEYBOARD_VALUES = ImmutableMap.of(1, "nokeys", 2, "qwerty", 3, "12key");
    private static final int KEYBOARDHIDDEN_MASK = 3;
    private static final int KEYBOARDHIDDEN_NO = 1;
    private static final int KEYBOARDHIDDEN_YES = 2;
    private static final int KEYBOARDHIDDEN_SOFT = 3;
    private static final Map<Integer, String> KEYBOARDHIDDEN_VALUES = ImmutableMap.of(1, "keysexposed", 2, "keyshidden", 3, "keyssoft");
    private static final int NAVIGATION_NONAV = 1;
    private static final int NAVIGATION_DPAD = 2;
    private static final int NAVIGATION_TRACKBALL = 3;
    private static final int NAVIGATION_WHEEL = 4;
    private static final Map<Integer, String> NAVIGATION_VALUES = ImmutableMap.of(1, "nonav", 2, "dpad", 3, "trackball", 4, "wheel");
    private static final int NAVIGATIONHIDDEN_MASK = 12;
    private static final int NAVIGATIONHIDDEN_NO = 4;
    private static final int NAVIGATIONHIDDEN_YES = 8;
    private static final Map<Integer, String> NAVIGATIONHIDDEN_VALUES = ImmutableMap.of(4, "navexposed", 8, "navhidden");
    private static final int ORIENTATION_PORTRAIT = 1;
    private static final int ORIENTATION_LANDSCAPE = 2;
    private static final Map<Integer, String> ORIENTATION_VALUES = ImmutableMap.of(1, "port", 2, "land");
    private static final int SCREENLAYOUT_LAYOUTDIR_MASK = 192;
    private static final int SCREENLAYOUT_LAYOUTDIR_LTR = 64;
    private static final int SCREENLAYOUT_LAYOUTDIR_RTL = 128;
    private static final Map<Integer, String> SCREENLAYOUT_LAYOUTDIR_VALUES = ImmutableMap.of(64, "ldltr", 128, "ldrtl");
    private static final int SCREENLAYOUT_LONG_MASK = 48;
    private static final int SCREENLAYOUT_LONG_NO = 16;
    private static final int SCREENLAYOUT_LONG_YES = 32;
    private static final Map<Integer, String> SCREENLAYOUT_LONG_VALUES = ImmutableMap.of(16, "notlong", 32, "long");
    private static final int SCREENLAYOUT_ROUND_MASK = 3;
    private static final int SCREENLAYOUT_ROUND_NO = 1;
    private static final int SCREENLAYOUT_ROUND_YES = 2;
    private static final Map<Integer, String> SCREENLAYOUT_ROUND_VALUES = ImmutableMap.of(1, "notround", 2, "round");
    private static final int SCREENLAYOUT_SIZE_MASK = 15;
    private static final int SCREENLAYOUT_SIZE_SMALL = 1;
    private static final int SCREENLAYOUT_SIZE_NORMAL = 2;
    private static final int SCREENLAYOUT_SIZE_LARGE = 3;
    private static final int SCREENLAYOUT_SIZE_XLARGE = 4;
    private static final Map<Integer, String> SCREENLAYOUT_SIZE_VALUES = ImmutableMap.of(1, "small", 2, "normal", 3, "large", 4, "xlarge");
    private static final int TOUCHSCREEN_NOTOUCH = 1;
    private static final int TOUCHSCREEN_FINGER = 3;
    private static final Map<Integer, String> TOUCHSCREEN_VALUES = ImmutableMap.of(1, "notouch", 3, "finger");
    private static final int UI_MODE_NIGHT_MASK = 48;
    private static final int UI_MODE_NIGHT_NO = 16;
    private static final int UI_MODE_NIGHT_YES = 32;
    private static final Map<Integer, String> UI_MODE_NIGHT_VALUES = ImmutableMap.of(16, "notnight", 32, "night");
    private static final int UI_MODE_TYPE_MASK = 15;
    private static final int UI_MODE_TYPE_DESK = 2;
    private static final int UI_MODE_TYPE_CAR = 3;
    private static final int UI_MODE_TYPE_TELEVISION = 4;
    private static final int UI_MODE_TYPE_APPLIANCE = 5;
    private static final int UI_MODE_TYPE_WATCH = 6;
    private static final Map<Integer, String> UI_MODE_TYPE_VALUES = ImmutableMap.of(2, "desk", 3, "car", 4, "television", 5, "appliance", 6, "watch");
    private static final int SCREEN_CONFIG_MIN_SIZE = 32;
    private static final int SCREEN_DP_MIN_SIZE = 36;
    private static final int LOCALE_MIN_SIZE = 48;
    private static final int SCREEN_CONFIG_EXTENSION_MIN_SIZE = 52;

    static BinaryResourceConfiguration create(ByteBuffer buffer) {
        int startPosition = buffer.position();
        int size = buffer.getInt();
        int mcc = buffer.getShort() & 0xFFFF;
        int mnc = buffer.getShort() & 0xFFFF;
        byte[] language = new byte[2];
        buffer.get(language);
        byte[] region = new byte[2];
        buffer.get(region);
        int orientation = UnsignedBytes.toInt(buffer.get());
        int touchscreen = UnsignedBytes.toInt(buffer.get());
        int density = buffer.getShort() & 0xFFFF;
        int keyboard = UnsignedBytes.toInt(buffer.get());
        int navigation = UnsignedBytes.toInt(buffer.get());
        int inputFlags = UnsignedBytes.toInt(buffer.get());
        buffer.get();
        int screenWidth = buffer.getShort() & 0xFFFF;
        int screenHeight = buffer.getShort() & 0xFFFF;
        int sdkVersion = buffer.getShort() & 0xFFFF;
        int minorVersion = buffer.getShort() & 0xFFFF;
        int screenLayout = 0;
        int uiMode = 0;
        int smallestScreenWidthDp = 0;
        int screenWidthDp = 0;
        int screenHeightDp = 0;
        byte[] localeScript = new byte[4];
        byte[] localeVariant = new byte[8];
        int screenLayout2 = 0;
        if (size >= 32) {
            screenLayout = UnsignedBytes.toInt(buffer.get());
            uiMode = UnsignedBytes.toInt(buffer.get());
            smallestScreenWidthDp = buffer.getShort() & 0xFFFF;
        }
        if (size >= 36) {
            screenWidthDp = buffer.getShort() & 0xFFFF;
            screenHeightDp = buffer.getShort() & 0xFFFF;
        }
        if (size >= 48) {
            buffer.get(localeScript);
            buffer.get(localeVariant);
        }
        if (size >= 52) {
            screenLayout2 = UnsignedBytes.toInt(buffer.get());
            buffer.get();
            buffer.getShort();
        }
        int bytesRead = buffer.position() - startPosition;
        byte[] unknown = new byte[size - bytesRead];
        buffer.get(unknown);
        return new BinaryResourceConfiguration(size, mcc, mnc, language, region, orientation, touchscreen, density, keyboard, navigation, inputFlags, screenWidth, screenHeight, sdkVersion, minorVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, localeScript, localeVariant, screenLayout2, unknown);
    }

    private BinaryResourceConfiguration(int size, int mcc, int mnc, byte[] language, byte[] region, int orientation, int touchscreen, int density, int keyboard, int navigation, int inputFlags, int screenWidth, int screenHeight, int sdkVersion, int minorVersion, int screenLayout, int uiMode, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, byte[] localeScript, byte[] localeVariant, int screenLayout2, byte[] unknown) {
        this.size = size;
        this.mcc = mcc;
        this.mnc = mnc;
        this.language = language;
        this.region = region;
        this.orientation = orientation;
        this.touchscreen = touchscreen;
        this.density = density;
        this.keyboard = keyboard;
        this.navigation = navigation;
        this.inputFlags = inputFlags;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.sdkVersion = sdkVersion;
        this.minorVersion = minorVersion;
        this.screenLayout = screenLayout;
        this.uiMode = uiMode;
        this.smallestScreenWidthDp = smallestScreenWidthDp;
        this.screenWidthDp = screenWidthDp;
        this.screenHeightDp = screenHeightDp;
        this.localeScript = localeScript;
        this.localeVariant = localeVariant;
        this.screenLayout2 = screenLayout2;
        this.unknown = unknown;
    }

    public int size() {
        return this.size;
    }

    public int mcc() {
        return this.mcc;
    }

    public int mnc() {
        return this.mnc;
    }

    public byte[] language() {
        return this.language;
    }

    private String localeString() {
        boolean scriptWasProvided;
        String language = this.unpackLanguage();
        if (language.isEmpty()) {
            return language;
        }
        String region = this.unpackRegion();
        boolean bl2 = scriptWasProvided = this.localeScript[0] != 0;
        if (!scriptWasProvided && this.localeVariant[0] == 0) {
            if (region.isEmpty()) {
                return language;
            }
            return language + "-r" + region;
        }
        String locale = "b+" + language;
        if (scriptWasProvided) {
            locale = locale + "+" + new String(this.localeScript, StandardCharsets.US_ASCII);
        }
        if (!region.isEmpty()) {
            locale = locale + "+" + region;
        }
        if (this.localeVariant[0] != 0) {
            locale = locale + "+" + new String(this.localeVariant, StandardCharsets.US_ASCII);
        }
        return locale;
    }

    public byte[] region() {
        return this.region;
    }

    public final String regionString() {
        return this.unpackRegion();
    }

    public int orientation() {
        return this.orientation;
    }

    public int touchscreen() {
        return this.touchscreen;
    }

    public int density() {
        return this.density;
    }

    public int keyboard() {
        return this.keyboard;
    }

    public int navigation() {
        return this.navigation;
    }

    public int inputFlags() {
        return this.inputFlags;
    }

    public final int keyboardHidden() {
        return this.inputFlags() & 3;
    }

    public final int navigationHidden() {
        return this.inputFlags() & 0xC;
    }

    public int screenWidth() {
        return this.screenWidth;
    }

    public int screenHeight() {
        return this.screenHeight;
    }

    public int sdkVersion() {
        return this.sdkVersion;
    }

    public final BinaryResourceConfiguration withSdkVersion(int sdkVersion) {
        if (sdkVersion == this.sdkVersion()) {
            return this;
        }
        return new BinaryResourceConfiguration(this.size(), this.mcc(), this.mnc(), this.language(), this.region(), this.orientation(), this.touchscreen(), this.density(), this.keyboard(), this.navigation(), this.inputFlags(), this.screenWidth(), this.screenHeight(), sdkVersion, this.minorVersion(), this.screenLayout(), this.uiMode(), this.smallestScreenWidthDp(), this.screenWidthDp(), this.screenHeightDp(), this.localeScript(), this.localeVariant(), this.screenLayout2(), this.unknown());
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public int screenLayout() {
        return this.screenLayout;
    }

    public final int screenLayoutDirection() {
        return this.screenLayout() & 0xC0;
    }

    public final int screenLayoutSize() {
        return this.screenLayout() & 0xF;
    }

    public final int screenLayoutLong() {
        return this.screenLayout() & 0x30;
    }

    public final int screenLayoutRound() {
        return this.screenLayout2() & 3;
    }

    public int uiMode() {
        return this.uiMode;
    }

    public final int uiModeType() {
        return this.uiMode() & 0xF;
    }

    public final int uiModeNight() {
        return this.uiMode() & 0x30;
    }

    public int smallestScreenWidthDp() {
        return this.smallestScreenWidthDp;
    }

    public int screenWidthDp() {
        return this.screenWidthDp;
    }

    public int screenHeightDp() {
        return this.screenHeightDp;
    }

    public byte[] localeScript() {
        return this.localeScript;
    }

    public byte[] localeVariant() {
        return this.localeVariant;
    }

    public int screenLayout2() {
        return this.screenLayout2;
    }

    public byte[] unknown() {
        return this.unknown;
    }

    private String unpackLanguage() {
        return this.unpackLanguageOrRegion(this.language(), 97);
    }

    private String unpackRegion() {
        return this.unpackLanguageOrRegion(this.region(), 48);
    }

    private String unpackLanguageOrRegion(byte[] value, int base) {
        Preconditions.checkState(value.length == 2, "Language or region value must be 2 bytes.");
        if (value[0] == 0 && value[1] == 0) {
            return "";
        }
        if ((UnsignedBytes.toInt(value[0]) & 0x80) != 0) {
            byte[] result2 = new byte[]{(byte)(base + (value[1] & 0x1F)), (byte)(base + ((value[1] & 0xE0) >>> 5) + ((value[0] & 3) << 3)), (byte)(base + ((value[0] & 0x7C) >>> 2))};
            return new String(result2, StandardCharsets.US_ASCII);
        }
        return new String(value, StandardCharsets.US_ASCII);
    }

    public final boolean isDefault() {
        return this.mcc() == 0 && this.mnc() == 0 && Arrays.equals(this.language(), new byte[2]) && Arrays.equals(this.region(), new byte[2]) && this.orientation() == 0 && this.touchscreen() == 0 && this.density() == 0 && this.keyboard() == 0 && this.navigation() == 0 && this.inputFlags() == 0 && this.screenWidth() == 0 && this.screenHeight() == 0 && this.sdkVersion() == 0 && this.minorVersion() == 0 && this.screenLayout() == 0 && this.uiMode() == 0 && this.smallestScreenWidthDp() == 0 && this.screenWidthDp() == 0 && this.screenHeightDp() == 0 && Arrays.equals(this.localeScript(), new byte[4]) && Arrays.equals(this.localeVariant(), new byte[8]) && this.screenLayout2() == 0;
    }

    @Override
    public final byte[] toByteArray() {
        return this.toByteArray(false);
    }

    @Override
    public final byte[] toByteArray(boolean shrink) {
        ByteBuffer buffer = ByteBuffer.allocate(this.size()).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.size());
        buffer.putShort((short)this.mcc());
        buffer.putShort((short)this.mnc());
        buffer.put(this.language());
        buffer.put(this.region());
        buffer.put((byte)this.orientation());
        buffer.put((byte)this.touchscreen());
        buffer.putShort((short)this.density());
        buffer.put((byte)this.keyboard());
        buffer.put((byte)this.navigation());
        buffer.put((byte)this.inputFlags());
        buffer.put((byte)0);
        buffer.putShort((short)this.screenWidth());
        buffer.putShort((short)this.screenHeight());
        buffer.putShort((short)this.sdkVersion());
        buffer.putShort((short)this.minorVersion());
        if (this.size() >= 32) {
            buffer.put((byte)this.screenLayout());
            buffer.put((byte)this.uiMode());
            buffer.putShort((short)this.smallestScreenWidthDp());
        }
        if (this.size() >= 36) {
            buffer.putShort((short)this.screenWidthDp());
            buffer.putShort((short)this.screenHeightDp());
        }
        if (this.size() >= 48) {
            buffer.put(this.localeScript());
            buffer.put(this.localeVariant());
        }
        if (this.size() >= 52) {
            buffer.putInt(this.screenLayout2());
        }
        buffer.put(this.unknown());
        return buffer.array();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        BinaryResourceConfiguration that = (BinaryResourceConfiguration)o2;
        return this.size == that.size && this.mcc == that.mcc && this.mnc == that.mnc && this.orientation == that.orientation && this.touchscreen == that.touchscreen && this.density == that.density && this.keyboard == that.keyboard && this.navigation == that.navigation && this.inputFlags == that.inputFlags && this.screenWidth == that.screenWidth && this.screenHeight == that.screenHeight && this.sdkVersion == that.sdkVersion && this.minorVersion == that.minorVersion && this.screenLayout == that.screenLayout && this.uiMode == that.uiMode && this.smallestScreenWidthDp == that.smallestScreenWidthDp && this.screenWidthDp == that.screenWidthDp && this.screenHeightDp == that.screenHeightDp && this.screenLayout2 == that.screenLayout2 && Arrays.equals(this.language, that.language) && Arrays.equals(this.region, that.region) && Arrays.equals(this.localeScript, that.localeScript) && Arrays.equals(this.localeVariant, that.localeVariant) && Arrays.equals(this.unknown, that.unknown);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.mcc, this.mnc, Arrays.hashCode(this.language), Arrays.hashCode(this.region), this.orientation, this.touchscreen, this.density, this.keyboard, this.navigation, this.inputFlags, this.screenWidth, this.screenHeight, this.sdkVersion, this.minorVersion, this.screenLayout, this.uiMode, this.smallestScreenWidthDp, this.screenWidthDp, this.screenHeightDp, Arrays.hashCode(this.localeScript), Arrays.hashCode(this.localeVariant), this.screenLayout2, Arrays.hashCode(this.unknown));
    }

    public final String toString() {
        if (this.isDefault()) {
            return "default";
        }
        Collection<String> parts = this.toStringParts().values();
        parts.removeAll(Collections.singleton(""));
        return Joiner.on('-').join(parts);
    }

    public final Map<Type, String> toStringParts() {
        LinkedHashMap<Type, String> result2 = new LinkedHashMap<Type, String>();
        result2.put(Type.MCC, (String)(this.mcc() != 0 ? "mcc" + this.mcc() : ""));
        result2.put(Type.MNC, (String)(this.mnc() != 0 ? "mnc" + this.mnc() : ""));
        result2.put(Type.LOCALE_STRING, !this.localeString().isEmpty() ? this.localeString() : "");
        result2.put(Type.SCREEN_LAYOUT_DIRECTION, this.getOrDefault(SCREENLAYOUT_LAYOUTDIR_VALUES, this.screenLayoutDirection(), ""));
        result2.put(Type.SMALLEST_SCREEN_WIDTH_DP, (String)(this.smallestScreenWidthDp() != 0 ? "sw" + this.smallestScreenWidthDp() + "dp" : ""));
        result2.put(Type.SCREEN_WIDTH_DP, (String)(this.screenWidthDp() != 0 ? "w" + this.screenWidthDp() + "dp" : ""));
        result2.put(Type.SCREEN_HEIGHT_DP, (String)(this.screenHeightDp() != 0 ? "h" + this.screenHeightDp() + "dp" : ""));
        result2.put(Type.SCREEN_LAYOUT_SIZE, this.getOrDefault(SCREENLAYOUT_SIZE_VALUES, this.screenLayoutSize(), ""));
        result2.put(Type.SCREEN_LAYOUT_LONG, this.getOrDefault(SCREENLAYOUT_LONG_VALUES, this.screenLayoutLong(), ""));
        result2.put(Type.SCREEN_LAYOUT_ROUND, this.getOrDefault(SCREENLAYOUT_ROUND_VALUES, this.screenLayoutRound(), ""));
        result2.put(Type.ORIENTATION, this.getOrDefault(ORIENTATION_VALUES, this.orientation(), ""));
        result2.put(Type.UI_MODE_TYPE, this.getOrDefault(UI_MODE_TYPE_VALUES, this.uiModeType(), ""));
        result2.put(Type.UI_MODE_NIGHT, this.getOrDefault(UI_MODE_NIGHT_VALUES, this.uiModeNight(), ""));
        result2.put(Type.DENSITY_DPI, (String)((Object)this.getOrDefault(DENSITY_DPI_VALUES, this.density(), this.density() + "dpi")));
        result2.put(Type.TOUCHSCREEN, this.getOrDefault(TOUCHSCREEN_VALUES, this.touchscreen(), ""));
        result2.put(Type.KEYBOARD_HIDDEN, this.getOrDefault(KEYBOARDHIDDEN_VALUES, this.keyboardHidden(), ""));
        result2.put(Type.KEYBOARD, this.getOrDefault(KEYBOARD_VALUES, this.keyboard(), ""));
        result2.put(Type.NAVIGATION_HIDDEN, this.getOrDefault(NAVIGATIONHIDDEN_VALUES, this.navigationHidden(), ""));
        result2.put(Type.NAVIGATION, this.getOrDefault(NAVIGATION_VALUES, this.navigation(), ""));
        result2.put(Type.SDK_VERSION, (String)(this.sdkVersion() != 0 ? "v" + this.sdkVersion() : ""));
        return result2;
    }

    private <K, V> V getOrDefault(Map<K, V> map2, K key, V defaultValue) {
        V value = map2.get(key);
        return value != null ? value : defaultValue;
    }

    private static enum Type {
        MCC,
        MNC,
        LOCALE_STRING,
        SCREEN_LAYOUT_DIRECTION,
        SMALLEST_SCREEN_WIDTH_DP,
        SCREEN_WIDTH_DP,
        SCREEN_HEIGHT_DP,
        SCREEN_LAYOUT_SIZE,
        SCREEN_LAYOUT_LONG,
        SCREEN_LAYOUT_ROUND,
        ORIENTATION,
        UI_MODE_TYPE,
        UI_MODE_NIGHT,
        DENSITY_DPI,
        TOUCHSCREEN,
        KEYBOARD_HIDDEN,
        KEYBOARD,
        NAVIGATION_HIDDEN,
        NAVIGATION,
        SDK_VERSION;

    }
}

