/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class PackageUtils {
    public static final int PACKAGE_NAME_SIZE = 256;

    private PackageUtils() {
    }

    public static String readPackageName(ByteBuffer buffer, int offset) {
        byte[] data = buffer.array();
        int length = 0;
        for (int i2 = offset; i2 < data.length && i2 < 256 + offset; i2 += 2) {
            if (data[i2] != 0 || data[i2 + 1] != 0) continue;
            length = i2 - offset;
            break;
        }
        Charset utf16 = Charset.forName("UTF-16LE");
        String str = new String(data, offset, length, utf16);
        buffer.position(offset + 256);
        return str;
    }

    public static void writePackageName(ByteBuffer buffer, String packageName) {
        byte[] nameBytes = packageName.getBytes(Charset.forName("UTF-16LE"));
        buffer.put(nameBytes, 0, Math.min(nameBytes.length, 256));
        if (nameBytes.length < 256) {
            buffer.put(new byte[256 - nameBytes.length]);
        }
    }
}

