/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.AbstractBundle;
import com.intellij.BundleBase;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.DefaultBundleService;
import com.intellij.util.LocalizationUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicBundle
extends AbstractBundle {
    private static final Logger LOG = Logger.getInstance(DynamicBundle.class);
    @NotNull
    private static String ourLangTag = Locale.ENGLISH.toLanguageTag();
    public static final Map<String, ResourceBundle> bundles = new HashMap<String, ResourceBundle>();
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final DynamicBundle INSTANCE = new DynamicBundle(""){};
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourCache = CollectionFactory.createConcurrentWeakMap();
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourDefaultCache = CollectionFactory.createConcurrentWeakMap();

    public DynamicBundle(@NotNull Class<?> bundleClass, @NotNull String pathToBundle) {
        if (bundleClass == null) {
            DynamicBundle.$$$reportNull$$$0(0);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(1);
        }
        super(bundleClass, pathToBundle);
    }

    @ApiStatus.Obsolete
    protected DynamicBundle(@NotNull String pathToBundle) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(2);
        }
        super(pathToBundle);
    }

    @Override
    @NotNull
    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader baseLoader, @NotNull ResourceBundle.Control control) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(3);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$0(4);
        }
        if (control == null) {
            DynamicBundle.$$$reportNull$$$0(5);
        }
        return DynamicBundle.resolveResourceBundle(this.getBundleClassLoader(), baseLoader, (loader2, locale) -> super.findBundle(pathToBundle, (ClassLoader)loader2, control, (Locale)locale), pathToBundle, DynamicBundle.getLocale());
    }

    @NotNull
    private static ResourceBundle resolveResourceBundle(@NotNull ClassLoader bundleClassLoader, @NotNull ClassLoader baseLoader, @NotNull @NotNull BiFunction<? super @NotNull ClassLoader, Locale, ? extends @NotNull ResourceBundle> bundleResolver, @NotNull String defaultPath, @NotNull Locale locale) {
        if (bundleClassLoader == null) {
            DynamicBundle.$$$reportNull$$$0(6);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$0(7);
        }
        if (bundleResolver == null) {
            DynamicBundle.$$$reportNull$$$0(8);
        }
        if (defaultPath == null) {
            DynamicBundle.$$$reportNull$$$0(9);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(10);
        }
        Path bundlePath = FileSystems.getDefault().getPath(FileUtil.toCanonicalPath(defaultPath, '.'), new String[0]);
        ClassLoader pluginClassLoader = DynamicBundle.languagePluginClassLoader(bundleClassLoader, locale);
        List<Path> paths2 = LocalizationUtil.INSTANCE.getLocalizedPaths(bundlePath, locale);
        HashMap<BundleOrder, ResourceBundle> bundleOrderMap = new HashMap<BundleOrder, ResourceBundle>();
        if (pluginClassLoader != null) {
            DynamicBundle.resolveBundleOrder(pluginClassLoader, true, bundlePath, paths2, bundleOrderMap, bundleResolver, locale);
        }
        DynamicBundle.resolveBundleOrder(baseLoader, false, bundlePath, paths2, bundleOrderMap, bundleResolver, locale);
        DynamicBundle.reorderParents(bundleOrderMap);
        Optional resourceBundleEntry = bundleOrderMap.entrySet().stream().min(Map.Entry.comparingByKey());
        if (!resourceBundleEntry.isPresent()) {
            throw new RuntimeException("No such resource bundle: " + bundlePath);
        }
        ResourceBundle bundle = (ResourceBundle)resourceBundleEntry.get().getValue();
        bundles.put(defaultPath, bundle);
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(11);
        }
        return resourceBundle;
    }

    @ApiStatus.Internal
    private static List<ResourceBundle> getBundlesFromLocalizationFolder(Path pathToBundle, ClassLoader loader2, Locale locale) {
        List<Path> paths2 = LocalizationUtil.INSTANCE.getFolderLocalizedPaths(pathToBundle, locale);
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        for (Path path : paths2) {
            try {
                ResourceBundle resourceBundle = DynamicBundle.bundleResolver(FileUtil.toSystemIndependentName(path.toString())).apply(loader2, locale);
                resourceBundles.add(resourceBundle);
            }
            catch (MissingResourceException e2) {
                LOG.debug(e2);
            }
        }
        return resourceBundles;
    }

    @Nullable
    private static ClassLoader languagePluginClassLoader(@NotNull ClassLoader bundleClassLoader, @NotNull Locale locale) {
        if (bundleClassLoader == null) {
            DynamicBundle.$$$reportNull$$$0(12);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(13);
        }
        if (DefaultBundleService.isDefaultBundle()) {
            return null;
        }
        LanguageBundleEP langBundle = DynamicBundle.findLanguageBundle();
        if (langBundle == null) {
            return null;
        }
        if (!Objects.equals(locale.getLanguage(), DynamicBundle.getLocale().getLanguage()) || locale.getCountry() != null && !Objects.equals(locale.getCountry(), DynamicBundle.getLocale().getCountry())) {
            return null;
        }
        PluginDescriptor pluginDescriptor = langBundle.pluginDescriptor;
        return pluginDescriptor == null ? bundleClassLoader : pluginDescriptor.getClassLoader();
    }

    private static ResourceBundle getParent(ResourceBundle bundle) throws Throwable {
        if (DynamicBundleInternal.GET_PARENT != null) {
            return (ResourceBundle)DynamicBundleInternal.GET_PARENT.invokeWithArguments(bundle);
        }
        return null;
    }

    private static void resolveBundleOrder(ClassLoader loader2, Boolean isPluginClassLoader, Path pathToBundle, List<Path> orderedPaths, Map<BundleOrder, ResourceBundle> bundleOrderMap, @NotNull @NotNull BiFunction<? super @NotNull ClassLoader, Locale, ? extends @NotNull ResourceBundle> bundleResolver, @NotNull Locale locale) {
        if (bundleResolver == null) {
            DynamicBundle.$$$reportNull$$$0(14);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(15);
        }
        ResourceBundle bundle = bundleResolver.apply(loader2, locale);
        try {
            while (bundle != null) {
                DynamicBundle.putBundleOrder(bundle, bundleOrderMap, orderedPaths, isPluginClassLoader);
                bundle = DynamicBundle.getParent(bundle);
            }
        }
        catch (Throwable throwable) {
            LOG.info(throwable);
        }
        for (ResourceBundle localizedBundle : DynamicBundle.getBundlesFromLocalizationFolder(pathToBundle, loader2, locale)) {
            DynamicBundle.putBundleOrder(localizedBundle, bundleOrderMap, orderedPaths, isPluginClassLoader);
        }
    }

    private static void putBundleOrder(ResourceBundle bundle, Map<BundleOrder, ResourceBundle> bundleOrderMap, List<Path> orderedPaths, Boolean isPluginClassLoader) {
        Path path;
        BundleOrder bundleOrder;
        String bundlePath = FileUtil.toCanonicalPath(bundle.getBaseBundleName(), '.');
        if (!bundle.getLocale().toString().isEmpty()) {
            bundlePath = bundlePath + "_" + bundle.getLocale().toString();
        }
        if ((bundleOrder = BundleOrder.getBundleOrder(orderedPaths, path = FileSystems.getDefault().getPath(bundlePath, new String[0]), isPluginClassLoader)) == null) {
            LOG.debug("Order cannot be defined for the bundle: " + path + "; Current locale: " + DynamicBundle.getLocale() + "; Paths for locale: " + orderedPaths);
            return;
        }
        bundleOrderMap.put(bundleOrder, bundle);
    }

    private static void reorderParents(Map<BundleOrder, ResourceBundle> bundleOrderMap) {
        ResourceBundle resourceBundle = null;
        for (BundleOrder bundleOrder : BundleOrder.values()) {
            ResourceBundle parentBundle = bundleOrderMap.get((Object)bundleOrder);
            if (parentBundle == null || parentBundle == resourceBundle) continue;
            if (resourceBundle != null && DynamicBundleInternal.SET_PARENT != null) {
                try {
                    DynamicBundleInternal.SET_PARENT.bindTo(resourceBundle).invoke(parentBundle);
                }
                catch (Throwable e2) {
                    LOG.warn(e2);
                }
            }
            resourceBundle = parentBundle;
        }
    }

    @Nullable
    public static LanguageBundleEP findLanguageBundle() {
        try {
            if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
                return null;
            }
            Application app = ApplicationManager.getApplication();
            if (app == null || !app.getExtensionArea().hasExtensionPoint(LanguageBundleEP.EP_NAME)) {
                return null;
            }
            return LanguageBundleEP.EP_NAME.findExtension(LanguageBundleEP.class);
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (Exception e3) {
            LOG.error(e3);
            return null;
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public final ResourceBundle getResourceBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader2) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(16);
        }
        if (loader2 == null) {
            DynamicBundle.$$$reportNull$$$0(17);
        }
        return DynamicBundle.getResourceBundle(loader2, pathToBundle);
    }

    @NotNull
    public static ResourceBundle getResourceBundle(@NotNull ClassLoader loader2, @NotNull @NonNls String pathToBundle) {
        if (loader2 == null) {
            DynamicBundle.$$$reportNull$$$0(18);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(19);
        }
        ResourceBundle resourceBundle = (DefaultBundleService.isDefaultBundle() ? ourDefaultCache : ourCache).computeIfAbsent(loader2, __ -> CollectionFactory.createConcurrentSoftValueMap()).computeIfAbsent(pathToBundle, __ -> DynamicBundle.resolveResourceBundle(loader2, pathToBundle));
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(20);
        }
        return resourceBundle;
    }

    @NotNull
    public static ResourceBundle getResourceBundle(@NotNull ClassLoader loader2, @NotNull @NonNls String pathToBundle, @NotNull Locale locale) {
        if (loader2 == null) {
            DynamicBundle.$$$reportNull$$$0(21);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(22);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(23);
        }
        ResourceBundle resourceBundle = (DefaultBundleService.isDefaultBundle() ? ourDefaultCache : ourCache).computeIfAbsent(loader2, __ -> CollectionFactory.createConcurrentSoftValueMap()).computeIfAbsent(pathToBundle, __ -> DynamicBundle.resolveResourceBundle(loader2, pathToBundle, locale));
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(24);
        }
        return resourceBundle;
    }

    @Nullable
    public static ResourceBundle getPluginBundle(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            DynamicBundle.$$$reportNull$$$0(25);
        }
        ClassLoader classLoader2 = pluginDescriptor.getPluginClassLoader();
        String baseName = pluginDescriptor.getResourceBundleBaseName();
        return classLoader2 != null && baseName != null ? DynamicBundle.getResourceBundle(classLoader2, baseName) : null;
    }

    @NotNull
    private static ResourceBundle resolveResourceBundle(@NotNull ClassLoader loader2, @NonNls @NotNull String pathToBundle) {
        if (loader2 == null) {
            DynamicBundle.$$$reportNull$$$0(26);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(27);
        }
        ResourceBundle resourceBundle = DynamicBundle.resolveResourceBundleWithFallback(() -> DynamicBundle.resolveResourceBundle(DynamicBundle.class.getClassLoader(), loader2, DynamicBundle.bundleResolver(pathToBundle), pathToBundle, DynamicBundle.getLocale()), loader2, pathToBundle);
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(28);
        }
        return resourceBundle;
    }

    @NotNull
    private static ResourceBundle resolveResourceBundle(@NotNull ClassLoader loader2, @NonNls @NotNull String pathToBundle, @NotNull Locale locale) {
        if (loader2 == null) {
            DynamicBundle.$$$reportNull$$$0(29);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(30);
        }
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(31);
        }
        ResourceBundle resourceBundle = DynamicBundle.resolveResourceBundleWithFallback(() -> DynamicBundle.resolveResourceBundle(DynamicBundle.class.getClassLoader(), loader2, DynamicBundle.bundleResolver(pathToBundle), pathToBundle, locale), loader2, pathToBundle);
        if (resourceBundle == null) {
            DynamicBundle.$$$reportNull$$$0(32);
        }
        return resourceBundle;
    }

    @NotNull
    private static @NotNull BiFunction<@NotNull ClassLoader, @NotNull Locale, @NotNull ResourceBundle> bundleResolver(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(33);
        }
        BiFunction<ClassLoader, Locale, ResourceBundle> biFunction = (loader2, locale) -> DynamicBundle.resolveBundle(loader2, locale, pathToBundle);
        if (biFunction == null) {
            DynamicBundle.$$$reportNull$$$0(34);
        }
        return biFunction;
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName) {
        Class<?> callerClass;
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$0(35);
        }
        return DynamicBundle.getBundle(baseName, (callerClass = ReflectionUtil.findCallerClass(2)) == null ? DynamicBundle.class : callerClass);
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName, @NotNull Class<?> formClass) {
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$0(36);
        }
        if (formClass == null) {
            DynamicBundle.$$$reportNull$$$0(37);
        }
        final ResourceBundle rb = DynamicBundle.getResourceBundle(formClass.getClassLoader(), baseName);
        if (!BundleBase.SHOW_LOCALIZED_MESSAGES) {
            return rb;
        }
        return new ResourceBundle(){

            @Override
            protected Object handleGetObject(@NotNull String key) {
                if (key == null) {
                    2.$$$reportNull$$$0(0);
                }
                Object get2 = rb.getObject(key);
                assert (get2 instanceof String) : "Language bundles should contain only strings";
                return BundleBase.appendLocalizationSuffix((String)get2, "\ud83d\udd05");
            }

            @Override
            @NotNull
            public Enumeration<String> getKeys() {
                Enumeration<String> enumeration = rb.getKeys();
                if (enumeration == null) {
                    2.$$$reportNull$$$0(1);
                }
                return enumeration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string2;
                switch (n2) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/DynamicBundle$2";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/DynamicBundle$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeys";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handleGetObject";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static void loadLocale(@Nullable LanguageBundleEP langBundle) {
        if (langBundle != null) {
            ourLangTag = langBundle.locale;
            ourCache.clear();
        }
    }

    @NotNull
    public static Locale getLocale() {
        Locale locale = Locale.forLanguageTag(ourLangTag);
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(38);
        }
        return locale;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 38: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 38: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLoader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClassLoader";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleResolver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPath";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 11: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/DynamicBundle";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/DynamicBundle";
                break;
            }
            case 11: 
            case 28: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveResourceBundle";
                break;
            }
            case 20: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "bundleResolver";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBundle";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveResourceBundle";
                break;
            }
            case 11: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 38: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "languagePluginClassLoader";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveBundleOrder";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundle";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPluginBundle";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "bundleResolver";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getBundle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 34: 
            case 38: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static final class LanguageBundleEP
    implements PluginAware {
        public static final ExtensionPointName<LanguageBundleEP> EP_NAME = new ExtensionPointName("com.intellij.languageBundle");
        @Attribute(value="locale")
        public String locale = Locale.ENGLISH.getLanguage();
        public PluginDescriptor pluginDescriptor;

        @Override
        public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                LanguageBundleEP.$$$reportNull$$$0(0);
            }
            this.pluginDescriptor = pluginDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/DynamicBundle$LanguageBundleEP", "setPluginDescriptor"));
        }
    }

    private static class DynamicBundleInternal {
        private static final MethodHandle SET_PARENT;
        private static final MethodHandle GET_PARENT;

        private DynamicBundleInternal() {
        }

        static {
            try {
                Method method = ResourceBundle.class.getDeclaredMethod("setParent", ResourceBundle.class);
                method.setAccessible(true);
                SET_PARENT = MethodHandles.lookup().unreflect(method);
                Field parentField = ResourceBundle.class.getDeclaredField("parent");
                parentField.setAccessible(true);
                GET_PARENT = MethodHandles.lookup().unreflectGetter(parentField);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private static enum BundleOrder {
        FOLDER_REGION_LEVEL_PLUGIN(0),
        FOLDER_REGION_LEVEL_PLATFORM(1),
        SUFFIX_REGION_LEVEL_PLUGIN(2),
        SUFFIX_REGION_LEVEL_PLATFORM(3),
        FOLDER_LANGUAGE_LEVEL_PLUGIN(4),
        FOLDER_LANGUAGE_LEVEL_PLATFORM(5),
        SUFFIX_LANGUAGE_LEVEL_PLUGIN(6),
        SUFFIX_LANGUAGE_LEVEL_PLATFORM(7),
        DEFAULT_PLUGIN(8),
        DEFAULT_PLATFORM(9);

        private final int index;

        private BundleOrder(int index2) {
            this.index = index2;
        }

        @Nullable
        private static BundleOrder getBundleOrderByIndex(int ind) {
            Optional<BundleOrder> matchingBundleOrder = Arrays.stream(BundleOrder.values()).filter(b2 -> b2.index == ind).findFirst();
            return matchingBundleOrder.orElse(null);
        }

        @Nullable
        public static BundleOrder getBundleOrder(List<Path> orderedPaths, Path bundlePath, Boolean isPluginClassLoader) {
            int order = orderedPaths.indexOf(bundlePath);
            order = isPluginClassLoader != false ? order * 2 : order * 2 + 1;
            return BundleOrder.getBundleOrderByIndex(order);
        }
    }
}

