/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class JavaReadWriteAccessDetector
extends ReadWriteAccessDetector {
    @Override
    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        if (element == null) {
            JavaReadWriteAccessDetector.$$$reportNull$$$0(0);
        }
        return element instanceof PsiVariable && !(element instanceof ImplicitVariable) || element instanceof PsiClass || element instanceof PsiAnnotationMethod && !(element instanceof PsiCompiledElement);
    }

    @Override
    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        if (element == null) {
            JavaReadWriteAccessDetector.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiVariable && ((PsiVariable)element).getInitializer() != null) {
            return true;
        }
        return element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiForeachStatement;
    }

    @Override
    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        if (referencedElement == null) {
            JavaReadWriteAccessDetector.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            JavaReadWriteAccessDetector.$$$reportNull$$$0(3);
        }
        ReadWriteAccessDetector.Access access = this.getExpressionAccess(reference.getElement());
        if (access == null) {
            JavaReadWriteAccessDetector.$$$reportNull$$$0(4);
        }
        return access;
    }

    @Override
    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression) {
        PsiElement actualReferee;
        if (expression == null) {
            JavaReadWriteAccessDetector.$$$reportNull$$$0(5);
        }
        if (!(expression instanceof PsiExpression)) {
            if (expression instanceof PsiNameValuePair || expression instanceof PsiIdentifier) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    JavaReadWriteAccessDetector.$$$reportNull$$$0(6);
                }
                return access;
            }
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                JavaReadWriteAccessDetector.$$$reportNull$$$0(7);
            }
            return access;
        }
        PsiExpression expr = (PsiExpression)expression;
        boolean readAccess = PsiUtil.isAccessedForReading(expr);
        boolean writeAccess = PsiUtil.isAccessedForWriting(expr);
        if (!writeAccess && expr instanceof PsiReferenceExpression && (actualReferee = ((PsiReferenceExpression)expr).resolve()) instanceof PsiMethod && PropertyUtilBase.isSimplePropertySetter((PsiMethod)actualReferee)) {
            writeAccess = true;
            readAccess = false;
        }
        if (writeAccess && readAccess) {
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.ReadWrite;
            if (access == null) {
                JavaReadWriteAccessDetector.$$$reportNull$$$0(8);
            }
            return access;
        }
        ReadWriteAccessDetector.Access access = writeAccess ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            JavaReadWriteAccessDetector.$$$reportNull$$$0(9);
        }
        return access;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/JavaReadWriteAccessDetector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/JavaReadWriteAccessDetector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAccess";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionAccess";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReadWriteAccessible";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDeclarationWriteAccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAccess";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAccess";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

