/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IFileElementType;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class PsiFileBase
extends PsiFileImpl {
    @NotNull
    private final Language myLanguage;
    @NotNull
    private final ParserDefinition myParserDefinition;

    protected PsiFileBase(@NotNull FileViewProvider viewProvider, @NotNull Language language) {
        if (viewProvider == null) {
            PsiFileBase.$$$reportNull$$$0(0);
        }
        if (language == null) {
            PsiFileBase.$$$reportNull$$$0(1);
        }
        super(viewProvider);
        this.myLanguage = PsiFileBase.findLanguage(language, viewProvider);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.myLanguage);
        if (parserDefinition == null) {
            throw new RuntimeException("PsiFileBase: language.getParserDefinition() returned null for: " + this.myLanguage);
        }
        this.myParserDefinition = parserDefinition;
        IFileElementType nodeType = parserDefinition.getFileNodeType();
        assert (nodeType.getLanguage() == this.myLanguage) : nodeType.getLanguage() + " != " + this.myLanguage;
        this.init(nodeType, nodeType);
    }

    private static Language findLanguage(@NotNull Language baseLanguage, @NotNull FileViewProvider viewProvider) {
        if (baseLanguage == null) {
            PsiFileBase.$$$reportNull$$$0(2);
        }
        if (viewProvider == null) {
            PsiFileBase.$$$reportNull$$$0(3);
        }
        Set<Language> languages = viewProvider.getLanguages();
        Language candidate = null;
        for (Language actualLanguage : languages) {
            if (actualLanguage.equals(baseLanguage)) {
                return baseLanguage;
            }
            if (candidate != null || !actualLanguage.isKindOf(baseLanguage)) continue;
            candidate = actualLanguage;
        }
        if (candidate != null) {
            return candidate;
        }
        throw new AssertionError((Object)("Language " + baseLanguage + " doesn't participate in view provider " + viewProvider + ": " + new ArrayList<Language>(languages)));
    }

    @Override
    @NotNull
    public final Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            PsiFileBase.$$$reportNull$$$0(4);
        }
        return language;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiFileBase.$$$reportNull$$$0(5);
        }
        visitor.visitFile(this);
    }

    @NotNull
    public ParserDefinition getParserDefinition() {
        ParserDefinition parserDefinition = this.myParserDefinition;
        if (parserDefinition == null) {
            PsiFileBase.$$$reportNull$$$0(6);
        }
        return parserDefinition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLanguage";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/extapi/psi/PsiFileBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/extapi/psi/PsiFileBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParserDefinition";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findLanguage";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

