/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.JobProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ModalityStateEx
extends ModalityState {
    private final WeakList<Object> myModalEntities;
    private static final Set<Object> ourTransparentEntities = Collections.newSetFromMap(CollectionFactory.createConcurrentWeakMap());

    public ModalityStateEx() {
        this.myModalEntities = new WeakList();
    }

    ModalityStateEx(@NotNull List<?> modalEntities) {
        if (modalEntities == null) {
            ModalityStateEx.$$$reportNull$$$0(0);
        }
        this.myModalEntities = new WeakList();
        if (modalEntities.contains(null)) {
            throw new IllegalArgumentException("Must not pass null modality: " + modalEntities);
        }
        this.myModalEntities.addAll((Collection<Object>)modalEntities);
    }

    @NotNull
    private @NotNull List<@NotNull Object> getModalEntities() {
        List<Object> list2 = this.myModalEntities.toStrongList();
        if (list2 == null) {
            ModalityStateEx.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public ModalityState appendProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            ModalityStateEx.$$$reportNull$$$0(2);
        }
        ModalityStateEx modalityStateEx = this.appendEntity(progress);
        if (modalityStateEx == null) {
            ModalityStateEx.$$$reportNull$$$0(3);
        }
        return modalityStateEx;
    }

    @NotNull
    public ModalityState appendJob(@NotNull Job job) {
        if (job == null) {
            ModalityStateEx.$$$reportNull$$$0(4);
        }
        ModalityStateEx modalityStateEx = this.appendEntity(job);
        if (modalityStateEx == null) {
            ModalityStateEx.$$$reportNull$$$0(5);
        }
        return modalityStateEx;
    }

    @NotNull
    ModalityStateEx appendEntity(@NotNull Object anEntity) {
        if (anEntity == null) {
            ModalityStateEx.$$$reportNull$$$0(6);
        }
        List<@NotNull Object> modalEntities = this.getModalEntities();
        ArrayList<Object> list2 = new ArrayList<Object>(modalEntities.size() + 1);
        list2.addAll(modalEntities);
        list2.add(anEntity);
        return new ModalityStateEx(list2);
    }

    void forceModalEntities(@NotNull ModalityStateEx other) {
        if (other == null) {
            ModalityStateEx.$$$reportNull$$$0(7);
        }
        List<@NotNull Object> otherEntities = other.getModalEntities();
        this.myModalEntities.clear();
        this.myModalEntities.addAll((Collection<Object>)otherEntities);
    }

    @Override
    public boolean dominates(@NotNull ModalityState otherState) {
        if (otherState == null) {
            ModalityStateEx.$$$reportNull$$$0(8);
        }
        if (otherState == this || otherState == ModalityState.any()) {
            return false;
        }
        if (this.myModalEntities.isEmpty()) {
            return false;
        }
        return !((ModalityStateEx)otherState).myModalEntities.containsAll(this.myModalEntities, entity -> !ourTransparentEntities.contains(entity));
    }

    void cancelAllEntities() {
        for (Object entity : this.myModalEntities) {
            if (entity instanceof Dialog) {
                ((Dialog)entity).setVisible(false);
                if (!(entity instanceof Disposable)) continue;
                Disposer.dispose((Disposable)entity);
                continue;
            }
            if (entity instanceof ProgressIndicator) {
                ((ProgressIndicator)entity).cancel();
                continue;
            }
            if (!(entity instanceof JobProvider)) continue;
            ((JobProvider)entity).getJob().cancel(new CancellationException("force leave modal"));
        }
    }

    @Override
    @NonNls
    public String toString() {
        return this == NON_MODAL ? "ModalityState.NON_MODAL" : "ModalityState:{" + StringUtil.join(this.getModalEntities(), it -> "[" + it + "]", ", ") + "}";
    }

    void removeModality(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            ModalityStateEx.$$$reportNull$$$0(9);
        }
        this.myModalEntities.remove(modalEntity);
    }

    void markTransparent() {
        ContainerUtil.addIfNotNull(ourTransparentEntities, ContainerUtil.getLastItem(this.getModalEntities()));
    }

    static void unmarkTransparent(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            ModalityStateEx.$$$reportNull$$$0(10);
        }
        ourTransparentEntities.remove(modalEntity);
    }

    boolean contains(@NotNull Object modalEntity) {
        if (modalEntity == null) {
            ModalityStateEx.$$$reportNull$$$0(11);
        }
        return this.getModalEntities().contains(modalEntity);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalEntities";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ModalityStateEx";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anEntity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherState";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalEntity";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ModalityStateEx";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalEntities";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "appendProgress";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "appendJob";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendProgress";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendJob";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendEntity";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forceModalEntities";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dominates";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeModality";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unmarkTransparent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

