/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.Strings;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathMacroMap {
    private static final Logger LOG = Logger.getInstance(PathMacroMap.class);

    @NotNull
    public abstract String substitute(@NotNull String var1, boolean var2);

    @NotNull
    public final CharSequence substitute(@NotNull String text, boolean caseSensitive, boolean recursively) {
        if (text == null) {
            PathMacroMap.$$$reportNull$$$0(0);
        }
        CharSequence charSequence = recursively ? this.substituteRecursively(text, caseSensitive) : this.substitute(text, caseSensitive);
        if (charSequence == null) {
            PathMacroMap.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public final void substitute(@NotNull Element e2, boolean caseSensitive) {
        if (e2 == null) {
            PathMacroMap.$$$reportNull$$$0(2);
        }
        this.substitute(e2, caseSensitive, false);
    }

    public final void substitute(@NotNull Element element, boolean caseSensitive, boolean recursively, @Nullable PathMacroFilter filter2) {
        if (element == null) {
            PathMacroMap.$$$reportNull$$$0(3);
        }
        if (filter2 != null && filter2.skipPathMacros(element)) {
            return;
        }
        for (Content child : element.getContent()) {
            if (child instanceof Element) {
                this.substitute((Element)child, caseSensitive, recursively, filter2);
                continue;
            }
            if (child instanceof Text) {
                String newText;
                Text t2 = (Text)child;
                String oldText = t2.getText();
                if (Strings.areSameInstance(oldText, newText = recursively ? this.substituteRecursively(oldText, caseSensitive).toString() : this.substitute(oldText, caseSensitive))) continue;
                t2.setText(newText);
                continue;
            }
            LOG.error("Wrong content: " + child.getClass());
        }
        if (!element.hasAttributes()) {
            return;
        }
        for (Attribute attribute : element.getAttributes()) {
            if (filter2 != null && filter2.skipPathMacros(attribute)) continue;
            String newValue = this.getAttributeValue(attribute, filter2, caseSensitive, recursively);
            if (Strings.areSameInstance(attribute.getValue(), newValue)) continue;
            attribute.setValue(newValue);
        }
    }

    @NotNull
    public String getAttributeValue(@NotNull Attribute attribute, @Nullable PathMacroFilter filter2, boolean caseSensitive, boolean recursively) {
        if (attribute == null) {
            PathMacroMap.$$$reportNull$$$0(4);
        }
        String oldValue = attribute.getValue();
        if (recursively || filter2 != null && filter2.recursePathMacros(attribute)) {
            String string2 = this.substituteRecursively(oldValue, caseSensitive).toString();
            if (string2 == null) {
                PathMacroMap.$$$reportNull$$$0(5);
            }
            return string2;
        }
        String string3 = this.substitute(oldValue, caseSensitive);
        if (string3 == null) {
            PathMacroMap.$$$reportNull$$$0(6);
        }
        return string3;
    }

    public final void substitute(@NotNull Element e2, boolean caseSensitive, boolean recursively) {
        if (e2 == null) {
            PathMacroMap.$$$reportNull$$$0(7);
        }
        this.substitute(e2, caseSensitive, recursively, null);
    }

    @NotNull
    public CharSequence substituteRecursively(@NotNull String text, boolean caseSensitive) {
        if (text == null) {
            PathMacroMap.$$$reportNull$$$0(8);
        }
        String string2 = this.substitute(text, caseSensitive);
        if (string2 == null) {
            PathMacroMap.$$$reportNull$$$0(9);
        }
        return string2;
    }

    public abstract int hashCode();

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/PathMacroMap";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/PathMacroMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteRecursively";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "substituteRecursively";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

