/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.function.Function;
import org.apache.log4j.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class Logger {
    private static boolean isUnitTestMode;
    private static Factory ourFactory;
    static final Function<Attachment, String> ATTACHMENT_TO_STRING;

    public static void setFactory(@NotNull Class<? extends Factory> factory) {
        if (factory == null) {
            Logger.$$$reportNull$$$0(0);
        }
        if (Logger.isInitialized()) {
            if (factory.isInstance(ourFactory)) {
                return;
            }
            Logger.logFactoryChanged(factory);
        }
        try {
            Constructor<? extends Factory> constructor = factory.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            ourFactory = constructor.newInstance(new Object[0]);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
    }

    public static void setFactory(@NotNull Factory factory) {
        if (factory == null) {
            Logger.$$$reportNull$$$0(1);
        }
        if (Logger.isInitialized()) {
            Logger.logFactoryChanged(factory.getClass());
        }
        ourFactory = factory;
    }

    private static void logFactoryChanged(Class<? extends Factory> factory) {
        if (SystemProperties.getBooleanProperty("idea.log.logger.factory.changed", false)) {
            System.out.println("Changing log factory from " + ourFactory.getClass().getCanonicalName() + " to " + factory.getCanonicalName() + '\n' + ExceptionUtil.getThrowableText(new Throwable()));
        }
    }

    public static Factory getFactory() {
        return ourFactory;
    }

    public static boolean isInitialized() {
        return !(ourFactory instanceof DefaultFactory);
    }

    @NotNull
    public static Logger getInstance(@NotNull String category) {
        if (category == null) {
            Logger.$$$reportNull$$$0(2);
        }
        Logger logger = ourFactory.getLoggerInstance(category);
        if (logger == null) {
            Logger.$$$reportNull$$$0(3);
        }
        return logger;
    }

    @NotNull
    public static Logger getInstance(@NotNull Class<?> cl) {
        if (cl == null) {
            Logger.$$$reportNull$$$0(4);
        }
        Logger logger = ourFactory.getLoggerInstance("#" + cl.getName());
        if (logger == null) {
            Logger.$$$reportNull$$$0(5);
        }
        return logger;
    }

    public abstract boolean isDebugEnabled();

    public void debug(String message2) {
        this.debug(message2, null);
    }

    public void debug(@Nullable Throwable t2) {
        if (t2 != null) {
            this.debug(t2.getMessage(), t2);
        }
    }

    public abstract void debug(String var1, @Nullable Throwable var2);

    public void debug(@NotNull String message2, Object ... details) {
        if (message2 == null) {
            Logger.$$$reportNull$$$0(6);
        }
        if (details == null) {
            Logger.$$$reportNull$$$0(7);
        }
        if (this.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(message2);
            for (Object detail : details) {
                sb.append(detail);
            }
            this.debug(sb.toString());
        }
    }

    public void debugValues(@NotNull String header, @NotNull Collection<?> values2) {
        if (header == null) {
            Logger.$$$reportNull$$$0(8);
        }
        if (values2 == null) {
            Logger.$$$reportNull$$$0(9);
        }
        if (this.isDebugEnabled()) {
            StringBuilder text = new StringBuilder();
            text.append(header).append(" (").append(values2.size()).append(")");
            if (!values2.isEmpty()) {
                text.append(":");
                for (Object value : values2) {
                    text.append("\n");
                    text.append(value);
                }
            }
            this.debug(text.toString());
        }
    }

    public final void infoWithDebug(@NotNull Throwable t2) {
        if (t2 == null) {
            Logger.$$$reportNull$$$0(10);
        }
        this.infoWithDebug(t2.toString(), t2);
    }

    public final void infoWithDebug(@NotNull String message2, @NotNull Throwable t2) {
        if (message2 == null) {
            Logger.$$$reportNull$$$0(11);
        }
        if (t2 == null) {
            Logger.$$$reportNull$$$0(12);
        }
        this.info(message2);
        this.debug(t2);
    }

    public final void warnWithDebug(@NotNull Throwable t2) {
        if (t2 == null) {
            Logger.$$$reportNull$$$0(13);
        }
        this.warnWithDebug(t2.toString(), t2);
    }

    public final void warnWithDebug(@NotNull String message2, @NotNull Throwable t2) {
        if (message2 == null) {
            Logger.$$$reportNull$$$0(14);
        }
        if (t2 == null) {
            Logger.$$$reportNull$$$0(15);
        }
        this.warn(message2);
        this.debug(t2);
    }

    public boolean isTraceEnabled() {
        return this.isDebugEnabled();
    }

    public void trace(String message2) {
        this.debug(message2);
    }

    public void trace(@Nullable Throwable t2) {
        this.debug(t2);
    }

    public void info(@NotNull Throwable t2) {
        if (t2 == null) {
            Logger.$$$reportNull$$$0(16);
        }
        this.info(t2.getMessage(), t2);
    }

    public void info(String message2) {
        this.info(message2, null);
    }

    public abstract void info(String var1, @Nullable Throwable var2);

    public void warn(String message2) {
        this.warn(message2, null);
    }

    public void warn(@NotNull Throwable t2) {
        if (t2 == null) {
            Logger.$$$reportNull$$$0(17);
        }
        this.warn(t2.getMessage(), t2);
    }

    public abstract void warn(String var1, @Nullable Throwable var2);

    public void error(String message2) {
        this.error(message2, new Throwable(message2), ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    @Deprecated
    public void error(Object message2) {
        this.error(String.valueOf(message2));
    }

    public void error(String message2, Attachment ... attachments) {
        if (attachments == null) {
            Logger.$$$reportNull$$$0(18);
        }
        this.error(message2, (Throwable)null, attachments);
    }

    public void error(String message2, @Nullable Throwable t2, Attachment ... attachments) {
        if (attachments == null) {
            Logger.$$$reportNull$$$0(19);
        }
        this.error(message2, t2, ContainerUtil.map2Array(attachments, String.class, ATTACHMENT_TO_STRING::apply));
    }

    public void error(String message2, String ... details) {
        if (details == null) {
            Logger.$$$reportNull$$$0(20);
        }
        this.error(message2, new Throwable(message2), details);
    }

    public void error(String message2, @Nullable Throwable t2) {
        this.error(message2, t2, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void error(@NotNull Throwable t2) {
        if (t2 == null) {
            Logger.$$$reportNull$$$0(21);
        }
        this.error(t2.getMessage(), t2, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public abstract void error(String var1, @Nullable Throwable var2, String ... var3);

    @Contract(value="false,_->fail")
    public boolean assertTrue(boolean value, @Nullable Object message2) {
        if (!value) {
            String resultMessage = "Assertion failed";
            if (message2 != null) {
                resultMessage = resultMessage + ": " + message2;
            }
            this.error(resultMessage, new Throwable(resultMessage));
        }
        return value;
    }

    @Contract(value="false->fail")
    public boolean assertTrue(boolean value) {
        return value || this.assertTrue(false, null);
    }

    @Deprecated
    public abstract void setLevel(@NotNull Level var1);

    public void setLevel(@NotNull LogLevel level) {
        if (level == null) {
            Logger.$$$reportNull$$$0(22);
        }
        switch (level) {
            case OFF: {
                this.setLevel(Level.OFF);
                break;
            }
            case ERROR: {
                this.setLevel(Level.ERROR);
                break;
            }
            case WARNING: {
                this.setLevel(Level.WARN);
                break;
            }
            case INFO: {
                this.setLevel(Level.INFO);
                break;
            }
            case DEBUG: {
                this.setLevel(Level.DEBUG);
                break;
            }
            case TRACE: {
                this.setLevel(Level.TRACE);
                break;
            }
            case ALL: {
                this.setLevel(Level.ALL);
            }
        }
    }

    @Nullable
    protected static Throwable ensureNotControlFlow(@Nullable Throwable t2) {
        return t2 instanceof ControlFlowException ? new Throwable("Control-flow exceptions (e.g. this " + t2.getClass() + ") should never be logged. Instead, these should have been rethrown if caught.", t2) : t2;
    }

    @TestOnly
    public static void setUnitTestMode() {
        isUnitTestMode = true;
    }

    public void warnInProduction(@NotNull Throwable t2) {
        if (t2 == null) {
            Logger.$$$reportNull$$$0(23);
        }
        if (isUnitTestMode) {
            this.error(t2);
        } else {
            this.warn(t2);
        }
    }

    static {
        ourFactory = new DefaultFactory();
        ATTACHMENT_TO_STRING = attachment -> attachment.getPath() + "\n" + attachment.getDisplayText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/Logger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/Logger";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFactory";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "debugValues";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "infoWithDebug";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "warnWithDebug";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "info";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setLevel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "warnInProduction";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Factory {
        @NotNull
        public Logger getLoggerInstance(@NotNull String var1);
    }

    private static final class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        @Override
        @NotNull
        public Logger getLoggerInstance(@NotNull String category) {
            if (category == null) {
                DefaultFactory.$$$reportNull$$$0(0);
            }
            return new DefaultLogger(category);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/openapi/diagnostic/Logger$DefaultFactory", "getLoggerInstance"));
        }
    }
}

