/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
class ImmutableSyntheticLibrary
extends SyntheticLibrary {
    private final List<VirtualFile> mySourceRoots;
    private final List<VirtualFile> myBinaryRoots;
    private final Set<VirtualFile> myExcludedRoots;
    private final Condition<? super VirtualFile> myExcludeCondition;
    private final int hashCode;

    ImmutableSyntheticLibrary(@Nullable String comparisonId, @NotNull List<? extends VirtualFile> sourceRoots, @NotNull List<? extends VirtualFile> binaryRoots, @NotNull Set<? extends VirtualFile> excludedRoots, @Nullable Condition<? super VirtualFile> excludeCondition, @Nullable SyntheticLibrary.ExcludeFileCondition constantCondition) {
        if (sourceRoots == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(0);
        }
        if (binaryRoots == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(1);
        }
        if (excludedRoots == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(2);
        }
        super(comparisonId, constantCondition);
        this.mySourceRoots = ImmutableSyntheticLibrary.immutableOrEmptyList(sourceRoots);
        this.myBinaryRoots = ImmutableSyntheticLibrary.immutableOrEmptyList(binaryRoots);
        this.myExcludedRoots = ContainerUtil.unmodifiableOrEmptySet(excludedRoots);
        this.myExcludeCondition = excludeCondition;
        this.hashCode = Objects.hash(this.mySourceRoots, this.myBinaryRoots, this.myExcludedRoots, this.myExcludeCondition);
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSourceRoots() {
        List<VirtualFile> list2 = this.mySourceRoots;
        if (list2 == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getBinaryRoots() {
        List<VirtualFile> list2 = this.myBinaryRoots;
        if (list2 == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getExcludedRoots() {
        Set<VirtualFile> set = this.myExcludedRoots;
        if (set == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @Nullable
    public Condition<VirtualFile> getExcludeFileCondition() {
        return this.myExcludeCondition;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ImmutableSyntheticLibrary library = (ImmutableSyntheticLibrary)o2;
        if (!Objects.equals(this.getComparisonId(), library.getComparisonId())) {
            return false;
        }
        if (!this.mySourceRoots.equals(library.getSourceRoots())) {
            return false;
        }
        if (!this.myBinaryRoots.equals(library.getBinaryRoots())) {
            return false;
        }
        if (!this.myExcludedRoots.equals(library.getExcludedRoots())) {
            return false;
        }
        return Objects.equals(this.myExcludeCondition, library.getExcludeFileCondition());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @NotNull
    private static <E> @Unmodifiable List<E> immutableOrEmptyList(@NotNull List<? extends E> list2) {
        if (list2 == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(6);
        }
        List<Object> list3 = list2.isEmpty() ? Collections.emptyList() : List.copyOf(list2);
        if (list3 == null) {
            ImmutableSyntheticLibrary.$$$reportNull$$$0(7);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3, 4, 5, 7 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ImmutableSyntheticLibrary";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ImmutableSyntheticLibrary";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableOrEmptyList";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "immutableOrEmptyList";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 5, 7 -> new IllegalStateException(string2);
        };
    }
}

