/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static <E extends Throwable> void runWithClassLoader(@Nullable ClassLoader classLoader2, @NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            ClassLoaderUtil.$$$reportNull$$$0(0);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader2);
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithClassLoader(@Nullable ClassLoader classLoader2, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            ClassLoaderUtil.$$$reportNull$$$0(1);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader2);
            T t2 = computable.compute();
            return t2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static <T> T runWithClassLoader(ClassLoader classLoader2, Computable<T> computable) {
        return (T)ClassLoaderUtil.computeWithClassLoader(classLoader2, () -> computable.compute());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/ClassLoaderUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithClassLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "computeWithClassLoader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

