/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.messages.Topic;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileManager
implements ModificationTracker {
    @Topic.AppLevel
    public static final Topic<BulkFileListener> VFS_CHANGES = new Topic<BulkFileListener>(BulkFileListener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN, true);
    @NotNull
    public static final ModificationTracker VFS_STRUCTURE_MODIFICATIONS = () -> VirtualFileManager.getInstance().getStructureModificationCount();
    private static final Supplier<VirtualFileManager> ourInstance = CachedSingletonsRegistry.lazy(() -> ApplicationManager.getApplication().getService(VirtualFileManager.class));

    @NotNull
    public static VirtualFileManager getInstance() {
        VirtualFileManager virtualFileManager = ourInstance.get();
        if (virtualFileManager == null) {
            VirtualFileManager.$$$reportNull$$$0(0);
        }
        return virtualFileManager;
    }

    @Contract(value="null -> null")
    public abstract VirtualFileSystem getFileSystem(@Nullable String var1);

    public abstract long syncRefresh();

    public abstract long asyncRefresh(@Nullable Runnable var1);

    public final long asyncRefresh() {
        return this.asyncRefresh(null);
    }

    public abstract void refreshWithoutFileWatcher(boolean var1);

    @Nullable
    public VirtualFile findFileByUrl(@NonNls @NotNull String url) {
        if (url == null) {
            VirtualFileManager.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    public VirtualFile findFileByNioPath(@NotNull Path path) {
        if (path == null) {
            VirtualFileManager.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Nullable
    public VirtualFile refreshAndFindFileByUrl(@NotNull String url) {
        if (url == null) {
            VirtualFileManager.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Nullable
    public VirtualFile refreshAndFindFileByNioPath(@NotNull Path path) {
        if (path == null) {
            VirtualFileManager.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Deprecated
    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1);

    @Deprecated
    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1, @NotNull Disposable var2);

    @Deprecated
    public abstract void removeVirtualFileListener(@NotNull VirtualFileListener var1);

    public abstract void addAsyncFileListener(@NotNull AsyncFileListener var1, @NotNull Disposable var2);

    @NotNull
    public static String constructUrl(@NotNull String protocol, @NotNull String path) {
        if (protocol == null) {
            VirtualFileManager.$$$reportNull$$$0(5);
        }
        if (path == null) {
            VirtualFileManager.$$$reportNull$$$0(6);
        }
        String string2 = protocol + "://" + path;
        if (string2 == null) {
            VirtualFileManager.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Nullable
    public static String extractProtocol(@NotNull String url) {
        int index2;
        if (url == null) {
            VirtualFileManager.$$$reportNull$$$0(8);
        }
        if ((index2 = url.indexOf("://")) < 0) {
            return null;
        }
        return url.substring(0, index2);
    }

    @NotNull
    public static String extractPath(@NotNull String url) {
        if (url == null) {
            VirtualFileManager.$$$reportNull$$$0(9);
        }
        String string2 = URLUtil.extractPath(url);
        if (string2 == null) {
            VirtualFileManager.$$$reportNull$$$0(10);
        }
        return string2;
    }

    public abstract void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1, @NotNull Disposable var2);

    @Deprecated
    public abstract void removeVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1);

    public abstract void notifyPropertyChanged(@NotNull VirtualFile var1, @VirtualFile.PropName @NotNull String var2, Object var3, Object var4);

    @Override
    public abstract long getModificationCount();

    public abstract long getStructureModificationCount();

    @ApiStatus.Internal
    public VirtualFile findFileById(int id2) {
        return null;
    }

    @ApiStatus.Internal
    public int[] listAllChildIds(int id2) {
        return ArrayUtil.EMPTY_INT_ARRAY;
    }

    @ApiStatus.Internal
    public abstract int storeName(@NotNull String var1);

    @ApiStatus.Internal
    @NotNull
    public abstract CharSequence getVFileName(int var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/VirtualFileManager";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/VirtualFileManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "constructUrl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPath";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileByUrl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFileByNioPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByUrl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByNioPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "constructUrl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractProtocol";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

