/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.IJNoopTracer;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.MetricsExporterEntry;
import com.intellij.platform.diagnostic.telemetry.NoopIntelliJTracer;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/NoopTelemetryManager;", "Lcom/intellij/platform/diagnostic/telemetry/TelemetryManager;", "()V", "verboseMode", "", "getVerboseMode", "()Z", "setVerboseMode", "(Z)V", "addMetricsExporters", "", "exporters", "", "Lcom/intellij/platform/diagnostic/telemetry/MetricsExporterEntry;", "forceFlushMetrics", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMeter", "Lio/opentelemetry/api/metrics/Meter;", "scope", "Lcom/intellij/platform/diagnostic/telemetry/Scope;", "getSimpleTracer", "Lcom/intellij/platform/diagnostic/telemetry/NoopIntelliJTracer;", "getTracer", "Lcom/intellij/platform/diagnostic/telemetry/IJTracer;", "hasSpanExporters", "intellij.platform.diagnostic.telemetry"})
@SourceDebugExtension(value={"SMAP\nTelemetryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelemetryManager.kt\ncom/intellij/platform/diagnostic/telemetry/NoopTelemetryManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,174:1\n11#2:175\n11#2:176\n*S KotlinDebug\n*F\n+ 1 TelemetryManager.kt\ncom/intellij/platform/diagnostic/telemetry/NoopTelemetryManager\n*L\n148#1:175\n152#1:176\n*E\n"})
public final class NoopTelemetryManager
implements TelemetryManager {
    private boolean verboseMode;

    @Override
    public boolean getVerboseMode() {
        return this.verboseMode;
    }

    @Override
    public void setVerboseMode(boolean bl2) {
        this.verboseMode = bl2;
    }

    @Override
    public boolean hasSpanExporters() {
        return false;
    }

    @Override
    @NotNull
    public IJTracer getTracer(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter(scope, "scope");
        return IJNoopTracer.INSTANCE;
    }

    @Override
    @NotNull
    public NoopIntelliJTracer getSimpleTracer(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter(scope, "scope");
        return NoopIntelliJTracer.INSTANCE;
    }

    @Override
    @NotNull
    public Meter getMeter(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter(scope, "scope");
        Meter meter = OpenTelemetry.noop().getMeter(scope.toString());
        Intrinsics.checkNotNullExpressionValue(meter, "noop().getMeter(scope.toString())");
        return meter;
    }

    @Override
    public void addMetricsExporters(@NotNull List<MetricsExporterEntry> exporters) {
        Intrinsics.checkNotNullParameter(exporters, "exporters");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NoopTelemetryManager.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        logger.info("Noop telemetry manager is in use. No metrics exporters are defined.");
    }

    @Override
    @Nullable
    public Object forceFlushMetrics(@NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NoopTelemetryManager.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        logger.info("Cannot force flushing metrics for Noop telemetry manager");
        return Unit.INSTANCE;
    }
}

