/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps;

import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/workspace/jps/JpsEntitySourceFactory;", "", "()V", "createJpsEntitySource", "Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource;", "configLocation", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "directoryLocation", "", "createJpsEntitySourceForArtifact", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "createJpsEntitySourceForProjectLibrary", "intellij.platform.workspace.jps"})
public final class JpsEntitySourceFactory {
    @NotNull
    public static final JpsEntitySourceFactory INSTANCE = new JpsEntitySourceFactory();

    private JpsEntitySourceFactory() {
    }

    @NotNull
    public final JpsFileEntitySource createJpsEntitySourceForProjectLibrary(@NotNull JpsProjectConfigLocation configLocation) {
        Intrinsics.checkNotNullParameter(configLocation, "configLocation");
        return this.createJpsEntitySource(configLocation, "libraries");
    }

    @NotNull
    public final JpsFileEntitySource createJpsEntitySourceForArtifact(@NotNull JpsProjectConfigLocation configLocation) {
        Intrinsics.checkNotNullParameter(configLocation, "configLocation");
        return this.createJpsEntitySource(configLocation, "artifacts");
    }

    private final JpsProjectFileEntitySource createJpsEntitySource(JpsProjectConfigLocation configLocation, String directoryLocation) {
        JpsProjectFileEntitySource jpsProjectFileEntitySource;
        JpsProjectConfigLocation jpsProjectConfigLocation = configLocation;
        if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.DirectoryBased) {
            VirtualFileUrl virtualFileUrl = ((JpsProjectConfigLocation.DirectoryBased)configLocation).getIdeaFolder().append(directoryLocation);
            Intrinsics.checkNotNullExpressionValue(virtualFileUrl, "append(...)");
            jpsProjectFileEntitySource = new JpsProjectFileEntitySource.FileInDirectory(virtualFileUrl, configLocation);
        } else if (jpsProjectConfigLocation instanceof JpsProjectConfigLocation.FileBased) {
            jpsProjectFileEntitySource = new JpsProjectFileEntitySource.ExactFile(((JpsProjectConfigLocation.FileBased)configLocation).getIprFile(), configLocation);
        } else {
            throw new IllegalStateException("Unexpected state".toString());
        }
        return jpsProjectFileEntitySource;
    }
}

