/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps;

import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "", "()V", "baseDirectoryUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getBaseDirectoryUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "baseDirectoryUrlString", "", "getBaseDirectoryUrlString", "()Ljava/lang/String;", "projectFilePath", "getProjectFilePath", "DirectoryBased", "FileBased", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation$DirectoryBased;", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation$FileBased;", "intellij.platform.workspace.jps"})
public abstract class JpsProjectConfigLocation {
    private JpsProjectConfigLocation() {
    }

    @NotNull
    public final String getBaseDirectoryUrlString() {
        String string2 = this.getBaseDirectoryUrl().getUrl();
        Intrinsics.checkNotNullExpressionValue(string2, "getUrl(...)");
        return string2;
    }

    @NotNull
    public abstract String getProjectFilePath();

    @NotNull
    public abstract VirtualFileUrl getBaseDirectoryUrl();

    public /* synthetic */ JpsProjectConfigLocation(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\fH\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation$DirectoryBased;", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "projectDir", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "ideaFolder", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;)V", "baseDirectoryUrl", "getBaseDirectoryUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getIdeaFolder", "getProjectDir", "projectFilePath", "", "getProjectFilePath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.workspace.jps"})
    public static final class DirectoryBased
    extends JpsProjectConfigLocation {
        @NotNull
        private final VirtualFileUrl projectDir;
        @NotNull
        private final VirtualFileUrl ideaFolder;

        public DirectoryBased(@NotNull VirtualFileUrl projectDir, @NotNull VirtualFileUrl ideaFolder) {
            Intrinsics.checkNotNullParameter(projectDir, "projectDir");
            Intrinsics.checkNotNullParameter(ideaFolder, "ideaFolder");
            super(null);
            this.projectDir = projectDir;
            this.ideaFolder = ideaFolder;
        }

        @NotNull
        public final VirtualFileUrl getProjectDir() {
            return this.projectDir;
        }

        @NotNull
        public final VirtualFileUrl getIdeaFolder() {
            return this.ideaFolder;
        }

        @Override
        @NotNull
        public VirtualFileUrl getBaseDirectoryUrl() {
            return this.projectDir;
        }

        @Override
        @NotNull
        public String getProjectFilePath() {
            String string2 = JpsPathUtil.urlToPath(this.ideaFolder.append("misc.xml").getUrl());
            Intrinsics.checkNotNullExpressionValue(string2, "urlToPath(...)");
            return string2;
        }

        @NotNull
        public final VirtualFileUrl component1() {
            return this.projectDir;
        }

        @NotNull
        public final VirtualFileUrl component2() {
            return this.ideaFolder;
        }

        @NotNull
        public final DirectoryBased copy(@NotNull VirtualFileUrl projectDir, @NotNull VirtualFileUrl ideaFolder) {
            Intrinsics.checkNotNullParameter(projectDir, "projectDir");
            Intrinsics.checkNotNullParameter(ideaFolder, "ideaFolder");
            return new DirectoryBased(projectDir, ideaFolder);
        }

        public static /* synthetic */ DirectoryBased copy$default(DirectoryBased directoryBased, VirtualFileUrl virtualFileUrl, VirtualFileUrl virtualFileUrl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                virtualFileUrl = directoryBased.projectDir;
            }
            if ((n2 & 2) != 0) {
                virtualFileUrl2 = directoryBased.ideaFolder;
            }
            return directoryBased.copy(virtualFileUrl, virtualFileUrl2);
        }

        @NotNull
        public String toString() {
            return "DirectoryBased(projectDir=" + this.projectDir + ", ideaFolder=" + this.ideaFolder + ")";
        }

        public int hashCode() {
            int result2 = this.projectDir.hashCode();
            result2 = result2 * 31 + this.ideaFolder.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DirectoryBased)) {
                return false;
            }
            DirectoryBased directoryBased = (DirectoryBased)other;
            if (!Intrinsics.areEqual(this.projectDir, directoryBased.projectDir)) {
                return false;
            }
            return Intrinsics.areEqual(this.ideaFolder, directoryBased.ideaFolder);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\fH\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation$FileBased;", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "iprFile", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "iprFileParent", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;)V", "baseDirectoryUrl", "getBaseDirectoryUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getIprFile", "getIprFileParent", "projectFilePath", "", "getProjectFilePath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.workspace.jps"})
    public static final class FileBased
    extends JpsProjectConfigLocation {
        @NotNull
        private final VirtualFileUrl iprFile;
        @NotNull
        private final VirtualFileUrl iprFileParent;

        public FileBased(@NotNull VirtualFileUrl iprFile, @NotNull VirtualFileUrl iprFileParent) {
            Intrinsics.checkNotNullParameter(iprFile, "iprFile");
            Intrinsics.checkNotNullParameter(iprFileParent, "iprFileParent");
            super(null);
            this.iprFile = iprFile;
            this.iprFileParent = iprFileParent;
        }

        @NotNull
        public final VirtualFileUrl getIprFile() {
            return this.iprFile;
        }

        @NotNull
        public final VirtualFileUrl getIprFileParent() {
            return this.iprFileParent;
        }

        @Override
        @NotNull
        public VirtualFileUrl getBaseDirectoryUrl() {
            return this.iprFileParent;
        }

        @Override
        @NotNull
        public String getProjectFilePath() {
            String string2 = JpsPathUtil.urlToPath(this.iprFile.getUrl());
            Intrinsics.checkNotNullExpressionValue(string2, "urlToPath(...)");
            return string2;
        }

        @NotNull
        public final VirtualFileUrl component1() {
            return this.iprFile;
        }

        @NotNull
        public final VirtualFileUrl component2() {
            return this.iprFileParent;
        }

        @NotNull
        public final FileBased copy(@NotNull VirtualFileUrl iprFile, @NotNull VirtualFileUrl iprFileParent) {
            Intrinsics.checkNotNullParameter(iprFile, "iprFile");
            Intrinsics.checkNotNullParameter(iprFileParent, "iprFileParent");
            return new FileBased(iprFile, iprFileParent);
        }

        public static /* synthetic */ FileBased copy$default(FileBased fileBased, VirtualFileUrl virtualFileUrl, VirtualFileUrl virtualFileUrl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                virtualFileUrl = fileBased.iprFile;
            }
            if ((n2 & 2) != 0) {
                virtualFileUrl2 = fileBased.iprFileParent;
            }
            return fileBased.copy(virtualFileUrl, virtualFileUrl2);
        }

        @NotNull
        public String toString() {
            return "FileBased(iprFile=" + this.iprFile + ", iprFileParent=" + this.iprFileParent + ")";
        }

        public int hashCode() {
            int result2 = this.iprFile.hashCode();
            result2 = result2 * 31 + this.iprFileParent.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileBased)) {
                return false;
            }
            FileBased fileBased = (FileBased)other;
            if (!Intrinsics.areEqual(this.iprFile, fileBased.iprFile)) {
                return false;
            }
            return Intrinsics.areEqual(this.iprFileParent, fileBased.iprFileParent);
        }
    }
}

