/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.entities.ExternalSystemModuleOptionsEntity;
import com.intellij.platform.workspace.jps.entities.ModuleCustomImlDataEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.serialization.SerializationContext;
import com.intellij.platform.workspace.jps.serialization.impl.ErrorReporter;
import com.intellij.platform.workspace.jps.serialization.impl.ExternalModuleImlFileEntitiesSerializerKt;
import com.intellij.platform.workspace.jps.serialization.impl.FacetsSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsModuleListSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.LoadingResult;
import com.intellij.platform.workspace.jps.serialization.impl.ModuleImlFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.ModulePath;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0017H\u0014J@\u0010\u001b\u001a\"\u0012\u001e\u0012\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0 0\u001d0\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016JB\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010!\u001a\u00020\"2\u0016\u0010+\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001d2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0014JF\u0010,\u001a \u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u00170-2\u0006\u0010!\u001a\u00020\"2\u0016\u0010.\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001dH\u0014J.\u0010/\u001a\u00020(2\b\u0010+\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u00010\u00172\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u000205H\u0014J\b\u00106\u001a\u00020\u0017H\u0016R\u0014\u0010\r\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00067"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ExternalModuleImlFileEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/ModuleImlFileEntitiesSerializer;", "modulePath", "Lcom/intellij/platform/workspace/jps/serialization/impl/ModulePath;", "fileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "context", "Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;", "internalEntitySource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "internalModuleListSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsModuleListSerializer;", "(Lcom/intellij/platform/workspace/jps/serialization/impl/ModulePath;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;Lcom/intellij/platform/workspace/jps/serialization/impl/JpsModuleListSerializer;)V", "skipLoadingIfFileDoesNotExist", "", "getSkipLoadingIfFileDoesNotExist", "()Z", "acceptsSource", "entitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "createExternalEntitySource", "Lcom/intellij/platform/workspace/jps/JpsImportedEntitySource;", "externalSystemId", "", "createFacetSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/FacetsSerializer;", "getBaseDirPath", "loadEntities", "Lcom/intellij/platform/workspace/jps/serialization/impl/LoadingResult;", "", "Ljava/lang/Class;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "reader", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "errorReporter", "Lcom/intellij/platform/workspace/jps/serialization/impl/ErrorReporter;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "loadExternalSystemOptions", "", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "externalSystemOptions", "readExternalSystemOptions", "Lkotlin/Pair;", "moduleOptions", "saveModuleOptions", "Lcom/intellij/platform/workspace/jps/entities/ExternalSystemModuleOptionsEntity;", "moduleType", "customImlData", "Lcom/intellij/platform/workspace/jps/entities/ModuleCustomImlDataEntity;", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "toString", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nExternalModuleImlFileEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalModuleImlFileEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/ExternalModuleImlFileEntitiesSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,167:1\n1208#2,2:168\n1238#2,4:170\n11#3:174\n215#4,2:175\n*S KotlinDebug\n*F\n+ 1 ExternalModuleImlFileEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/ExternalModuleImlFileEntitiesSerializer\n*L\n49#1:168,2\n49#1:170,4\n77#1:174\n101#1:175,2\n*E\n"})
public final class ExternalModuleImlFileEntitiesSerializer
extends ModuleImlFileEntitiesSerializer {
    public ExternalModuleImlFileEntitiesSerializer(@NotNull ModulePath modulePath, @NotNull VirtualFileUrl fileUrl, @NotNull SerializationContext context2, @NotNull JpsFileEntitySource internalEntitySource, @NotNull JpsModuleListSerializer internalModuleListSerializer) {
        Intrinsics.checkNotNullParameter(modulePath, "modulePath");
        Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(internalEntitySource, "internalEntitySource");
        Intrinsics.checkNotNullParameter(internalModuleListSerializer, "internalModuleListSerializer");
        super(modulePath, fileUrl, internalEntitySource, context2, internalModuleListSerializer, null, 32, null);
    }

    @Override
    protected boolean getSkipLoadingIfFileDoesNotExist() {
        return true;
    }

    @Override
    @NotNull
    public LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity>>> loadEntities(@NotNull JpsFileContentReader reader, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(errorReporter, "errorReporter");
        Intrinsics.checkNotNullParameter(virtualFileManager, "virtualFileManager");
        return new LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity>>>(MapsKt.emptyMap(), null);
    }

    @Override
    protected boolean acceptsSource(@NotNull EntitySource entitySource) {
        Intrinsics.checkNotNullParameter(entitySource, "entitySource");
        return entitySource instanceof JpsImportedEntitySource && ((JpsImportedEntitySource)entitySource).getStoredExternally();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Pair<Map<String, String>, String> readExternalSystemOptions(@NotNull JpsFileContentReader reader, @NotNull Map<String, String> moduleOptions) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(moduleOptions, "moduleOptions");
        String string2 = this.getFileUrl().getUrl();
        Intrinsics.checkNotNullExpressionValue(string2, "getUrl(...)");
        Element element = reader.loadComponent(string2, "ExternalSystem", this.getBaseDirPath());
        if (element == null) {
            return new Pair(MapsKt.emptyMap(), null);
        }
        Element componentTag = element;
        List<Attribute> list2 = componentTag.getAttributes();
        Intrinsics.checkNotNullExpressionValue(list2, "getAttributes(...)");
        Iterable $this$associateBy$iv = list2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Attribute attribute = (Attribute)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl2 = false;
            Attribute it = (Attribute)element$iv$iv;
            String string3 = it.getName();
            boolean bl3 = false;
            String string4 = it.getValue();
            map2.put(string3, string4);
        }
        Map options = destination$iv$iv;
        return new Pair<Map<String, String>, String>(options, (String)options.get("externalSystem"));
    }

    @Override
    protected void loadExternalSystemOptions(@NotNull ModuleEntity module, @NotNull JpsFileContentReader reader, @NotNull Map<String, String> externalSystemOptions, @Nullable String externalSystemId, @NotNull EntitySource entitySource) {
        Intrinsics.checkNotNullParameter(module, "module");
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(externalSystemOptions, "externalSystemOptions");
        Intrinsics.checkNotNullParameter(entitySource, "entitySource");
        if (!this.shouldCreateExternalSystemModuleOptions$intellij_platform_workspace_jps(externalSystemId, externalSystemOptions, ExternalModuleImlFileEntitiesSerializerKt.access$getMODULE_OPTIONS_TO_CHECK$p())) {
            return;
        }
        ExternalSystemModuleOptionsEntity.Companion.create(entitySource, (Function1<? super ExternalSystemModuleOptionsEntity.Builder, Unit>)new Function1<ExternalSystemModuleOptionsEntity.Builder, Unit>(module, externalSystemId, externalSystemOptions){
            final /* synthetic */ ModuleEntity $module;
            final /* synthetic */ String $externalSystemId;
            final /* synthetic */ Map<String, String> $externalSystemOptions;
            {
                this.$module = $module;
                this.$externalSystemId = $externalSystemId;
                this.$externalSystemOptions = $externalSystemOptions;
                super(1);
            }

            public final void invoke(@NotNull ExternalSystemModuleOptionsEntity.Builder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.setModule(this.$module);
                $this$invoke.setExternalSystem(this.$externalSystemId);
                $this$invoke.setExternalSystemModuleVersion(this.$externalSystemOptions.get("externalSystemModuleVersion"));
                $this$invoke.setLinkedProjectPath(this.$externalSystemOptions.get("linkedProjectPath"));
                $this$invoke.setLinkedProjectId(this.$externalSystemOptions.get("linkedProjectId"));
                $this$invoke.setRootProjectPath(this.$externalSystemOptions.get("rootProjectPath"));
                $this$invoke.setExternalSystemModuleGroup(this.$externalSystemOptions.get("externalSystemModuleGroup"));
                $this$invoke.setExternalSystemModuleType(this.$externalSystemOptions.get("externalSystemModuleType"));
            }
        });
    }

    @Override
    protected void saveModuleOptions(@Nullable ExternalSystemModuleOptionsEntity externalSystemOptions, @Nullable String moduleType, @Nullable ModuleCustomImlDataEntity customImlData, @NotNull JpsFileContentWriter writer) {
        block8: {
            Object object;
            String fileUrlString;
            block7: {
                Intrinsics.checkNotNullParameter(writer, "writer");
                fileUrlString = this.getFileUrl().getUrl();
                if (FileUtil.extensionEquals(fileUrlString, "iml")) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(ExternalModuleImlFileEntitiesSerializer.class);
                    Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
                    logger.error("External serializer should not write to iml files. Path:" + fileUrlString);
                }
                if (externalSystemOptions != null) {
                    Element componentTag = JDomSerializationUtil.createComponentElement("ExternalSystem");
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag, "externalSystem", externalSystemOptions.getExternalSystem());
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag, "externalSystemModuleGroup", externalSystemOptions.getExternalSystemModuleGroup());
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag, "externalSystemModuleType", externalSystemOptions.getExternalSystemModuleType());
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag, "externalSystemModuleVersion", externalSystemOptions.getExternalSystemModuleVersion());
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag, "linkedProjectId", externalSystemOptions.getLinkedProjectId());
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag, "linkedProjectPath", externalSystemOptions.getLinkedProjectPath());
                    ExternalModuleImlFileEntitiesSerializer.saveModuleOptions$saveOption(componentTag, "rootProjectPath", externalSystemOptions.getRootProjectPath());
                    Intrinsics.checkNotNull(fileUrlString);
                    writer.saveComponent(fileUrlString, "ExternalSystem", componentTag);
                }
                if (moduleType != null) break block7;
                ModuleCustomImlDataEntity moduleCustomImlDataEntity = customImlData;
                Map<String, String> componentTag = moduleCustomImlDataEntity != null ? moduleCustomImlDataEntity.getCustomModuleOptions() : null;
                if (componentTag == null || componentTag.isEmpty()) break block8;
            }
            Element componentTag = JDomSerializationUtil.createComponentElement("DeprecatedModuleOptionManager");
            if (moduleType != null) {
                componentTag.addContent(new Element("option").setAttribute("key", "type").setAttribute("value", moduleType));
            }
            if ((object = customImlData) != null && (object = object.getCustomModuleOptions()) != null) {
                Object $this$forEach$iv = object;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    componentTag.addContent(new Element("option").setAttribute("key", key).setAttribute("value", value));
                }
            }
            Intrinsics.checkNotNull(fileUrlString);
            writer.saveComponent(fileUrlString, "DeprecatedModuleOptionManager", componentTag);
        }
    }

    @Override
    @NotNull
    protected JpsImportedEntitySource createExternalEntitySource(@NotNull String externalSystemId) {
        Intrinsics.checkNotNullParameter(externalSystemId, "externalSystemId");
        return new JpsImportedEntitySource(this.getInternalEntitySource(), externalSystemId, true);
    }

    @Override
    @NotNull
    protected FacetsSerializer createFacetSerializer() {
        return new FacetsSerializer(this.getFileUrl(), this.getInternalEntitySource(), "ExternalFacetManager", this.getBaseDirPath(), true, this.getContext());
    }

    @Override
    @NotNull
    protected String getBaseDirPath() {
        return this.getModulePath$intellij_platform_workspace_jps().getPath();
    }

    @Override
    @NotNull
    public String toString() {
        return "ExternalModuleImlFileEntitiesSerializer(" + this.getFileUrl() + ")";
    }

    private static final void saveModuleOptions$saveOption(Element componentTag, String name2, String value) {
        if (value != null) {
            componentTag.setAttribute(name2, value);
        }
    }
}

